/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.service.impl;

import aQute.bnd.annotation.ProviderType;
import com.liferay.knowledge.base.configuration.KBGroupServiceConfiguration;
import com.liferay.knowledge.base.exception.KBCommentContentException;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.model.KBComment;
import com.liferay.knowledge.base.model.KBTemplate;
import com.liferay.knowledge.base.service.base.KBCommentLocalServiceBaseImpl;
import com.liferay.knowledge.base.service.util.AdminSubscriptionSender;
import com.liferay.knowledge.base.util.comparator.KBCommentCreateDateComparator;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.Function;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import com.liferay.ratings.kernel.model.RatingsEntry;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;

@ProviderType
public class KBCommentLocalServiceImpl
extends KBCommentLocalServiceBaseImpl {
    @ServiceReference(type=ConfigurationProvider.class)
    protected ConfigurationProvider configurationProvider;
    private static final Log _log = LogFactoryUtil.getLog(KBCommentLocalServiceImpl.class);

    public KBComment addKBComment(long userId, long classNameId, long classPK, String content, int userRating, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        long groupId = serviceContext.getScopeGroupId();
        Date now = new Date();
        this.validate(content);
        long kbCommentId = this.counterLocalService.increment();
        KBComment kbComment = this.kbCommentPersistence.create(kbCommentId);
        kbComment.setUuid(serviceContext.getUuid());
        kbComment.setGroupId(groupId);
        kbComment.setCompanyId(user.getCompanyId());
        kbComment.setUserId(user.getUserId());
        kbComment.setUserName(user.getFullName());
        kbComment.setCreateDate(serviceContext.getCreateDate(now));
        kbComment.setModifiedDate(serviceContext.getModifiedDate(now));
        kbComment.setClassNameId(classNameId);
        kbComment.setClassPK(classPK);
        kbComment.setContent(content);
        kbComment.setUserRating(userRating);
        kbComment.setStatus(1);
        this.kbCommentPersistence.update((BaseModel)kbComment);
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
        this.putTitle(extraDataJSONObject, kbComment);
        this.socialActivityLocalService.addActivity(userId, kbComment.getGroupId(), KBComment.class.getName(), kbCommentId, 5, extraDataJSONObject.toString(), 0L);
        this.notifySubscribers(userId, kbComment, serviceContext);
        return kbComment;
    }

    public KBComment addKBComment(long userId, long classNameId, long classPK, String content, ServiceContext serviceContext) throws PortalException {
        int userRating = this.getUserRating(userId, classNameId, classPK);
        return this.addKBComment(userId, classNameId, classPK, content, userRating, serviceContext);
    }

    @Override
    @SystemEvent(type=1)
    public KBComment deleteKBComment(KBComment kbComment) throws PortalException {
        this.kbCommentPersistence.remove((BaseModel)kbComment);
        this.socialActivityLocalService.deleteActivities(KBComment.class.getName(), kbComment.getKbCommentId());
        return kbComment;
    }

    @Override
    public KBComment deleteKBComment(long kbCommentId) throws PortalException {
        KBComment kbComment = this.kbCommentPersistence.findByPrimaryKey(kbCommentId);
        return this.kbCommentLocalService.deleteKBComment(kbComment);
    }

    public void deleteKBComments(String className, long classPK) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        List kbComments = this.kbCommentPersistence.findByC_C(classNameId, classPK);
        for (KBComment kbComment : kbComments) {
            this.kbCommentLocalService.deleteKBComment(kbComment);
        }
    }

    public KBComment getKBComment(long userId, String className, long classPK) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.kbCommentPersistence.findByU_C_C_Last(userId, classNameId, classPK, (OrderByComparator)new KBCommentCreateDateComparator());
    }

    public List<KBComment> getKBComments(long groupId, int status, int start, int end) {
        return this.kbCommentPersistence.findByG_S(groupId, status, start, end);
    }

    public List<KBComment> getKBComments(long groupId, int status, int start, int end, OrderByComparator<KBComment> obc) {
        return this.kbCommentPersistence.findByG_S(groupId, status, start, end, obc);
    }

    public List<KBComment> getKBComments(long groupId, int start, int end, OrderByComparator<KBComment> obc) {
        return this.kbCommentPersistence.findByGroupId(groupId, start, end, obc);
    }

    public List<KBComment> getKBComments(long userId, String className, long classPK, int start, int end, OrderByComparator<KBComment> orderByComparator) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.kbCommentPersistence.findByU_C_C(userId, classNameId, classPK, start, end, orderByComparator);
    }

    public List<KBComment> getKBComments(String className, long classPK, int status, int start, int end) {
        return this.getKBComments(className, classPK, status, start, end, (OrderByComparator<KBComment>)new KBCommentCreateDateComparator());
    }

    public List<KBComment> getKBComments(String className, long classPK, int status, int start, int end, OrderByComparator<KBComment> obc) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.kbCommentPersistence.findByC_C_S(classNameId, classPK, status, start, end, obc);
    }

    public List<KBComment> getKBComments(String className, long classPK, int start, int end, OrderByComparator orderByComparator) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.kbCommentPersistence.findByC_C(classNameId, classPK, start, end, orderByComparator);
    }

    public List<KBComment> getKBComments(String className, long classPK, int[] status, int start, int end) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.kbCommentPersistence.findByC_C_S(classNameId, classPK, status, start, end, (OrderByComparator)new KBCommentCreateDateComparator());
    }

    public int getKBCommentsCount(long groupId, int status) {
        return this.kbCommentPersistence.countByG_S(groupId, status);
    }

    public int getKBCommentsCount(long userId, String className, long classPK) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.kbCommentPersistence.countByU_C_C(userId, classNameId, classPK);
    }

    public int getKBCommentsCount(String className, long classPK) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.kbCommentPersistence.countByC_C(classNameId, classPK);
    }

    public int getKBCommentsCount(String className, long classPK, int status) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.kbCommentPersistence.countByC_C_S(classNameId, classPK, status);
    }

    public int getKBCommentsCount(String className, long classPK, int[] status) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.kbCommentPersistence.countByC_C_S(classNameId, classPK, status);
    }

    public KBComment updateKBComment(long kbCommentId, long classNameId, long classPK, String content, int userRating, int status, ServiceContext serviceContext) throws PortalException {
        this.validate(content);
        KBComment kbComment = this.kbCommentPersistence.findByPrimaryKey(kbCommentId);
        kbComment.setModifiedDate(serviceContext.getModifiedDate(null));
        kbComment.setClassNameId(classNameId);
        kbComment.setClassPK(classPK);
        kbComment.setContent(content);
        kbComment.setUserRating(userRating);
        kbComment.setStatus(status);
        this.kbCommentPersistence.update((BaseModel)kbComment);
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
        this.putTitle(extraDataJSONObject, kbComment);
        this.socialActivityLocalService.addActivity(kbComment.getUserId(), kbComment.getGroupId(), KBComment.class.getName(), kbCommentId, 6, extraDataJSONObject.toString(), 0L);
        return kbComment;
    }

    public KBComment updateKBComment(long kbCommentId, long classNameId, long classPK, String content, int status, ServiceContext serviceContext) throws PortalException {
        KBComment kbComment = this.kbCommentPersistence.findByPrimaryKey(kbCommentId);
        return this.updateKBComment(kbCommentId, classNameId, classPK, content, kbComment.getUserRating(), status, serviceContext);
    }

    public KBComment updateStatus(long userId, long kbCommentId, int status, ServiceContext serviceContext) throws PortalException {
        KBComment kbComment = this.kbCommentPersistence.findByPrimaryKey(kbCommentId);
        kbComment.setStatus(status);
        this.kbCommentPersistence.update((BaseModel)kbComment);
        this.notifySubscribers(userId, kbComment, serviceContext);
        return kbComment;
    }

    protected String getEmailKBArticleSuggestionNotificationBody(int status, KBGroupServiceConfiguration kbGroupServiceConfiguration) {
        if (status == 0) {
            return kbGroupServiceConfiguration.emailKBArticleSuggestionResolvedBody();
        }
        if (status == 2) {
            return kbGroupServiceConfiguration.emailKBArticleSuggestionInProgressBody();
        }
        if (status == 1) {
            return kbGroupServiceConfiguration.emailKBArticleSuggestionReceivedBody();
        }
        throw new IllegalArgumentException(String.format("Unknown suggestion status %s", status));
    }

    protected String getEmailKBArticleSuggestionNotificationSubject(int status, KBGroupServiceConfiguration kbGroupServiceConfiguration) {
        if (status == 0) {
            return kbGroupServiceConfiguration.emailKBArticleSuggestionResolvedSubject();
        }
        if (status == 2) {
            return kbGroupServiceConfiguration.emailKBArticleSuggestionInProgressSubject();
        }
        if (status == 1) {
            return kbGroupServiceConfiguration.emailKBArticleSuggestionReceivedSubject();
        }
        throw new IllegalArgumentException(String.format("Unknown suggestion status %s", status));
    }

    protected KBGroupServiceConfiguration getKBGroupServiceConfiguration(long groupId) throws ConfigurationException {
        return (KBGroupServiceConfiguration)this.configurationProvider.getGroupConfiguration(KBGroupServiceConfiguration.class, groupId);
    }

    protected int getUserRating(long userId, long classNameId, long classPK) throws PortalException {
        ClassName className = this.classNameLocalService.getClassName(classNameId);
        RatingsEntry ratingsEntry = this.ratingsEntryLocalService.fetchEntry(userId, className.getValue(), classPK);
        if (ratingsEntry == null) {
            return 2;
        }
        if (ratingsEntry.getScore() > 0.0) {
            return 1;
        }
        return 0;
    }

    protected boolean isSuggestionStatusChangeNotificationEnabled(int status, KBGroupServiceConfiguration kbGroupServiceConfiguration) {
        if (status == 0) {
            return kbGroupServiceConfiguration.emailKBArticleSuggestionResolvedEnabled();
        }
        if (status == 2) {
            return kbGroupServiceConfiguration.emailKBArticleSuggestionInProgressEnabled();
        }
        if (status == 1) {
            return kbGroupServiceConfiguration.emailKBArticleSuggestionReceivedEnabled();
        }
        return false;
    }

    protected void notifySubscribers(long userId, KBComment kbComment, ServiceContext serviceContext) throws PortalException {
        KBGroupServiceConfiguration kbGroupServiceConfiguration = this.getKBGroupServiceConfiguration(kbComment.getGroupId());
        if (!this.isSuggestionStatusChangeNotificationEnabled(kbComment.getStatus(), kbGroupServiceConfiguration)) {
            return;
        }
        String fromName = kbGroupServiceConfiguration.emailFromName();
        String fromAddress = kbGroupServiceConfiguration.emailFromAddress();
        String subject = this.getEmailKBArticleSuggestionNotificationSubject(kbComment.getStatus(), kbGroupServiceConfiguration);
        String body = this.getEmailKBArticleSuggestionNotificationBody(kbComment.getStatus(), kbGroupServiceConfiguration);
        KBArticle kbArticle = this.kbArticleLocalService.getLatestKBArticle(kbComment.getClassPK(), 0);
        String kbArticleContent = StringUtil.replace((String)kbArticle.getContent(), (String[])new String[]{"href=\"/", "src=\"/"}, (String[])new String[]{"href=\"" + serviceContext.getPortalURL() + "/", "src=\"" + serviceContext.getPortalURL() + "/"});
        AdminSubscriptionSender subscriptionSender = new AdminSubscriptionSender(kbArticle, serviceContext);
        subscriptionSender.setBody(body);
        subscriptionSender.setCompanyId(kbArticle.getCompanyId());
        subscriptionSender.setContextAttribute("[$ARTICLE_CONTENT$]", kbArticleContent, false);
        subscriptionSender.setContextAttribute("[$COMMENT_CONTENT$]", kbComment.getContent(), false);
        subscriptionSender.setContextCreatorUserPrefix("ARTICLE");
        subscriptionSender.setCreatorUserId(kbArticle.getUserId());
        subscriptionSender.setCurrentUserId(userId);
        subscriptionSender.setFrom(fromAddress, fromName);
        subscriptionSender.setHtmlFormat(true);
        CreateDateSerializableFunction createDateSerializableFunction = new CreateDateSerializableFunction(kbComment);
        subscriptionSender.setLocalizedContextAttribute("[$COMMENT_CREATE_DATE$]", createDateSerializableFunction, false);
        subscriptionSender.setMailId("kb_article", new Object[]{kbArticle.getKbArticleId()});
        subscriptionSender.setPortletId(serviceContext.getPortletId());
        subscriptionSender.setReplyToAddress(fromAddress);
        subscriptionSender.setScopeGroupId(kbArticle.getGroupId());
        subscriptionSender.setSubject(subject);
        User user = this.userLocalService.getUser(kbComment.getUserId());
        subscriptionSender.addRuntimeSubscribers(user.getEmailAddress(), user.getFullName());
        subscriptionSender.flushNotificationsAsync();
    }

    protected void putTitle(JSONObject jsonObject, KBComment kbComment) {
        KBArticle kbArticle = null;
        KBTemplate kbTemplate = null;
        String className = kbComment.getClassName();
        try {
            if (className.equals(KBArticle.class.getName())) {
                kbArticle = this.kbArticleLocalService.getLatestKBArticle(kbComment.getClassPK(), 0);
                jsonObject.put("title", kbArticle.getTitle());
            } else if (className.equals(KBTemplate.class.getName())) {
                kbTemplate = this.kbTemplateLocalService.getKBTemplate(kbComment.getClassPK());
                jsonObject.put("title", kbTemplate.getTitle());
            }
        }
        catch (Exception e) {
            _log.error((Throwable)e);
        }
    }

    protected void validate(String content) throws PortalException {
        if (Validator.isNull((String)content)) {
            throw new KBCommentContentException();
        }
    }

    private static class CreateDateSerializableFunction
    implements Function<Locale, String>,
    Serializable {
        private final KBComment _kbComment;

        public CreateDateSerializableFunction(KBComment statusKey) {
            this._kbComment = statusKey;
        }

        public String apply(Locale locale) {
            DateFormat dateFormat = DateFormatFactoryUtil.getDate((Locale)locale);
            return dateFormat.format(this._kbComment.getCreateDate());
        }
    }
}

