/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.internal.util;

import com.liferay.knowledge.base.exception.NoSuchArticleException;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.portal.kernel.exception.PortalException;
import java.util.List;

public abstract class BaseKBArticleSiblingNavigationHelper {
    public KBArticle[] getPreviousAndNextKBArticles(long kbArticleId) throws PortalException {
        KBArticle kbArticle = this.findKBArticle(kbArticleId);
        KBArticle[] previousAndNextKBArticles = this.getPreviousAndNextKBArticles(kbArticle);
        KBArticle previousKBArticle = this.getPreviousKBArticle(kbArticle, previousAndNextKBArticles[0]);
        KBArticle nextKBArticle = this.getNextKBArticle(kbArticle, previousAndNextKBArticles[2]);
        return new KBArticle[]{previousKBArticle, kbArticle, nextKBArticle};
    }

    protected abstract KBArticle fetchFirstChildKBArticle(KBArticle var1);

    protected abstract KBArticle fetchLastChildKBArticle(KBArticle var1);

    protected abstract List<KBArticle> findChildKBArticles(KBArticle var1);

    protected abstract KBArticle findKBArticle(long var1) throws NoSuchArticleException;

    protected KBArticle getNextAncestorKBArticle(long kbArticleId, KBArticle nextKBArticle) throws PortalException {
        if (nextKBArticle != null) {
            return nextKBArticle;
        }
        KBArticle kbArticle = this.findKBArticle(kbArticleId);
        KBArticle parentKBArticle = kbArticle.getParentKBArticle();
        if (parentKBArticle == null) {
            return null;
        }
        KBArticle[] previousAndNextKBArticles = this.getPreviousAndNextKBArticles(parentKBArticle);
        return this.getNextAncestorKBArticle(parentKBArticle.getKbArticleId(), previousAndNextKBArticles[2]);
    }

    protected KBArticle getNextKBArticle(KBArticle kbArticle, KBArticle nextKBArticle) throws PortalException {
        KBArticle firstChildKBArticle = this.fetchFirstChildKBArticle(kbArticle);
        if (firstChildKBArticle != null) {
            return firstChildKBArticle;
        }
        return this.getNextAncestorKBArticle(kbArticle.getKbArticleId(), nextKBArticle);
    }

    protected KBArticle[] getPreviousAndNextKBArticles(KBArticle kbArticle) {
        List<KBArticle> kbArticles = this.findChildKBArticles(kbArticle);
        int index = kbArticles.indexOf(kbArticle);
        KBArticle[] previousAndNextKBArticles = new KBArticle[]{null, kbArticle, null};
        if (index > 0) {
            previousAndNextKBArticles[0] = kbArticles.get(index - 1);
        }
        if (index < kbArticles.size() - 1) {
            previousAndNextKBArticles[2] = kbArticles.get(index + 1);
        }
        return previousAndNextKBArticles;
    }

    protected KBArticle getPreviousKBArticle(KBArticle kbArticle, KBArticle previousKBArticle) throws PortalException {
        if (previousKBArticle == null) {
            return kbArticle.getParentKBArticle();
        }
        KBArticle lastSiblingChildKBArticle = this.fetchLastChildKBArticle(previousKBArticle);
        if (lastSiblingChildKBArticle == null) {
            return previousKBArticle;
        }
        return lastSiblingChildKBArticle;
    }
}

