/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.test.util;

import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.service.JournalFolderLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.test.util.ServiceContextTestUtil;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import java.util.Objects;

public class JournalFolderFixture {
    private final JournalFolderLocalService _journalFolderLocalService;

    public JournalFolderFixture(JournalFolderLocalService journalFolderLocalService) {
        this._journalFolderLocalService = Objects.requireNonNull(journalFolderLocalService);
    }

    public JournalFolder addFolder(long userId, long groupId, long parentFolderId, String name) throws Exception {
        return this.addFolder(parentFolderId, name, ServiceContextTestUtil.getServiceContext((long)groupId, (long)userId));
    }

    public JournalFolder addFolder(long groupId, long parentFolderId, String name) throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)groupId, (long)TestPropsValues.getUserId());
        return this.addFolder(parentFolderId, name, serviceContext);
    }

    public JournalFolder addFolder(long groupId, String name) throws Exception {
        return this.addFolder(groupId, 0L, name);
    }

    public JournalFolder addFolder(long parentFolderId, String name, ServiceContext serviceContext) throws Exception {
        return this.addFolder(parentFolderId, name, "This is a test folder.", serviceContext);
    }

    public JournalFolder addFolder(long parentFolderId, String name, String description, ServiceContext serviceContext) throws Exception {
        JournalFolder folder = this._journalFolderLocalService.fetchFolder(serviceContext.getScopeGroupId(), parentFolderId, name);
        if (folder != null) {
            return folder;
        }
        return this._journalFolderLocalService.addFolder(serviceContext.getUserId(), serviceContext.getScopeGroupId(), parentFolderId, name, description, serviceContext);
    }
}

