/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.ip.geocoder;

import com.maxmind.geoip.Location;
import com.maxmind.geoip.regionName;

/**
 * @author Brian Wing Shun Chan
 */
public class IPInfo {

	public IPInfo() {
	}

	public IPInfo(String ipAddress, Location location) {
		_ipAddress = ipAddress;

		if (location != null) {
			_city = location.city;
			_countryCode = location.countryCode;
			_countryName = location.countryName;
			_latitude = location.latitude;
			_longitude = location.longitude;
			_postalCode = location.postalCode;
			_regionCode = location.region;

			_regionName = regionName.regionNameByCode(
				_countryCode, _regionCode);
		}
	}

	public String getCity() {
		return _city;
	}

	public String getCountryCode() {
		return _countryCode;
	}

	public String getCountryName() {
		return _countryName;
	}

	public String getIpAddress() {
		return _ipAddress;
	}

	public float getLatitude() {
		return _latitude;
	}

	public float getLongitude() {
		return _longitude;
	}

	public String getPostalCode() {
		return _postalCode;
	}

	public String getRegionCode() {
		return _regionCode;
	}

	public String getRegionName() {
		return _regionName;
	}

	public void setCity(String city) {
		_city = city;
	}

	public void setCountryCode(String countryCode) {
		_countryCode = countryCode;
	}

	public void setCountryName(String countryName) {
		_countryName = countryName;
	}

	public void setIpAddress(String ipAddress) {
		_ipAddress = ipAddress;
	}

	public void setLatitude(float latitude) {
		_latitude = latitude;
	}

	public void setLongitude(float longitude) {
		_longitude = longitude;
	}

	public void setPostalCode(String postalCode) {
		_postalCode = postalCode;
	}

	public void setRegionCode(String regionCode) {
		_regionCode = regionCode;
	}

	public void setRegionName(String regionName) {
		_regionName = regionName;
	}

	private String _city;
	private String _countryCode;
	private String _countryName;
	private String _ipAddress;
	private float _latitude;
	private float _longitude;
	private String _postalCode;
	private String _regionCode;
	private String _regionName;

}