/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.imageio.plugins.internal.activator;

import com.liferay.portal.kernel.util.ArrayUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;
import org.monte.media.jpeg.CMYKJPEGImageReaderSpi;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class ImageIOPluginsBundleActivator
implements BundleActivator {
    private final Set<ImageReaderSpi> _imageReaderSpis = new HashSet<ImageReaderSpi>();
    private final Set<ImageWriterSpi> _imageWriterSpis = new HashSet<ImageWriterSpi>();

    public void start(BundleContext bundleContext) {
        this._register(ImageReaderSpi.class, this._imageReaderSpis);
        this._register(ImageWriterSpi.class, this._imageWriterSpis);
        this.orderImageReaderSpis();
    }

    public void stop(BundleContext bundleContext) {
        this._unregister(this._imageReaderSpis);
        this._unregister(this._imageWriterSpis);
    }

    protected void orderImageReaderSpis() {
        IIORegistry defaultIIORegistry = IIORegistry.getDefaultInstance();
        ImageReaderSpi firstImageReaderSpi = null;
        ImageReaderSpi secondImageReaderSpi = null;
        Iterator<ImageReaderSpi> iterator = defaultIIORegistry.getServiceProviders(ImageReaderSpi.class, true);
        while (iterator.hasNext()) {
            ImageReaderSpi imageReaderSpi = iterator.next();
            if (imageReaderSpi instanceof CMYKJPEGImageReaderSpi) {
                secondImageReaderSpi = imageReaderSpi;
                continue;
            }
            String[] formatNames = imageReaderSpi.getFormatNames();
            if (!ArrayUtil.contains((String[])formatNames, (String)"jpg", (boolean)true) && !ArrayUtil.contains((String[])formatNames, (String)"jpeg", (boolean)true)) continue;
            firstImageReaderSpi = imageReaderSpi;
        }
        if (firstImageReaderSpi != null && secondImageReaderSpi != null) {
            defaultIIORegistry.setOrdering(ImageReaderSpi.class, firstImageReaderSpi, secondImageReaderSpi);
        }
    }

    private <T> void _register(Class<T> clazz, Set<T> registeredProviders) {
        IIORegistry iioRegistry = IIORegistry.getDefaultInstance();
        Iterator<T> iterator = ServiceRegistry.lookupProviders(clazz, ImageIOPluginsBundleActivator.class.getClassLoader());
        while (iterator.hasNext()) {
            registeredProviders.add(iterator.next());
        }
        iioRegistry.registerServiceProviders(registeredProviders.iterator());
    }

    private <T> void _unregister(Set<T> registeredProviders) {
        IIORegistry iioRegistry = IIORegistry.getDefaultInstance();
        for (T provider : registeredProviders) {
            iioRegistry.deregisterServiceProvider(provider);
        }
        registeredProviders.clear();
    }
}

