/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.imageio.plugins.internal.activator;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class ImageIOPluginsBundleActivator
implements BundleActivator {
    private final Set<ImageReaderSpi> _imageReaderSpiSet = new HashSet<ImageReaderSpi>();
    private final Set<ImageWriterSpi> _imageWriterSpiSet = new HashSet<ImageWriterSpi>();

    public void start(BundleContext bundleContext) {
        this._register(ImageReaderSpi.class, this._imageReaderSpiSet);
        this._register(ImageWriterSpi.class, this._imageWriterSpiSet);
    }

    public void stop(BundleContext bundleContext) {
        this._unregister(this._imageReaderSpiSet);
        this._unregister(this._imageWriterSpiSet);
    }

    private <T> void _register(Class<T> clazz, Set<T> registeredProviders) {
        IIORegistry iioRegistry = IIORegistry.getDefaultInstance();
        Iterator<T> providers = ServiceRegistry.lookupProviders(clazz, ImageIOPluginsBundleActivator.class.getClassLoader());
        while (providers.hasNext()) {
            registeredProviders.add(providers.next());
        }
        iioRegistry.registerServiceProviders(registeredProviders.iterator());
    }

    private <T> void _unregister(Set<T> registeredProviders) {
        IIORegistry iioRegistry = IIORegistry.getDefaultInstance();
        for (T provider : registeredProviders) {
            iioRegistry.deregisterServiceProvider(provider);
        }
        registeredProviders.clear();
    }
}

