/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.object.internal.dto.v1_0.converter;

import com.liferay.headless.delivery.dto.v1_0.util.CreatorUtil;
import com.liferay.headless.object.dto.v1_0.ObjectEntryFolder;
import com.liferay.headless.object.dto.v1_0.ParentObjectEntryFolderBrief;
import com.liferay.object.service.ObjectEntryFolderLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedFieldsSupplier;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import com.liferay.trash.model.TrashEntry;
import com.liferay.trash.service.TrashEntryLocalService;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.object.model.ObjectEntryFolder"}, service={DTOConverter.class})
public class ObjectEntryFolderDTOConverter
implements DTOConverter<com.liferay.object.model.ObjectEntryFolder, ObjectEntryFolder> {
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private ObjectEntryFolderLocalService _objectEntryFolderLocalService;
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private TrashEntryLocalService _trashEntryLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public String getContentType() {
        return ObjectEntryFolder.class.getSimpleName();
    }

    public ObjectEntryFolder toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final com.liferay.object.model.ObjectEntryFolder objectEntryFolder = this._objectEntryFolderLocalService.getObjectEntryFolder(((Long)dtoConverterContext.getId()).longValue());
        final com.liferay.object.model.ObjectEntryFolder parentObjectEntryFolder = this._getParentObjectEntryFolder(objectEntryFolder);
        TrashEntry trashEntry = null;
        if (objectEntryFolder.getStatus() == 8) {
            trashEntry = this._trashEntryLocalService.fetchEntry(com.liferay.object.model.ObjectEntryFolder.class.getName(), objectEntryFolder.getObjectEntryFolderId());
        }
        final TrashEntry finalTrashEntry = trashEntry;
        return new ObjectEntryFolder(){
            {
                this.setActions(() -> ((DTOConverterContext)dtoConverterContext).getActions());
                this.setCreator(() -> CreatorUtil.toCreator((DTOConverterContext)dtoConverterContext, (Portal)ObjectEntryFolderDTOConverter.this._portal, (User)ObjectEntryFolderDTOConverter.this._userLocalService.fetchUser(objectEntryFolder.getUserId())));
                this.setDateCreated(() -> ((com.liferay.object.model.ObjectEntryFolder)objectEntryFolder).getCreateDate());
                this.setDateModified(() -> ((com.liferay.object.model.ObjectEntryFolder)objectEntryFolder).getModifiedDate());
                this.setDescription(() -> ((com.liferay.object.model.ObjectEntryFolder)objectEntryFolder).getDescription());
                this.setExternalReferenceCode(() -> ((com.liferay.object.model.ObjectEntryFolder)objectEntryFolder).getExternalReferenceCode());
                this.setId(() -> ((com.liferay.object.model.ObjectEntryFolder)objectEntryFolder).getObjectEntryFolderId());
                this.setLabel(() -> objectEntryFolder.getLabel(dtoConverterContext.getLocale()));
                this.setLabel_i18n(() -> LocalizedMapUtil.getLanguageIdMap((Map)objectEntryFolder.getLabelMap()));
                this.setNumberOfObjectEntries(() -> (Integer)NestedFieldsSupplier.supply((String)"numberOfObjectEntries", nestedField -> ObjectEntryFolderDTOConverter.this._objectEntryLocalService.getObjectEntryFolderObjectEntriesCount(objectEntryFolder.getGroupId(), objectEntryFolder.getObjectEntryFolderId())));
                this.setNumberOfObjectEntryFolders(() -> (Integer)NestedFieldsSupplier.supply((String)"numberOfObjectEntryFolders", nestedField -> ObjectEntryFolderDTOConverter.this._objectEntryFolderLocalService.getObjectEntryFoldersCount(objectEntryFolder.getGroupId(), objectEntryFolder.getCompanyId(), objectEntryFolder.getObjectEntryFolderId())));
                this.setParentObjectEntryFolderBrief(() -> (ParentObjectEntryFolderBrief)NestedFieldsSupplier.supply((String)"parentObjectEntryFolderBrief", nestedField -> ObjectEntryFolderDTOConverter.this._getParentObjectEntryFolderBrief(dtoConverterContext, parentObjectEntryFolder)));
                this.setParentObjectEntryFolderExternalReferenceCode(() -> {
                    if (parentObjectEntryFolder != null) {
                        return parentObjectEntryFolder.getExternalReferenceCode();
                    }
                    return null;
                });
                this.setParentObjectEntryFolderId(() -> {
                    if (parentObjectEntryFolder != null) {
                        return parentObjectEntryFolder.getObjectEntryFolderId();
                    }
                    return null;
                });
                this.setRemovedBy(() -> {
                    if (finalTrashEntry != null) {
                        return CreatorUtil.toCreator((DTOConverterContext)dtoConverterContext, (Portal)ObjectEntryFolderDTOConverter.this._portal, (User)ObjectEntryFolderDTOConverter.this._userLocalService.fetchUser(finalTrashEntry.getUserId()));
                    }
                    return null;
                });
                this.setRemovedDate(() -> {
                    if (finalTrashEntry != null) {
                        return finalTrashEntry.getCreateDate();
                    }
                    return null;
                });
                this.setScopeKey(() -> {
                    Group group = ObjectEntryFolderDTOConverter.this._groupLocalService.fetchGroup(objectEntryFolder.getGroupId());
                    if (group == null) {
                        return String.valueOf(objectEntryFolder.getGroupId());
                    }
                    return group.getGroupKey();
                });
                this.setTitle(() -> ((com.liferay.object.model.ObjectEntryFolder)objectEntryFolder).getName());
            }
        };
    }

    private com.liferay.object.model.ObjectEntryFolder _getParentObjectEntryFolder(com.liferay.object.model.ObjectEntryFolder objectEntryFolder) throws Exception {
        if (objectEntryFolder.getParentObjectEntryFolderId() > 0L) {
            return this._objectEntryFolderLocalService.getObjectEntryFolder(objectEntryFolder.getParentObjectEntryFolderId());
        }
        return null;
    }

    private ParentObjectEntryFolderBrief _getParentObjectEntryFolderBrief(final DTOConverterContext dtoConverterContext, final com.liferay.object.model.ObjectEntryFolder parentObjectEntryFolder) {
        if (parentObjectEntryFolder == null) {
            return null;
        }
        return new ParentObjectEntryFolderBrief(){
            {
                this.setExternalReferenceCode(() -> ((com.liferay.object.model.ObjectEntryFolder)parentObjectEntryFolder).getExternalReferenceCode());
                this.setId(() -> ((com.liferay.object.model.ObjectEntryFolder)parentObjectEntryFolder).getObjectEntryFolderId());
                this.setLabel(() -> parentObjectEntryFolder.getLabel(dtoConverterContext.getLocale()));
                this.setLabel_i18n(() -> LocalizedMapUtil.getLanguageIdMap((Map)parentObjectEntryFolder.getLabelMap()));
                this.setTitle(() -> ((com.liferay.object.model.ObjectEntryFolder)parentObjectEntryFolder).getName());
            }
        };
    }
}

