/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.cms.internal.resource.v1_0;

import com.liferay.depot.model.DepotEntry;
import com.liferay.headless.cms.dto.v1_0.AssetPermissionAction;
import com.liferay.headless.cms.internal.resource.v1_0.BaseAssetPermissionActionResourceImpl;
import com.liferay.headless.cms.resource.v1_0.AssetPermissionActionResource;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectEntryFolder;
import com.liferay.object.rest.filter.factory.FilterFactory;
import com.liferay.object.service.ObjectEntryFolderService;
import com.liferay.object.service.ObjectEntryService;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.site.cms.site.initializer.util.CMSDefaultPermissionUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/asset-permission-action.properties"}, scope=ServiceScope.PROTOTYPE, service={AssetPermissionActionResource.class})
public class AssetPermissionActionResourceImpl
extends BaseAssetPermissionActionResourceImpl {
    @Reference(target="(filter.factory.key=default)")
    private FilterFactory<Predicate> _filterFactory;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference(target="(model.class.name=com.liferay.object.model.ObjectEntryFolder)")
    private ModelResourcePermission<ObjectEntryFolder> _objectEntryFolderModelResourcePermission;
    @Reference
    private ObjectEntryFolderService _objectEntryFolderService;
    @Reference
    private ObjectEntryService _objectEntryService;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private RoleLocalService _roleLocalService;

    @Override
    public AssetPermissionAction postAssetPermission(AssetPermissionAction assetPermissionAction) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        if (AssetPermissionAction.Type.RESET_ASSET_PERMISSION_ACTION.equals((Object)assetPermissionAction.getType())) {
            this._executeResetAssetPermissionAction(assetPermissionAction);
        }
        return assetPermissionAction;
    }

    private void _executeResetAssetPermissionAction(AssetPermissionAction assetPermissionAction) throws Exception {
        String className = assetPermissionAction.getClassName();
        if (className.startsWith(ObjectDefinition.class.getName())) {
            ObjectEntry objectEntry = this._objectEntryService.getObjectEntry(assetPermissionAction.getClassPK().longValue());
            ModelResourcePermission modelResourcePermission = this._objectEntryService.getModelResourcePermission(objectEntry.getObjectDefinitionId());
            modelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), (ClassedModel)objectEntry, "PERMISSIONS");
            JSONObject jsonObject = this._getCMSDefaultPermissionJSONObject(objectEntry.getGroupId(), objectEntry.getObjectEntryFolderId());
            ObjectEntryFolder rootObjectEntryFolder = this._getRootObjectEntryFolder(objectEntry);
            if (rootObjectEntryFolder == null) {
                return;
            }
            JSONObject objectEntryJSONObject = jsonObject.getJSONObject(rootObjectEntryFolder.getExternalReferenceCode());
            if (objectEntryJSONObject == null) {
                return;
            }
            this._setResourcePermissions(objectEntry.getModelClassName(), objectEntry.getCompanyId(), objectEntry.getObjectEntryId(), objectEntryJSONObject);
        } else if (className.equals(ObjectEntryFolder.class.getName())) {
            ObjectEntryFolder objectEntryFolder = this._objectEntryFolderService.getObjectEntryFolder(assetPermissionAction.getClassPK().longValue());
            this._objectEntryFolderModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), objectEntryFolder.getObjectEntryFolderId(), "PERMISSIONS");
            JSONObject jsonObject = this._getCMSDefaultPermissionJSONObject(objectEntryFolder.getGroupId(), objectEntryFolder.getParentObjectEntryFolderId());
            this._setResourcePermissions(objectEntryFolder.getModelClassName(), objectEntryFolder.getCompanyId(), objectEntryFolder.getObjectEntryFolderId(), jsonObject.getJSONObject("OBJECT_ENTRY_FOLDERS"));
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private JSONObject _getCMSDefaultPermissionJSONObject(long groupId, long objectEntryFolderId) throws Exception {
        ObjectEntryFolder objectEntryFolder;
        JSONObject jsonObject;
        if (objectEntryFolderId != 0L && (jsonObject = CMSDefaultPermissionUtil.getJSONObject((long)(objectEntryFolder = this._objectEntryFolderService.getObjectEntryFolder(objectEntryFolderId)).getCompanyId(), (long)objectEntryFolder.getUserId(), (String)objectEntryFolder.getExternalReferenceCode(), (String)objectEntryFolder.getModelClassName(), this._filterFactory)) != null && !JSONUtil.isEmpty((JSONObject)jsonObject)) {
            return jsonObject;
        }
        Group group = this._groupLocalService.getGroup(groupId);
        return CMSDefaultPermissionUtil.getJSONObject((long)group.getCompanyId(), (long)group.getCreatorUserId(), (String)group.getExternalReferenceCode(), (String)DepotEntry.class.getName(), this._filterFactory);
    }

    private ObjectEntryFolder _getRootObjectEntryFolder(ObjectEntry objectEntry) throws Exception {
        ObjectEntryFolder objectEntryFolder = this._objectEntryFolderService.fetchObjectEntryFolder(objectEntry.getObjectEntryFolderId());
        if (objectEntryFolder == null) {
            return null;
        }
        if (Objects.equals(objectEntryFolder.getExternalReferenceCode(), "L_CONTENTS") || Objects.equals(objectEntryFolder.getExternalReferenceCode(), "L_FILES")) {
            return objectEntryFolder;
        }
        String[] parts = StringUtil.split((String)objectEntryFolder.getTreePath(), (char)'/');
        if (parts.length <= 2) {
            return null;
        }
        return this._objectEntryFolderService.fetchObjectEntryFolder(GetterUtil.getLong((String)parts[1]));
    }

    private void _setResourcePermissions(String className, long companyId, long id, JSONObject jsonObject) throws Exception {
        this._resourcePermissionLocalService.deleteResourcePermissions(companyId, className, 4, String.valueOf(id));
        List resourceActions = ResourceActionsUtil.getResourceActions((String)className);
        Iterator iterator = jsonObject.keys();
        while (iterator.hasNext()) {
            Role role;
            String key = (String)iterator.next();
            JSONArray jsonArray = jsonObject.getJSONArray(key);
            if (jsonArray == null || JSONUtil.isEmpty((JSONArray)jsonArray) || (role = this._roleLocalService.fetchRole(companyId, key)) == null) continue;
            this._resourcePermissionLocalService.setResourcePermissions(companyId, className, 4, String.valueOf(id), role.getRoleId(), (String[])ArrayUtil.filter((Object[])JSONUtil.toStringArray((JSONArray)jsonArray), action -> resourceActions.contains(action)));
        }
    }
}

