/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.asset.library.internal.resource.v1_0;

import com.liferay.headless.asset.library.dto.v1_0.Site;
import com.liferay.headless.asset.library.resource.v1_0.SiteResource;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.odata.sort.SortParserProvider;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.ActionUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1.0")
public abstract class BaseSiteResourceImpl
implements SiteResource {
    protected AcceptLanguage contextAcceptLanguage;
    protected Company contextCompany;
    protected HttpServletRequest contextHttpServletRequest;
    protected HttpServletResponse contextHttpServletResponse;
    protected Object contextScopeChecker;
    protected UriInfo contextUriInfo;
    protected User contextUser;
    protected ExpressionConvert<Filter> expressionConvert;
    protected FilterParserProvider filterParserProvider;
    protected GroupLocalService groupLocalService;
    protected ResourceActionLocalService resourceActionLocalService;
    protected ResourcePermissionLocalService resourcePermissionLocalService;
    protected RoleLocalService roleLocalService;
    protected SortParserProvider sortParserProvider;
    private static final Log _log = LogFactoryUtil.getLog(BaseSiteResourceImpl.class);

    @Operation(description="Disconnects the site with the given external reference code from the asset library.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryExternalReferenceCode"), @Parameter(in=ParameterIn.PATH, name="siteExternalReferenceCode")})
    @Tags(value={@Tag(name="Site")})
    @DELETE
    @Path(value="/asset-libraries/by-external-reference-code/{assetLibraryExternalReferenceCode}/sites/by-external-reference-code/{siteExternalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteAssetLibraryByExternalReferenceCodeAssetLibraryExternalReferenceCodeSiteByExternalReferenceCodeSiteExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="assetLibraryExternalReferenceCode") String assetLibraryExternalReferenceCode, @Parameter(hidden=true) @NotNull @PathParam(value="siteExternalReferenceCode") String siteExternalReferenceCode) throws Exception {
    }

    @Operation(description="Gets a site from the asset library using the provided external reference codes.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryExternalReferenceCode"), @Parameter(in=ParameterIn.PATH, name="siteExternalReferenceCode")})
    @Tags(value={@Tag(name="Site")})
    @GET
    @Path(value="/asset-libraries/by-external-reference-code/{assetLibraryExternalReferenceCode}/sites/by-external-reference-code/{siteExternalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public Site getAssetLibraryByExternalReferenceCodeAssetLibraryExternalReferenceCodeSiteByExternalReferenceCodeSiteExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="assetLibraryExternalReferenceCode") String assetLibraryExternalReferenceCode, @Parameter(hidden=true) @NotNull @PathParam(value="siteExternalReferenceCode") String siteExternalReferenceCode) throws Exception {
        return new Site();
    }

    @Operation(description="Connects the site with the given external reference code to the asset library.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryExternalReferenceCode"), @Parameter(in=ParameterIn.PATH, name="siteExternalReferenceCode")})
    @Tags(value={@Tag(name="Site")})
    @Path(value="/asset-libraries/by-external-reference-code/{assetLibraryExternalReferenceCode}/sites/by-external-reference-code/{siteExternalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public Site putAssetLibraryByExternalReferenceCodeAssetLibraryExternalReferenceCodeSiteByExternalReferenceCodeSiteExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="assetLibraryExternalReferenceCode") String assetLibraryExternalReferenceCode, @Parameter(hidden=true) @NotNull @PathParam(value="siteExternalReferenceCode") String siteExternalReferenceCode) throws Exception {
        return new Site();
    }

    @Operation(description="Get the asset library's with the provided external reference code connected sites. Results can be paginated.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize")})
    @Tags(value={@Tag(name="Site")})
    @GET
    @Path(value="/asset-libraries/by-external-reference-code/{externalReferenceCode}/sites")
    @Produces(value={"application/json", "application/xml"})
    public Page<Site> getAssetLibraryByExternalReferenceCodeSitesPage(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode, @Context Pagination pagination) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Operation(description="Get the asset library's connected sites. Results can be paginated.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryId"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize")})
    @Tags(value={@Tag(name="Site")})
    @GET
    @Path(value="/asset-libraries/{assetLibraryId}/sites")
    @Produces(value={"application/json", "application/xml"})
    public Page<Site> getAssetLibrarySitesPage(@Parameter(hidden=true) @NotNull @PathParam(value="assetLibraryId") Long assetLibraryId, @Context Pagination pagination) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Operation(description="Disconnects the site from the asset library.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryId"), @Parameter(in=ParameterIn.PATH, name="siteId")})
    @Tags(value={@Tag(name="Site")})
    @DELETE
    @Path(value="/asset-libraries/{assetLibraryId}/sites/{siteId}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteAssetLibrarySite(@Parameter(hidden=true) @NotNull @PathParam(value="assetLibraryId") Long assetLibraryId, @Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId) throws Exception {
    }

    @Operation(description="Gets a site connected to the asset library.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryId"), @Parameter(in=ParameterIn.PATH, name="siteId")})
    @Tags(value={@Tag(name="Site")})
    @GET
    @Path(value="/asset-libraries/{assetLibraryId}/sites/{siteId}")
    @Produces(value={"application/json", "application/xml"})
    public Site getAssetLibrarySite(@Parameter(hidden=true) @NotNull @PathParam(value="assetLibraryId") Long assetLibraryId, @Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId) throws Exception {
        return new Site();
    }

    @Operation(description="Connects the site to the asset library.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryId"), @Parameter(in=ParameterIn.PATH, name="siteId")})
    @Tags(value={@Tag(name="Site")})
    @Path(value="/asset-libraries/{assetLibraryId}/sites/{siteId}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public Site putAssetLibrarySite(@Parameter(hidden=true) @NotNull @PathParam(value="assetLibraryId") Long assetLibraryId, @Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId) throws Exception {
        return new Site();
    }

    public void setContextAcceptLanguage(AcceptLanguage contextAcceptLanguage) {
        this.contextAcceptLanguage = contextAcceptLanguage;
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    public void setContextHttpServletRequest(HttpServletRequest contextHttpServletRequest) {
        if (contextHttpServletRequest != null && contextHttpServletRequest.getAttribute("CTX") == null) {
            contextHttpServletRequest.setAttribute("CTX", (Object)ServletContextPool.get((String)""));
        }
        this.contextHttpServletRequest = contextHttpServletRequest;
    }

    public void setContextHttpServletResponse(HttpServletResponse contextHttpServletResponse) {
        this.contextHttpServletResponse = contextHttpServletResponse;
    }

    public void setContextUriInfo(UriInfo contextUriInfo) {
        this.contextUriInfo = contextUriInfo;
    }

    public void setContextUser(User contextUser) {
        this.contextUser = contextUser;
    }

    public void setExpressionConvert(ExpressionConvert<Filter> expressionConvert) {
        this.expressionConvert = expressionConvert;
    }

    public void setFilterParserProvider(FilterParserProvider filterParserProvider) {
        this.filterParserProvider = filterParserProvider;
    }

    public void setGroupLocalService(GroupLocalService groupLocalService) {
        this.groupLocalService = groupLocalService;
    }

    public void setResourceActionLocalService(ResourceActionLocalService resourceActionLocalService) {
        this.resourceActionLocalService = resourceActionLocalService;
    }

    public void setResourcePermissionLocalService(ResourcePermissionLocalService resourcePermissionLocalService) {
        this.resourcePermissionLocalService = resourcePermissionLocalService;
    }

    public void setRoleLocalService(RoleLocalService roleLocalService) {
        this.roleLocalService = roleLocalService;
    }

    public void setSortParserProvider(SortParserProvider sortParserProvider) {
        this.sortParserProvider = sortParserProvider;
    }

    protected Map<String, String> addAction(String actionName, GroupedModel groupedModel, String methodName) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (GroupedModel)groupedModel, (String)methodName, (Object)this.contextScopeChecker, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, Long ownerId, String permissionName, Long siteId) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (Long)ownerId, (String)permissionName, (Long)siteId, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, ModelResourcePermission modelResourcePermission) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (ModelResourcePermission)modelResourcePermission, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, String methodName, String permissionName, Long siteId) {
        return this.addAction(actionName, siteId, methodName, null, permissionName, siteId);
    }

    protected <T, R, E extends Throwable> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] transform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<? extends R> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<? extends R> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> transformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }

    protected <T, R, E extends Throwable> long[] transformToLongArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) {
        try {
            return this.unsafeTransformToLongArray(collection, unsafeFunction);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<? extends R> clazz) throws E {
        return TransformUtil.unsafeTransform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<? extends R> clazz) throws E {
        return TransformUtil.unsafeTransformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToList((Object[])array, unsafeFunction);
    }

    protected <T, R, E extends Throwable> long[] unsafeTransformToLongArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return (long[])this._unsafeTransformToPrimitiveArray(collection, unsafeFunction, long[].class);
    }

    private <T, R, E extends Throwable> Object _unsafeTransformToPrimitiveArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) throws E {
        List<R> list = this.unsafeTransform(collection, unsafeFunction);
        Object array = clazz.cast(Array.newInstance(clazz.getComponentType(), list.size()));
        for (int i = 0; i < list.size(); ++i) {
            Array.set(array, i, list.get(i));
        }
        return array;
    }
}

