/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.resource.v1_0;

import com.liferay.headless.admin.site.dto.v1_0.ContentPageSpecification;
import com.liferay.headless.admin.site.dto.v1_0.PageSpecification;
import com.liferay.headless.admin.site.dto.v1_0.UtilityPage;
import com.liferay.headless.admin.site.dto.v1_0.UtilityPageSEOSettings;
import com.liferay.headless.admin.site.dto.v1_0.UtilityPageSettings;
import com.liferay.headless.admin.site.internal.resource.v1_0.BaseUtilityPageResourceImpl;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.GroupUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.LayoutUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.ServiceContextUtil;
import com.liferay.headless.admin.site.resource.v1_0.UtilityPageResource;
import com.liferay.layout.utility.page.model.LayoutUtilityPageEntry;
import com.liferay.layout.utility.page.service.LayoutUtilityPageEntryService;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/utility-page.properties"}, scope=ServiceScope.PROTOTYPE, service={UtilityPageResource.class})
public class UtilityPageResourceImpl
extends BaseUtilityPageResourceImpl {
    private static final Map<UtilityPage.Type, String> _externalToInternalValuesMap = HashMapBuilder.put((Object)UtilityPage.Type.COOKIE_POLICY, (Object)"COOKIE_POLICY").put((Object)UtilityPage.Type.CREATE_ACCOUNT, (Object)"CREATE_ACCOUNT").put((Object)UtilityPage.Type.ERROR, (Object)"STATUS").put((Object)UtilityPage.Type.ERROR_CODE404, (Object)"SC_NOT_FOUND").put((Object)UtilityPage.Type.ERROR_CODE500, (Object)"SC_INTERNAL_SERVER_ERROR").put((Object)UtilityPage.Type.FORGOT_PASSWORD, (Object)"FORGOT_PASSWORD").put((Object)UtilityPage.Type.LOGIN, (Object)"LOGIN").put((Object)UtilityPage.Type.TERMS_OF_USE, (Object)"TERMS_OF_USE").build();
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutUtilityPageEntryService _layoutUtilityPageEntryService;
    @Reference(target="(component.name=com.liferay.headless.admin.site.internal.dto.v1_0.converter.PageSpecificationDTOConverter)")
    private DTOConverter<Layout, PageSpecification> _pageSpecificationDTOConverter;
    @Reference
    private Portal _portal;
    @Reference(target="(component.name=com.liferay.headless.admin.site.internal.dto.v1_0.converter.UtilityPageDTOConverter)")
    private DTOConverter<LayoutUtilityPageEntry, UtilityPage> _utilityPageDTOConverter;

    @Override
    public void deleteSiteSiteByExternalReferenceCodeUtilityPage(String siteExternalReferenceCode, String utilityPageExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        this._layoutUtilityPageEntryService.deleteLayoutUtilityPageEntry(utilityPageExternalReferenceCode, GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode));
    }

    @Override
    public UtilityPage getSiteSiteByExternalReferenceCodeUtilityPage(String siteExternalReferenceCode, String utilityPageExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        return (UtilityPage)this._utilityPageDTOConverter.toDTO((Object)this._layoutUtilityPageEntryService.getLayoutUtilityPageEntryByExternalReferenceCode(utilityPageExternalReferenceCode, GroupUtil.getGroupId(true, this.contextCompany.getCompanyId(), siteExternalReferenceCode)));
    }

    @Override
    public Page<UtilityPage> getSiteSiteByExternalReferenceCodeUtilityPagesPage(String siteExternalReferenceCode, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        long groupId = GroupUtil.getGroupId(true, this.contextCompany.getCompanyId(), siteExternalReferenceCode);
        if (Validator.isNull((String)search)) {
            return Page.of(this.transform(this._layoutUtilityPageEntryService.getLayoutUtilityPageEntries(groupId, pagination.getStartPosition(), pagination.getEndPosition(), null), layoutUtilityPageEntry -> (UtilityPage)this._utilityPageDTOConverter.toDTO(layoutUtilityPageEntry)), (Pagination)pagination, (long)this._layoutUtilityPageEntryService.getLayoutUtilityPageEntriesCount(groupId));
        }
        return Page.of(this.transform(this._layoutUtilityPageEntryService.getLayoutUtilityPageEntries(groupId, search, null, pagination.getStartPosition(), pagination.getEndPosition(), null), layoutUtilityPageEntry -> (UtilityPage)this._utilityPageDTOConverter.toDTO(layoutUtilityPageEntry)), (Pagination)pagination, (long)this._layoutUtilityPageEntryService.getLayoutUtilityPageEntriesCount(groupId, search, null));
    }

    @Override
    public UtilityPage postSiteSiteByExternalReferenceCodeUtilityPage(String siteExternalReferenceCode, UtilityPage utilityPage) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        return this._addLayoutUtilityPageEntry(GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode), utilityPage);
    }

    @Override
    public ContentPageSpecification postSiteSiteByExternalReferenceCodeUtilityPagePageSpecification(String siteExternalReferenceCode, String utilityPageExternalReferenceCode, ContentPageSpecification contentPageSpecification) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        LayoutUtilityPageEntry layoutUtilityPageEntry = this._layoutUtilityPageEntryService.getLayoutUtilityPageEntryByExternalReferenceCode(utilityPageExternalReferenceCode, GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode));
        return (ContentPageSpecification)this._pageSpecificationDTOConverter.toDTO((Object)LayoutUtil.addDraftToLayout(contentPageSpecification, this._layoutLocalService.getLayout(layoutUtilityPageEntry.getPlid()), ServiceContextUtil.createServiceContext(layoutUtilityPageEntry.getGroupId(), this.contextHttpServletRequest, this.contextUser.getUserId())));
    }

    @Override
    public UtilityPage putSiteSiteByExternalReferenceCodeUtilityPage(String siteExternalReferenceCode, String utilityPageExternalReferenceCode, UtilityPage utilityPage) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        long groupId = GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode);
        LayoutUtilityPageEntry layoutUtilityPageEntry = this._layoutUtilityPageEntryService.fetchLayoutUtilityPageEntryByExternalReferenceCode(utilityPageExternalReferenceCode, groupId);
        if (layoutUtilityPageEntry == null) {
            return this._addLayoutUtilityPageEntry(groupId, utilityPage);
        }
        Layout layout = this._layoutLocalService.getLayout(layoutUtilityPageEntry.getPlid());
        UtilityPageSettings utilityPageSettings = utilityPage.getUtilityPageSettings();
        UtilityPageSEOSettings utilityPageSEOSettings = utilityPageSettings.getSeoSettings();
        LayoutUtil.updateContentLayout(layout, layout.getNameMap(), LocalizedMapUtil.getLocalizedMap((Map)utilityPageSEOSettings.getHtmlTitle_i18n()), LocalizedMapUtil.getLocalizedMap((Map)utilityPageSEOSettings.getDescription_i18n()), utilityPage.getPageSpecifications(), this._getServiceContext(groupId, utilityPage));
        if (Validator.isNotNull((Object)utilityPage.getMarkedAsDefault())) {
            if (GetterUtil.getBoolean((Object)utilityPage.getMarkedAsDefault()) && !layoutUtilityPageEntry.isDefaultLayoutUtilityPageEntry()) {
                layoutUtilityPageEntry = this._layoutUtilityPageEntryService.setDefaultLayoutUtilityPageEntry(layoutUtilityPageEntry.getLayoutUtilityPageEntryId());
            } else if (!GetterUtil.getBoolean((Object)utilityPage.getMarkedAsDefault()) && layoutUtilityPageEntry.isDefaultLayoutUtilityPageEntry()) {
                layoutUtilityPageEntry = this._layoutUtilityPageEntryService.unsetDefaultLayoutUtilityPageEntry(layoutUtilityPageEntry.getLayoutUtilityPageEntryId());
            }
        }
        return (UtilityPage)this._utilityPageDTOConverter.toDTO((Object)this._layoutUtilityPageEntryService.updateLayoutUtilityPageEntry(layoutUtilityPageEntry.getLayoutUtilityPageEntryId(), utilityPage.getName()));
    }

    @Override
    protected void preparePatch(UtilityPage utilityPage, UtilityPage existingUtilityPage) {
        if (utilityPage.getPageSpecifications() != null) {
            existingUtilityPage.setPageSpecifications(() -> ((UtilityPage)utilityPage).getPageSpecifications());
        }
        if (utilityPage.getUtilityPageSettings() != null) {
            existingUtilityPage.setUtilityPageSettings(() -> ((UtilityPage)utilityPage).getUtilityPageSettings());
        }
    }

    private UtilityPage _addLayoutUtilityPageEntry(long groupId, UtilityPage utilityPage) throws Exception {
        ServiceContext serviceContext = this._getServiceContext(groupId, utilityPage);
        return (UtilityPage)this._utilityPageDTOConverter.toDTO((Object)this._layoutUtilityPageEntryService.addLayoutUtilityPageEntry(utilityPage.getExternalReferenceCode(), groupId, this._getLayoutPlid(groupId, utilityPage, serviceContext), 0L, utilityPage.getMarkedAsDefault().booleanValue(), utilityPage.getName(), this._getType(utilityPage.getType()), 0L, serviceContext));
    }

    private long _getLayoutPlid(long groupId, UtilityPage utilityPage, ServiceContext serviceContext) throws Exception {
        Map<Locale, String> nameMap = Collections.singletonMap(this._portal.getSiteDefaultLocale(groupId), utilityPage.getName());
        Map titleMap = Collections.emptyMap();
        Map descriptionMap = Collections.emptyMap();
        UtilityPageSettings utilityPageSettings = utilityPage.getUtilityPageSettings();
        if (utilityPageSettings != null && utilityPageSettings.getSeoSettings() != null) {
            UtilityPageSEOSettings utilityPageSEOSettings = utilityPageSettings.getSeoSettings();
            titleMap = LocalizedMapUtil.getLocalizedMap((Map)utilityPageSEOSettings.getHtmlTitle_i18n());
            descriptionMap = LocalizedMapUtil.getLocalizedMap((Map)utilityPageSEOSettings.getDescription_i18n());
        }
        serviceContext.setAttribute("layout.instanceable.allowed", (Serializable)Boolean.TRUE);
        Layout layout = LayoutUtil.addContentLayout(groupId, utilityPage.getPageSpecifications(), false, nameMap, titleMap, descriptionMap, "utility", true, true, 2, serviceContext);
        if (layout == null) {
            return 0L;
        }
        return layout.getPlid();
    }

    private ServiceContext _getServiceContext(long groupId, UtilityPage utilityPage) {
        ServiceContext serviceContext = ServiceContextUtil.createServiceContext(groupId, this.contextHttpServletRequest, this.contextUser.getUserId());
        serviceContext.setCreateDate(utilityPage.getDateCreated());
        serviceContext.setModifiedDate(utilityPage.getDateModified());
        serviceContext.setUuid(utilityPage.getUuid());
        return serviceContext;
    }

    private String _getType(UtilityPage.Type type) {
        if (_externalToInternalValuesMap.containsKey(type)) {
            return _externalToInternalValuesMap.get(type);
        }
        throw new UnsupportedOperationException();
    }
}

