/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.resource.v1_0;

import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.service.AssetTagService;
import com.liferay.headless.admin.site.dto.v1_0.ContentPageSpecification;
import com.liferay.headless.admin.site.dto.v1_0.ItemExternalReference;
import com.liferay.headless.admin.site.dto.v1_0.MasterPage;
import com.liferay.headless.admin.site.dto.v1_0.PageSpecification;
import com.liferay.headless.admin.site.dto.v1_0.Scope;
import com.liferay.headless.admin.site.internal.resource.v1_0.BaseMasterPageResourceImpl;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.GroupUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.LayoutUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.ServiceContextUtil;
import com.liferay.headless.admin.site.resource.v1_0.MasterPageResource;
import com.liferay.headless.common.spi.service.context.ServiceContextBuilder;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryService;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.service.GroupService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.io.Serializable;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/master-page.properties"}, scope=ServiceScope.PROTOTYPE, service={MasterPageResource.class})
public class MasterPageResourceImpl
extends BaseMasterPageResourceImpl {
    @Reference
    private AssetTagService _assetTagService;
    @Reference
    private GroupService _groupService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateEntryService _layoutPageTemplateEntryService;
    @Reference(target="(component.name=com.liferay.headless.admin.site.internal.dto.v1_0.converter.MasterPageDTOConverter)")
    private DTOConverter<LayoutPageTemplateEntry, MasterPage> _masterPageDTOConverter;
    @Reference(target="(component.name=com.liferay.headless.admin.site.internal.dto.v1_0.converter.PageSpecificationDTOConverter)")
    private DTOConverter<Layout, PageSpecification> _pageSpecificationDTOConverter;
    @Reference
    private Portal _portal;
    @Reference
    private PortletFileRepository _portletFileRepository;

    @Override
    public void deleteSiteSiteByExternalReferenceCodeMasterPage(String siteExternalReferenceCode, String masterPageExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        this._layoutPageTemplateEntryService.deleteLayoutPageTemplateEntry(masterPageExternalReferenceCode, GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode));
    }

    @Override
    public MasterPage getSiteSiteByExternalReferenceCodeMasterPage(String siteExternalReferenceCode, String masterPageExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryService.getLayoutPageTemplateEntryByExternalReferenceCode(masterPageExternalReferenceCode, GroupUtil.getGroupId(true, this.contextCompany.getCompanyId(), siteExternalReferenceCode));
        if (!Objects.equals(3, layoutPageTemplateEntry.getType())) {
            throw new UnsupportedOperationException();
        }
        return (MasterPage)this._masterPageDTOConverter.toDTO((Object)layoutPageTemplateEntry);
    }

    @Override
    public Page<MasterPage> getSiteSiteByExternalReferenceCodeMasterPagesPage(String siteExternalReferenceCode, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        long groupId = GroupUtil.getGroupId(true, this.contextCompany.getCompanyId(), siteExternalReferenceCode);
        if (Validator.isNull((String)search)) {
            return Page.of(this.transform(this._layoutPageTemplateEntryService.getLayoutPageTemplateEntries(groupId, 3, pagination.getStartPosition(), pagination.getEndPosition(), null), layoutPageTemplateEntry -> (MasterPage)this._masterPageDTOConverter.toDTO(layoutPageTemplateEntry)), (Pagination)pagination, (long)this._layoutPageTemplateEntryService.getLayoutPageTemplateEntriesCount(groupId, 3));
        }
        return Page.of(this.transform(this._layoutPageTemplateEntryService.getLayoutPageTemplateEntries(groupId, 0L, 0L, search, 3, pagination.getStartPosition(), pagination.getEndPosition(), null), layoutPageTemplateEntry -> (MasterPage)this._masterPageDTOConverter.toDTO(layoutPageTemplateEntry)), (Pagination)pagination, (long)this._layoutPageTemplateEntryService.getLayoutPageTemplateEntriesCount(groupId, 0L, 0L, search, 3));
    }

    @Override
    public MasterPage postSiteSiteByExternalReferenceCodeMasterPage(String siteExternalReferenceCode, MasterPage masterPage) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        return this._addMasterPage(GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode), masterPage);
    }

    @Override
    public ContentPageSpecification postSiteSiteByExternalReferenceCodeMasterPagePageSpecification(String siteExternalReferenceCode, String pageTemplateExternalReferenceCode, ContentPageSpecification contentPageSpecification) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryService.fetchLayoutPageTemplateEntryByExternalReferenceCode(pageTemplateExternalReferenceCode, GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode));
        if (!Objects.equals(3, layoutPageTemplateEntry.getType())) {
            throw new UnsupportedOperationException();
        }
        return (ContentPageSpecification)this._pageSpecificationDTOConverter.toDTO((Object)LayoutUtil.addDraftToLayout(contentPageSpecification, this._layoutLocalService.getLayout(layoutPageTemplateEntry.getPlid()), ServiceContextUtil.createServiceContext(layoutPageTemplateEntry.getGroupId(), this.contextHttpServletRequest, this.contextUser.getUserId())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MasterPage putSiteSiteByExternalReferenceCodeMasterPage(String siteExternalReferenceCode, String masterPageExternalReferenceCode, MasterPage masterPage) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        long groupId = GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode);
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryService.fetchLayoutPageTemplateEntryByExternalReferenceCode(masterPageExternalReferenceCode, groupId);
        if (layoutPageTemplateEntry == null) {
            return this._addMasterPage(groupId, masterPage);
        }
        long previewFileEntryId = this._getPreviewFileEntryId(groupId, masterPage);
        if (previewFileEntryId != layoutPageTemplateEntry.getPreviewFileEntryId()) {
            layoutPageTemplateEntry = this._layoutPageTemplateEntryService.updateLayoutPageTemplateEntry(layoutPageTemplateEntry.getLayoutPageTemplateEntryId(), previewFileEntryId);
        }
        Layout layout = this._layoutLocalService.getLayout(layoutPageTemplateEntry.getPlid());
        layout = LayoutUtil.updateContentLayout(layout, layout.getNameMap(), layout.getTitleMap(), layout.getDescriptionMap(), masterPage.getPageSpecifications(), this._getServiceContext(groupId, masterPage));
        if (!layoutPageTemplateEntry.isApproved() && layout.isPublished()) {
            layoutPageTemplateEntry = this._layoutPageTemplateEntryService.updateStatus(layoutPageTemplateEntry.getLayoutPageTemplateEntryId(), 0);
        }
        if (Validator.isNotNull((Object)masterPage.getMarkedAsDefault()) && !Objects.equals(GetterUtil.getBoolean((Object)masterPage.getMarkedAsDefault()), layoutPageTemplateEntry.isDefaultTemplate())) {
            layoutPageTemplateEntry = this._layoutPageTemplateEntryService.updateLayoutPageTemplateEntry(layoutPageTemplateEntry.getLayoutPageTemplateEntryId(), GetterUtil.getBoolean((Object)masterPage.getMarkedAsDefault()));
        }
        ServiceContext serviceContext = this._getServiceContext(groupId, masterPage);
        serviceContext.setAssetTagNames(this._getAssetTagNames(groupId, masterPage.getKeywordItemExternalReferences()));
        ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
        try {
            MasterPage masterPage2 = (MasterPage)this._masterPageDTOConverter.toDTO((Object)this._layoutPageTemplateEntryService.updateLayoutPageTemplateEntry(layoutPageTemplateEntry.getLayoutPageTemplateEntryId(), masterPage.getName()));
            return masterPage2;
        }
        finally {
            ServiceContextThreadLocal.popServiceContext();
        }
    }

    @Override
    protected void preparePatch(MasterPage masterPage, MasterPage existingMasterPage) {
        if (masterPage.getKeywordItemExternalReferences() != null) {
            existingMasterPage.setKeywordItemExternalReferences(() -> ((MasterPage)masterPage).getKeywordItemExternalReferences());
        }
        if (masterPage.getPageSpecifications() != null) {
            existingMasterPage.setPageSpecifications(() -> ((MasterPage)masterPage).getPageSpecifications());
        }
        if (masterPage.getThumbnail() != null) {
            existingMasterPage.setThumbnail(() -> ((MasterPage)masterPage).getThumbnail());
        }
    }

    private MasterPage _addMasterPage(long groupId, MasterPage masterPage) throws Exception {
        boolean defaultTemplate = false;
        if (GetterUtil.getBoolean((Object)masterPage.getMarkedAsDefault())) {
            defaultTemplate = true;
        }
        int status = 2;
        if (this._isPublishedLayout(masterPage.getPageSpecifications())) {
            status = 0;
        }
        ServiceContext serviceContext = this._getServiceContext(groupId, masterPage);
        if (ArrayUtil.isNotEmpty((Object[])masterPage.getKeywordItemExternalReferences())) {
            serviceContext.setAssetTagNames(this._getAssetTagNames(groupId, masterPage.getKeywordItemExternalReferences()));
        }
        return (MasterPage)this._masterPageDTOConverter.toDTO((Object)this._layoutPageTemplateEntryService.addLayoutPageTemplateEntry(masterPage.getExternalReferenceCode(), groupId, 0L, masterPage.getKey(), 0L, 0L, masterPage.getName(), 3, this._getPreviewFileEntryId(groupId, masterPage), defaultTemplate, 0L, this._getLayoutPlid(groupId, masterPage, serviceContext), 0L, status, serviceContext));
    }

    private String[] _getAssetTagNames(long groupId, ItemExternalReference[] itemExternalReferences) throws Exception {
        if (ArrayUtil.isEmpty((Object[])itemExternalReferences)) {
            return new String[0];
        }
        Group group = this._groupService.getGroup(groupId);
        return this.transform(itemExternalReferences, itemExternalReference -> {
            AssetTag assetTag;
            long scopeGroupId = groupId;
            Scope scope = itemExternalReference.getScope();
            if (scope != null) {
                scopeGroupId = GroupUtil.getGroupId(true, true, group.getCompanyId(), scope.getExternalReferenceCode());
            }
            if ((assetTag = this._assetTagService.fetchAssetTagByExternalReferenceCode(itemExternalReference.getExternalReferenceCode(), scopeGroupId)) == null) {
                throw new UnsupportedOperationException();
            }
            return assetTag.getName();
        }, String.class);
    }

    private long _getLayoutPlid(long groupId, MasterPage masterPage, ServiceContext serviceContext) throws Exception {
        Map<Locale, String> nameMap = Collections.singletonMap(this._portal.getSiteDefaultLocale(groupId), masterPage.getName());
        serviceContext.setAttribute("layout.instanceable.allowed", (Serializable)Boolean.TRUE);
        serviceContext.setAttribute("layout.page.template.entry.type", (Serializable)Integer.valueOf(3));
        Layout layout = LayoutUtil.addContentLayout(groupId, masterPage.getPageSpecifications(), true, nameMap, nameMap, nameMap, "content", true, true, 0, serviceContext);
        if (layout == null) {
            return 0L;
        }
        return layout.getPlid();
    }

    private long _getPreviewFileEntryId(long groupId, MasterPage masterPage) throws Exception {
        ItemExternalReference itemExternalReference = masterPage.getThumbnail();
        if (itemExternalReference == null || Validator.isNull((String)itemExternalReference.getExternalReferenceCode())) {
            return 0L;
        }
        FileEntry fileEntry = this._portletFileRepository.getPortletFileEntryByExternalReferenceCode(itemExternalReference.getExternalReferenceCode(), groupId);
        return fileEntry.getFileEntryId();
    }

    private ServiceContext _getServiceContext(long groupId, MasterPage masterPage) {
        ServiceContext serviceContext = ServiceContextBuilder.create((long)groupId, (HttpServletRequest)this.contextHttpServletRequest, null).build();
        serviceContext.setCreateDate(masterPage.getDateCreated());
        serviceContext.setModifiedDate(masterPage.getDateModified());
        serviceContext.setUserId(this.contextUser.getUserId());
        serviceContext.setUuid(masterPage.getUuid());
        return serviceContext;
    }

    private boolean _isPublishedLayout(PageSpecification[] pageSpecifications) {
        if (pageSpecifications == null) {
            return false;
        }
        if (pageSpecifications.length != 2) {
            throw new UnsupportedOperationException();
        }
        ContentPageSpecification publishedContentPageSpecification = (ContentPageSpecification)pageSpecifications[0];
        if (Validator.isNull((String)publishedContentPageSpecification.getDraftContentPageSpecificationExternalReferenceCode())) {
            publishedContentPageSpecification = (ContentPageSpecification)pageSpecifications[1];
        }
        return Objects.equals(publishedContentPageSpecification.getStatus(), PageSpecification.Status.APPROVED);
    }
}

