/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.dto.v1_0.converter;

import com.liferay.headless.admin.site.dto.v1_0.ItemExternalReference;
import com.liferay.headless.admin.site.dto.v1_0.UtilityPage;
import com.liferay.layout.utility.page.model.LayoutUtilityPageEntry;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.layout.utility.page.model.LayoutUtilityPageEntry"}, service={DTOConverter.class})
public class UtilityPageDTOConverter
implements DTOConverter<LayoutUtilityPageEntry, UtilityPage> {
    private static final Map<String, UtilityPage.Type> _internalToExternalValuesMap = HashMapBuilder.put((Object)"COOKIE_POLICY", (Object)UtilityPage.Type.COOKIE_POLICY).put((Object)"CREATE_ACCOUNT", (Object)UtilityPage.Type.CREATE_ACCOUNT).put((Object)"FORGOT_PASSWORD", (Object)UtilityPage.Type.FORGOT_PASSWORD).put((Object)"LOGIN", (Object)UtilityPage.Type.LOGIN).put((Object)"SC_INTERNAL_SERVER_ERROR", (Object)UtilityPage.Type.ERROR_CODE500).put((Object)"SC_NOT_FOUND", (Object)UtilityPage.Type.ERROR_CODE404).put((Object)"STATUS", (Object)UtilityPage.Type.ERROR).put((Object)"TERMS_OF_USE", (Object)UtilityPage.Type.TERMS_OF_USE).build();
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private PortletFileRepository _portletFileRepository;

    public String getContentType() {
        return UtilityPage.class.getSimpleName();
    }

    public UtilityPage toDTO(DTOConverterContext dtoConverterContext, final LayoutUtilityPageEntry layoutUtilityPageEntry) throws Exception {
        final Layout layout = this._layoutLocalService.getLayout(layoutUtilityPageEntry.getPlid());
        return new UtilityPage(){
            {
                this.setDateCreated(() -> ((LayoutUtilityPageEntry)layoutUtilityPageEntry).getCreateDate());
                this.setDateModified(() -> ((LayoutUtilityPageEntry)layoutUtilityPageEntry).getModifiedDate());
                this.setDatePublished(() -> ((Layout)layout).getPublishDate());
                this.setExternalReferenceCode(() -> ((LayoutUtilityPageEntry)layoutUtilityPageEntry).getExternalReferenceCode());
                this.setFriendlyUrlPath_i18n(() -> LocalizedMapUtil.getI18nMap((boolean)true, (Map)layout.getFriendlyURLMap()));
                this.setMarkedAsDefault(() -> ((LayoutUtilityPageEntry)layoutUtilityPageEntry).isDefaultLayoutUtilityPageEntry());
                this.setName(() -> ((LayoutUtilityPageEntry)layoutUtilityPageEntry).getName());
                this.setThumbnail(() -> {
                    if (layoutUtilityPageEntry.getPreviewFileEntryId() <= 0L) {
                        return null;
                    }
                    final FileEntry fileEntry = UtilityPageDTOConverter.this._portletFileRepository.getPortletFileEntry(layoutUtilityPageEntry.getPreviewFileEntryId());
                    if (fileEntry == null) {
                        return null;
                    }
                    return new ItemExternalReference(){
                        {
                            this.setClassName(() -> FileEntry.class.getName());
                            this.setExternalReferenceCode(() -> ((FileEntry)fileEntry).getExternalReferenceCode());
                        }
                    };
                });
                this.setType(() -> UtilityPageDTOConverter.this._getType(layoutUtilityPageEntry.getType()));
                this.setUuid(() -> ((LayoutUtilityPageEntry)layoutUtilityPageEntry).getUuid());
            }
        };
    }

    private UtilityPage.Type _getType(String type) {
        if (_internalToExternalValuesMap.containsKey(type)) {
            return _internalToExternalValuesMap.get(type);
        }
        throw new UnsupportedOperationException();
    }
}

