/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.resource.v1_0;

import com.liferay.headless.admin.site.dto.v1_0.ContentPageSpecification;
import com.liferay.headless.admin.site.dto.v1_0.MasterPage;
import com.liferay.headless.admin.site.dto.v1_0.PageSpecification;
import com.liferay.headless.admin.site.internal.resource.v1_0.BaseMasterPageResourceImpl;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.GroupUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.LayoutUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.ServiceContextUtil;
import com.liferay.headless.admin.site.resource.v1_0.MasterPageResource;
import com.liferay.headless.common.spi.service.context.ServiceContextBuilder;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryService;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/master-page.properties"}, scope=ServiceScope.PROTOTYPE, service={MasterPageResource.class})
public class MasterPageResourceImpl
extends BaseMasterPageResourceImpl {
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateEntryService _layoutPageTemplateEntryService;
    @Reference(target="(component.name=com.liferay.headless.admin.site.internal.dto.v1_0.converter.MasterPageDTOConverter)")
    private DTOConverter<LayoutPageTemplateEntry, MasterPage> _masterPageDTOConverter;
    @Reference(target="(component.name=com.liferay.headless.admin.site.internal.dto.v1_0.converter.PageSpecificationDTOConverter)")
    private DTOConverter<Layout, PageSpecification> _pageSpecificationDTOConverter;

    @Override
    public void deleteSiteSiteByExternalReferenceCodeMasterPage(String siteExternalReferenceCode, String masterPageExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        this._layoutPageTemplateEntryService.deleteLayoutPageTemplateEntry(masterPageExternalReferenceCode, GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode));
    }

    @Override
    public MasterPage getSiteSiteByExternalReferenceCodeMasterPage(String siteExternalReferenceCode, String masterPageExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryService.getLayoutPageTemplateEntryByExternalReferenceCode(masterPageExternalReferenceCode, GroupUtil.getGroupId(true, this.contextCompany.getCompanyId(), siteExternalReferenceCode));
        if (!Objects.equals(3, layoutPageTemplateEntry.getType())) {
            throw new UnsupportedOperationException();
        }
        return (MasterPage)this._masterPageDTOConverter.toDTO((Object)layoutPageTemplateEntry);
    }

    @Override
    public Page<MasterPage> getSiteSiteByExternalReferenceCodeMasterPagesPage(String siteExternalReferenceCode, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        long groupId = GroupUtil.getGroupId(true, this.contextCompany.getCompanyId(), siteExternalReferenceCode);
        if (Validator.isNull((String)search)) {
            return Page.of(this.transform(this._layoutPageTemplateEntryService.getLayoutPageTemplateEntries(groupId, 3, pagination.getStartPosition(), pagination.getEndPosition(), null), layoutPageTemplateEntry -> (MasterPage)this._masterPageDTOConverter.toDTO(layoutPageTemplateEntry)), (Pagination)pagination, (long)this._layoutPageTemplateEntryService.getLayoutPageTemplateEntriesCount(groupId, 3));
        }
        return Page.of(this.transform(this._layoutPageTemplateEntryService.getLayoutPageTemplateEntries(groupId, 0L, 0L, search, 3, pagination.getStartPosition(), pagination.getEndPosition(), null), layoutPageTemplateEntry -> (MasterPage)this._masterPageDTOConverter.toDTO(layoutPageTemplateEntry)), (Pagination)pagination, (long)this._layoutPageTemplateEntryService.getLayoutPageTemplateEntriesCount(groupId, 0L, 0L, search, 3));
    }

    @Override
    public MasterPage postSiteSiteByExternalReferenceCodeMasterPage(String siteExternalReferenceCode, MasterPage masterPage) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        return this._addMasterPage(GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode), masterPage);
    }

    @Override
    public ContentPageSpecification postSiteSiteByExternalReferenceCodeMasterPagePageSpecification(String siteExternalReferenceCode, String pageTemplateExternalReferenceCode, ContentPageSpecification contentPageSpecification) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryService.fetchLayoutPageTemplateEntryByExternalReferenceCode(pageTemplateExternalReferenceCode, GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode));
        if (!Objects.equals(3, layoutPageTemplateEntry.getType())) {
            throw new UnsupportedOperationException();
        }
        return (ContentPageSpecification)this._pageSpecificationDTOConverter.toDTO((Object)LayoutUtil.addDraftToLayout(contentPageSpecification, this._layoutLocalService.getLayout(layoutPageTemplateEntry.getPlid()), ServiceContextUtil.createServiceContext(layoutPageTemplateEntry.getGroupId(), this.contextHttpServletRequest, this.contextUser.getUserId())));
    }

    @Override
    public MasterPage putSiteSiteByExternalReferenceCodeMasterPage(String siteExternalReferenceCode, String masterPageExternalReferenceCode, MasterPage masterPage) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        long groupId = GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode);
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryService.fetchLayoutPageTemplateEntryByExternalReferenceCode(masterPageExternalReferenceCode, groupId);
        if (layoutPageTemplateEntry == null) {
            return this._addMasterPage(groupId, masterPage);
        }
        if (Validator.isNotNull((Object)masterPage.getMarkedAsDefault()) && !Objects.equals(GetterUtil.getBoolean((Object)masterPage.getMarkedAsDefault()), layoutPageTemplateEntry.isDefaultTemplate())) {
            layoutPageTemplateEntry = this._layoutPageTemplateEntryService.updateLayoutPageTemplateEntry(layoutPageTemplateEntry.getLayoutPageTemplateEntryId(), GetterUtil.getBoolean((Object)masterPage.getMarkedAsDefault()));
        }
        return (MasterPage)this._masterPageDTOConverter.toDTO((Object)this._layoutPageTemplateEntryService.updateLayoutPageTemplateEntry(layoutPageTemplateEntry.getLayoutPageTemplateEntryId(), masterPage.getName()));
    }

    private MasterPage _addMasterPage(long groupId, MasterPage masterPage) throws Exception {
        return (MasterPage)this._masterPageDTOConverter.toDTO((Object)this._layoutPageTemplateEntryService.addLayoutPageTemplateEntry(masterPage.getExternalReferenceCode(), groupId, 0L, masterPage.getKey(), masterPage.getName(), 3, 0L, 2, this._getServiceContext(groupId, masterPage)));
    }

    private ServiceContext _getServiceContext(long groupId, MasterPage masterPage) {
        ServiceContext serviceContext = ServiceContextBuilder.create((long)groupId, (HttpServletRequest)this.contextHttpServletRequest, null).build();
        serviceContext.setCreateDate(masterPage.getDateCreated());
        serviceContext.setModifiedDate(masterPage.getDateModified());
        serviceContext.setUuid(masterPage.getUuid());
        return serviceContext;
    }
}

