/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.resource.v1_0;

import com.liferay.headless.admin.site.dto.v1_0.ContentPageSpecification;
import com.liferay.headless.admin.site.dto.v1_0.DisplayPageTemplate;
import com.liferay.headless.admin.site.resource.v1_0.DisplayPageTemplateResource;
import com.liferay.petra.function.UnsafeBiConsumer;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.Filter;
import com.liferay.portal.odata.filter.FilterParser;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.odata.sort.SortField;
import com.liferay.portal.odata.sort.SortParser;
import com.liferay.portal.odata.sort.SortParserProvider;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.batch.engine.VulcanBatchEngineTaskItemDelegate;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineExportTaskResource;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineImportTaskResource;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.permission.Permission;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.ActionUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1.0")
public abstract class BaseDisplayPageTemplateResourceImpl
implements DisplayPageTemplateResource,
EntityModelResource,
VulcanBatchEngineTaskItemDelegate<DisplayPageTemplate> {
    protected AcceptLanguage contextAcceptLanguage;
    protected UnsafeBiConsumer<Collection<DisplayPageTemplate>, UnsafeFunction<DisplayPageTemplate, DisplayPageTemplate, Exception>, Exception> contextBatchUnsafeBiConsumer;
    protected UnsafeBiConsumer<Collection<DisplayPageTemplate>, UnsafeConsumer<DisplayPageTemplate, Exception>, Exception> contextBatchUnsafeConsumer;
    protected Company contextCompany;
    protected HttpServletRequest contextHttpServletRequest;
    protected HttpServletResponse contextHttpServletResponse;
    protected Object contextScopeChecker;
    protected UriInfo contextUriInfo;
    protected User contextUser;
    protected ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert;
    protected FilterParserProvider filterParserProvider;
    protected GroupLocalService groupLocalService;
    protected ResourceActionLocalService resourceActionLocalService;
    protected ResourcePermissionLocalService resourcePermissionLocalService;
    protected RoleLocalService roleLocalService;
    protected SortParserProvider sortParserProvider;
    protected VulcanBatchEngineExportTaskResource vulcanBatchEngineExportTaskResource;
    protected VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource;
    private static final Log _log = LogFactoryUtil.getLog(BaseDisplayPageTemplateResourceImpl.class);

    @Operation(description="Retrieves all the display page templates within a display page template folder of a site page.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteExternalReferenceCode"), @Parameter(in=ParameterIn.PATH, name="displayPageTemplateFolderExternalReferenceCode"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="flatten"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields")})
    @Tags(value={@Tag(name="DisplayPageTemplate")})
    @GET
    @Path(value="/sites/{siteExternalReferenceCode}/display-page-template-folders/{displayPageTemplateFolderExternalReferenceCode}/display-page-templates")
    @Produces(value={"application/json", "application/xml"})
    public Page<DisplayPageTemplate> getSiteSiteByExternalReferenceCodeDisplayPageTemplateFolderDisplayPageTemplatesPage(@Parameter(hidden=true) @NotNull @PathParam(value="siteExternalReferenceCode") String siteExternalReferenceCode, @Parameter(hidden=true) @NotNull @PathParam(value="displayPageTemplateFolderExternalReferenceCode") String displayPageTemplateFolderExternalReferenceCode, @Parameter(hidden=true) @QueryParam(value="flatten") Boolean flatten) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Operation(description="Adds a new display page template in draft status to a display page template folder.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteExternalReferenceCode"), @Parameter(in=ParameterIn.PATH, name="displayPageTemplateFolderExternalReferenceCode"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields")})
    @Tags(value={@Tag(name="DisplayPageTemplate")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/sites/{siteExternalReferenceCode}/display-page-template-folders/{displayPageTemplateFolderExternalReferenceCode}/display-page-templates")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public DisplayPageTemplate postSiteSiteByExternalReferenceCodeDisplayPageTemplateFolderDisplayPageTemplate(@Parameter(hidden=true) @NotNull @PathParam(value="siteExternalReferenceCode") String siteExternalReferenceCode, @Parameter(hidden=true) @NotNull @PathParam(value="displayPageTemplateFolderExternalReferenceCode") String displayPageTemplateFolderExternalReferenceCode, DisplayPageTemplate displayPageTemplate) throws Exception {
        return new DisplayPageTemplate();
    }

    @Operation(description="Retrieves the display page templates of the site")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteExternalReferenceCode"), @Parameter(in=ParameterIn.QUERY, name="aggregationTerms"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="restrictFields"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="DisplayPageTemplate")})
    @GET
    @Path(value="/sites/{siteExternalReferenceCode}/display-page-templates")
    @Produces(value={"application/json", "application/xml"})
    public Page<DisplayPageTemplate> getSiteSiteByExternalReferenceCodeDisplayPageTemplatesPage(@Parameter(hidden=true) @NotNull @PathParam(value="siteExternalReferenceCode") String siteExternalReferenceCode, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Aggregation aggregation, @Context com.liferay.portal.kernel.search.filter.Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Operation(description="Adds a new display page template")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteExternalReferenceCode")})
    @Tags(value={@Tag(name="DisplayPageTemplate")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/sites/{siteExternalReferenceCode}/display-page-templates")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public DisplayPageTemplate postSiteSiteByExternalReferenceCodeDisplayPageTemplate(@Parameter(hidden=true) @NotNull @PathParam(value="siteExternalReferenceCode") String siteExternalReferenceCode, DisplayPageTemplate displayPageTemplate) throws Exception {
        return new DisplayPageTemplate();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteExternalReferenceCode"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields"), @Parameter(in=ParameterIn.QUERY, name="roleNames")})
    @Tags(value={@Tag(name="DisplayPageTemplate")})
    @GET
    @Path(value="/sites/{siteExternalReferenceCode}/display-page-templates/permissions")
    @Produces(value={"application/json", "application/xml"})
    public Page<Permission> getSiteSiteByExternalReferenceCodeDisplayPageTemplatePermissionsPage(@Parameter(hidden=true) @NotNull @PathParam(value="siteExternalReferenceCode") String siteExternalReferenceCode, @Parameter(hidden=true) @QueryParam(value="roleNames") String roleNames) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteExternalReferenceCode")})
    @Tags(value={@Tag(name="DisplayPageTemplate")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/sites/{siteExternalReferenceCode}/display-page-templates/permissions")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public Page<Permission> putSiteSiteByExternalReferenceCodeDisplayPageTemplatePermissionsPage(@Parameter(hidden=true) @NotNull @PathParam(value="siteExternalReferenceCode") String siteExternalReferenceCode, Permission[] permissions) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Operation(description="Deletes a specific display page template of a site.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteExternalReferenceCode"), @Parameter(in=ParameterIn.PATH, name="displayPageTemplateExternalReferenceCode")})
    @Tags(value={@Tag(name="DisplayPageTemplate")})
    @DELETE
    @Path(value="/sites/{siteExternalReferenceCode}/display-page-templates/{displayPageTemplateExternalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteSiteSiteByExternalReferenceCodeDisplayPageTemplate(@Parameter(hidden=true) @NotNull @PathParam(value="siteExternalReferenceCode") String siteExternalReferenceCode, @Parameter(hidden=true) @NotNull @PathParam(value="displayPageTemplateExternalReferenceCode") String displayPageTemplateExternalReferenceCode) throws Exception {
    }

    @Operation(description="Retrieves a specific display page template of a site.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteExternalReferenceCode"), @Parameter(in=ParameterIn.PATH, name="displayPageTemplateExternalReferenceCode"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields")})
    @Tags(value={@Tag(name="DisplayPageTemplate")})
    @GET
    @Path(value="/sites/{siteExternalReferenceCode}/display-page-templates/{displayPageTemplateExternalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public DisplayPageTemplate getSiteSiteByExternalReferenceCodeDisplayPageTemplate(@Parameter(hidden=true) @NotNull @PathParam(value="siteExternalReferenceCode") String siteExternalReferenceCode, @Parameter(hidden=true) @NotNull @PathParam(value="displayPageTemplateExternalReferenceCode") String displayPageTemplateExternalReferenceCode) throws Exception {
        return new DisplayPageTemplate();
    }

    @Operation(description="Updates only the fields received in the request body, leaving any other fields untouched.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteExternalReferenceCode"), @Parameter(in=ParameterIn.PATH, name="displayPageTemplateExternalReferenceCode"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields")})
    @Tags(value={@Tag(name="DisplayPageTemplate")})
    @Consumes(value={"application/json", "application/xml"})
    @PATCH
    @Path(value="/sites/{siteExternalReferenceCode}/display-page-templates/{displayPageTemplateExternalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public DisplayPageTemplate patchSiteSiteByExternalReferenceCodeDisplayPageTemplate(@Parameter(hidden=true) @NotNull @PathParam(value="siteExternalReferenceCode") String siteExternalReferenceCode, @Parameter(hidden=true) @NotNull @PathParam(value="displayPageTemplateExternalReferenceCode") String displayPageTemplateExternalReferenceCode, DisplayPageTemplate displayPageTemplate) throws Exception {
        DisplayPageTemplate existingDisplayPageTemplate = this.getSiteSiteByExternalReferenceCodeDisplayPageTemplate(siteExternalReferenceCode, displayPageTemplateExternalReferenceCode);
        if (displayPageTemplate.getCreatorExternalReferenceCode() != null) {
            existingDisplayPageTemplate.setCreatorExternalReferenceCode(displayPageTemplate.getCreatorExternalReferenceCode());
        }
        if (displayPageTemplate.getDateCreated() != null) {
            existingDisplayPageTemplate.setDateCreated(displayPageTemplate.getDateCreated());
        }
        if (displayPageTemplate.getDateModified() != null) {
            existingDisplayPageTemplate.setDateModified(displayPageTemplate.getDateModified());
        }
        if (displayPageTemplate.getDatePublished() != null) {
            existingDisplayPageTemplate.setDatePublished(displayPageTemplate.getDatePublished());
        }
        if (displayPageTemplate.getExternalReferenceCode() != null) {
            existingDisplayPageTemplate.setExternalReferenceCode(displayPageTemplate.getExternalReferenceCode());
        }
        if (displayPageTemplate.getFriendlyUrlPath_i18n() != null) {
            existingDisplayPageTemplate.setFriendlyUrlPath_i18n(displayPageTemplate.getFriendlyUrlPath_i18n());
        }
        if (displayPageTemplate.getKey() != null) {
            existingDisplayPageTemplate.setKey(displayPageTemplate.getKey());
        }
        if (displayPageTemplate.getMarkedAsDefault() != null) {
            existingDisplayPageTemplate.setMarkedAsDefault(displayPageTemplate.getMarkedAsDefault());
        }
        if (displayPageTemplate.getName() != null) {
            existingDisplayPageTemplate.setName(displayPageTemplate.getName());
        }
        if (displayPageTemplate.getUuid() != null) {
            existingDisplayPageTemplate.setUuid(displayPageTemplate.getUuid());
        }
        this.preparePatch(displayPageTemplate, existingDisplayPageTemplate);
        return this.putSiteSiteByExternalReferenceCodeDisplayPageTemplate(siteExternalReferenceCode, displayPageTemplateExternalReferenceCode, existingDisplayPageTemplate);
    }

    @Operation(description="Updates the display page template with the given external reference code, or creates it if it does not exist.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteExternalReferenceCode"), @Parameter(in=ParameterIn.PATH, name="displayPageTemplateExternalReferenceCode"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields")})
    @Tags(value={@Tag(name="DisplayPageTemplate")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/sites/{siteExternalReferenceCode}/display-page-templates/{displayPageTemplateExternalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public DisplayPageTemplate putSiteSiteByExternalReferenceCodeDisplayPageTemplate(@Parameter(hidden=true) @NotNull @PathParam(value="siteExternalReferenceCode") String siteExternalReferenceCode, @Parameter(hidden=true) @NotNull @PathParam(value="displayPageTemplateExternalReferenceCode") String displayPageTemplateExternalReferenceCode, DisplayPageTemplate displayPageTemplate) throws Exception {
        return new DisplayPageTemplate();
    }

    @Operation(description="Adds a new page specification in draft status to a display page template.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteExternalReferenceCode"), @Parameter(in=ParameterIn.PATH, name="displayPageTemplateExternalReferenceCode"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields")})
    @Tags(value={@Tag(name="DisplayPageTemplate")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/sites/{siteExternalReferenceCode}/display-page-templates/{displayPageTemplateExternalReferenceCode}/page-specifications")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public ContentPageSpecification postSiteSiteByExternalReferenceCodeDisplayPageTemplatePageSpecification(@Parameter(hidden=true) @NotNull @PathParam(value="siteExternalReferenceCode") String siteExternalReferenceCode, @Parameter(hidden=true) @NotNull @PathParam(value="displayPageTemplateExternalReferenceCode") String displayPageTemplateExternalReferenceCode, ContentPageSpecification contentPageSpecification) throws Exception {
        return new ContentPageSpecification();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteExternalReferenceCode"), @Parameter(in=ParameterIn.PATH, name="displayPageTemplateExternalReferenceCode"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields"), @Parameter(in=ParameterIn.QUERY, name="roleNames")})
    @Tags(value={@Tag(name="DisplayPageTemplate")})
    @GET
    @Path(value="/sites/{siteExternalReferenceCode}/display-page-templates/{displayPageTemplateExternalReferenceCode}/permissions")
    @Produces(value={"application/json", "application/xml"})
    public Page<Permission> getSiteSiteExternalReferenceCodeDisplayPageTemplatePermissionsPage(@Parameter(hidden=true) @NotNull @PathParam(value="siteExternalReferenceCode") String siteExternalReferenceCode, @Parameter(hidden=true) @NotNull @PathParam(value="displayPageTemplateExternalReferenceCode") String displayPageTemplateExternalReferenceCode, @Parameter(hidden=true) @QueryParam(value="roleNames") String roleNames) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteExternalReferenceCode"), @Parameter(in=ParameterIn.PATH, name="displayPageTemplateExternalReferenceCode")})
    @Tags(value={@Tag(name="DisplayPageTemplate")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/sites/{siteExternalReferenceCode}/display-page-templates/{displayPageTemplateExternalReferenceCode}/permissions")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public Page<Permission> putSiteSiteExternalReferenceCodeDisplayPageTemplatePermissionsPage(@Parameter(hidden=true) @NotNull @PathParam(value="siteExternalReferenceCode") String siteExternalReferenceCode, @Parameter(hidden=true) @NotNull @PathParam(value="displayPageTemplateExternalReferenceCode") String displayPageTemplateExternalReferenceCode) throws Exception {
        return Page.of(Collections.emptyList());
    }

    public void create(Collection<DisplayPageTemplate> displayPageTemplates, Map<String, Serializable> parameters) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    public void delete(Collection<DisplayPageTemplate> displayPageTemplates, Map<String, Serializable> parameters) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    public Set<String> getAvailableCreateStrategies() {
        return SetUtil.fromArray((Object[])new String[0]);
    }

    public Set<String> getAvailableUpdateStrategies() {
        return SetUtil.fromArray((Object[])new String[0]);
    }

    public EntityModel getEntityModel(Map<String, List<String>> multivaluedMap) throws Exception {
        return this.getEntityModel((MultivaluedMap)new MultivaluedHashMap(multivaluedMap));
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return null;
    }

    public String getResourceName() {
        return "DisplayPageTemplate";
    }

    public String getVersion() {
        return "v1.0";
    }

    public Page<DisplayPageTemplate> read(com.liferay.portal.kernel.search.filter.Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    public void setLanguageId(final String languageId) {
        this.contextAcceptLanguage = new AcceptLanguage(){

            public List<Locale> getLocales() {
                return null;
            }

            public String getPreferredLanguageId() {
                return languageId;
            }

            public Locale getPreferredLocale() {
                return LocaleUtil.fromLanguageId((String)languageId);
            }
        };
    }

    public void update(Collection<DisplayPageTemplate> displayPageTemplates, Map<String, Serializable> parameters) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    public void setContextAcceptLanguage(AcceptLanguage contextAcceptLanguage) {
        this.contextAcceptLanguage = contextAcceptLanguage;
    }

    public void setContextBatchUnsafeBiConsumer(UnsafeBiConsumer<Collection<DisplayPageTemplate>, UnsafeFunction<DisplayPageTemplate, DisplayPageTemplate, Exception>, Exception> contextBatchUnsafeBiConsumer) {
        this.contextBatchUnsafeBiConsumer = contextBatchUnsafeBiConsumer;
    }

    public void setContextBatchUnsafeConsumer(UnsafeBiConsumer<Collection<DisplayPageTemplate>, UnsafeConsumer<DisplayPageTemplate, Exception>, Exception> contextBatchUnsafeConsumer) {
        this.contextBatchUnsafeConsumer = contextBatchUnsafeConsumer;
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    public void setContextHttpServletRequest(HttpServletRequest contextHttpServletRequest) {
        this.contextHttpServletRequest = contextHttpServletRequest;
    }

    public void setContextHttpServletResponse(HttpServletResponse contextHttpServletResponse) {
        this.contextHttpServletResponse = contextHttpServletResponse;
    }

    public void setContextUriInfo(UriInfo contextUriInfo) {
        this.contextUriInfo = contextUriInfo;
    }

    public void setContextUser(User contextUser) {
        this.contextUser = contextUser;
    }

    public void setExpressionConvert(ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert) {
        this.expressionConvert = expressionConvert;
    }

    public void setFilterParserProvider(FilterParserProvider filterParserProvider) {
        this.filterParserProvider = filterParserProvider;
    }

    public void setGroupLocalService(GroupLocalService groupLocalService) {
        this.groupLocalService = groupLocalService;
    }

    public void setResourceActionLocalService(ResourceActionLocalService resourceActionLocalService) {
        this.resourceActionLocalService = resourceActionLocalService;
    }

    public void setResourcePermissionLocalService(ResourcePermissionLocalService resourcePermissionLocalService) {
        this.resourcePermissionLocalService = resourcePermissionLocalService;
    }

    public void setRoleLocalService(RoleLocalService roleLocalService) {
        this.roleLocalService = roleLocalService;
    }

    public void setSortParserProvider(SortParserProvider sortParserProvider) {
        this.sortParserProvider = sortParserProvider;
    }

    public void setVulcanBatchEngineExportTaskResource(VulcanBatchEngineExportTaskResource vulcanBatchEngineExportTaskResource) {
        this.vulcanBatchEngineExportTaskResource = vulcanBatchEngineExportTaskResource;
    }

    public void setVulcanBatchEngineImportTaskResource(VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource) {
        this.vulcanBatchEngineImportTaskResource = vulcanBatchEngineImportTaskResource;
    }

    public com.liferay.portal.kernel.search.filter.Filter toFilter(String filterString, Map<String, List<String>> multivaluedMap) {
        try {
            EntityModel entityModel = this.getEntityModel(multivaluedMap);
            FilterParser filterParser = this.filterParserProvider.provide(entityModel);
            Filter oDataFilter = new Filter(filterParser.parse(filterString));
            return (com.liferay.portal.kernel.search.filter.Filter)this.expressionConvert.convert(oDataFilter.getExpression(), this.contextAcceptLanguage.getPreferredLocale(), entityModel);
        }
        catch (Exception exception) {
            _log.error((Object)("Invalid filter " + filterString), (Throwable)exception);
            return null;
        }
    }

    public Sort[] toSorts(String sortString) {
        if (Validator.isNull((String)sortString)) {
            return null;
        }
        try {
            SortParser sortParser = this.sortParserProvider.provide(this.getEntityModel(Collections.emptyMap()));
            if (sortParser == null) {
                return null;
            }
            com.liferay.portal.odata.sort.Sort oDataSort = new com.liferay.portal.odata.sort.Sort(sortParser.parse(sortString));
            List sortFields = oDataSort.getSortFields();
            Sort[] sorts = new Sort[sortFields.size()];
            for (int i = 0; i < sortFields.size(); ++i) {
                SortField sortField = (SortField)sortFields.get(i);
                sorts[i] = new Sort(sortField.getSortableFieldName(this.contextAcceptLanguage.getPreferredLocale()), !sortField.isAscending());
            }
            return sorts;
        }
        catch (Exception exception) {
            _log.error((Object)("Invalid sort " + sortString), (Throwable)exception);
            return new Sort[0];
        }
    }

    protected Map<String, String> addAction(String actionName, GroupedModel groupedModel, String methodName) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (GroupedModel)groupedModel, (String)methodName, (Object)this.contextScopeChecker, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, Long ownerId, String permissionName, Long siteId) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (Long)ownerId, (String)permissionName, (Long)siteId, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, ModelResourcePermission modelResourcePermission) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (ModelResourcePermission)modelResourcePermission, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, String methodName, String permissionName, Long siteId) {
        return this.addAction(actionName, siteId, methodName, null, permissionName, siteId);
    }

    protected void preparePatch(DisplayPageTemplate displayPageTemplate, DisplayPageTemplate existingDisplayPageTemplate) {
    }

    protected <T, R, E extends Throwable> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] transform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<? extends R> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<? extends R> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> transformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }

    protected <T, R, E extends Throwable> long[] transformToLongArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transformToLongArray(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<? extends R> clazz) throws E {
        return TransformUtil.unsafeTransform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<? extends R> clazz) throws E {
        return TransformUtil.unsafeTransformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToList((Object[])array, unsafeFunction);
    }

    protected <T, R, E extends Throwable> long[] unsafeTransformToLongArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToLongArray(collection, unsafeFunction);
    }
}

