/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.resource.v1_0.util;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLFileEntryServiceUtil;
import com.liferay.headless.admin.site.dto.v1_0.ContentPageSpecification;
import com.liferay.headless.admin.site.dto.v1_0.ItemExternalReference;
import com.liferay.headless.admin.site.dto.v1_0.PageElement;
import com.liferay.headless.admin.site.dto.v1_0.PageExperience;
import com.liferay.headless.admin.site.dto.v1_0.PageSpecification;
import com.liferay.headless.admin.site.dto.v1_0.Scope;
import com.liferay.headless.admin.site.dto.v1_0.Settings;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.PageElementTypeUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.GroupUtil;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructure;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalServiceUtil;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryServiceUtil;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureLocalServiceUtil;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.portal.kernel.model.ColorScheme;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ThemeLocalServiceUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ColorSchemeFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.segments.model.SegmentsExperience;
import com.liferay.segments.service.SegmentsExperienceServiceUtil;
import com.liferay.style.book.model.StyleBookEntry;
import com.liferay.style.book.service.StyleBookEntryServiceUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class LayoutUtil {
    public static Layout addDraftToPublishedLayout(ContentPageSpecification contentPageSpecification, Layout layout, ServiceContext serviceContext) throws Exception {
        if (Validator.isNotNull((Object)contentPageSpecification.getStatus()) && !Objects.equals(contentPageSpecification.getStatus(), PageSpecification.Status.DRAFT) || layout.isDraftLayout() || !LayoutUtil.isPublished(layout)) {
            throw new UnsupportedOperationException();
        }
        Layout draftLayout = layout.fetchDraftLayout();
        if (Validator.isNotNull((String)contentPageSpecification.getExternalReferenceCode()) && !Objects.equals(contentPageSpecification.getExternalReferenceCode(), draftLayout.getExternalReferenceCode()) || !Objects.equals(draftLayout.getStatus(), 0)) {
            throw new UnsupportedOperationException();
        }
        return LayoutUtil.updateLayout(contentPageSpecification, draftLayout, serviceContext);
    }

    public static boolean isPublished(Layout layout) {
        if (!layout.isTypeAssetDisplay() && !layout.isTypeContent()) {
            return true;
        }
        if (layout.isDraftLayout()) {
            return GetterUtil.getBoolean((String)layout.getTypeSettingsProperty("published"));
        }
        Layout draftLayout = layout.fetchDraftLayout();
        return GetterUtil.getBoolean((String)draftLayout.getTypeSettingsProperty("published"));
    }

    public static Layout updateLayout(ContentPageSpecification contentPageSpecification, Layout layout, ServiceContext serviceContext) throws Exception {
        LayoutUtil.updateLayout(layout, contentPageSpecification.getSettings(), serviceContext);
        LayoutUtil._updatePageExperiences(layout, contentPageSpecification.getPageExperiences());
        return LayoutLocalServiceUtil.updateStatus((long)serviceContext.getUserId(), (long)layout.getPlid(), (int)2, (ServiceContext)serviceContext);
    }

    public static Layout updateLayout(Layout layout, Settings settings, ServiceContext serviceContext) throws Exception {
        if ((layout = LayoutUtil._updateLookAndFeel(layout, settings)).isTypeAssetDisplay() || layout.isTypeUtility()) {
            serviceContext.setAttribute("layout.instanceable.allowed", (Serializable)Boolean.TRUE);
        }
        return LayoutServiceUtil.updateLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (long)layout.getParentLayoutId(), (Map)layout.getNameMap(), (Map)layout.getTitleMap(), (Map)layout.getDescriptionMap(), (Map)layout.getKeywordsMap(), (Map)layout.getRobotsMap(), (String)layout.getType(), (boolean)layout.isHidden(), (Map)layout.getFriendlyURLMap(), (boolean)layout.getIconImage(), null, (long)LayoutUtil._getStyleBookEntryId(layout, settings), (long)LayoutUtil._getFaviconFileEntryId(layout, settings), (long)LayoutUtil._getMasterLayoutPlid(layout, settings), (ServiceContext)serviceContext);
    }

    private static void _addChildPageElements(LayoutStructure layoutStructure, PageElement pageElement) {
        if (ArrayUtil.isEmpty((Object[])pageElement.getPageElements())) {
            return;
        }
        for (PageElement childPageElement : pageElement.getPageElements()) {
            if (childPageElement.getParentExternalReferenceCode() != null && !Objects.equals(childPageElement.getParentExternalReferenceCode(), pageElement.getExternalReferenceCode())) {
                throw new UnsupportedOperationException();
            }
            layoutStructure.addLayoutStructureItem(childPageElement.getExternalReferenceCode(), PageElementTypeUtil.toInternalType(childPageElement.getType()), pageElement.getExternalReferenceCode(), GetterUtil.getInteger((Object)childPageElement.getPosition(), (int)-1));
            LayoutUtil._addChildPageElements(layoutStructure, childPageElement);
        }
    }

    private static long _getFaviconFileEntryId(Layout layout, Settings settings) throws Exception {
        DLFileEntry dlFileEntry;
        if (settings == null || settings.getFavIcon() == null || !(settings.getFavIcon() instanceof ItemExternalReference)) {
            return 0L;
        }
        ItemExternalReference itemExternalReference = (ItemExternalReference)settings.getFavIcon();
        if (Validator.isNull((String)itemExternalReference.getExternalReferenceCode())) {
            return 0L;
        }
        long groupId = layout.getGroupId();
        Scope scope = itemExternalReference.getScope();
        if (scope != null) {
            groupId = GroupUtil.getGroupId(true, true, layout.getCompanyId(), scope.getExternalReferenceCode());
        }
        if ((dlFileEntry = DLFileEntryServiceUtil.fetchFileEntryByExternalReferenceCode((long)groupId, (String)itemExternalReference.getExternalReferenceCode())) == null) {
            throw new UnsupportedOperationException();
        }
        return dlFileEntry.getFileEntryId();
    }

    private static long _getMasterLayoutPlid(Layout layout, Settings settings) throws Exception {
        if (settings == null) {
            return 0L;
        }
        ItemExternalReference itemExternalReference = settings.getMasterPageItemExternalReference();
        if (itemExternalReference == null || Validator.isNull((String)itemExternalReference.getExternalReferenceCode())) {
            return 0L;
        }
        LayoutPageTemplateEntry layoutPageTemplateEntry = LayoutPageTemplateEntryLocalServiceUtil.fetchLayoutPageTemplateEntryByPlid((long)layout.getPlid());
        if (layoutPageTemplateEntry != null && Objects.equals(3, layoutPageTemplateEntry.getType())) {
            throw new UnsupportedOperationException();
        }
        layoutPageTemplateEntry = LayoutPageTemplateEntryServiceUtil.fetchLayoutPageTemplateEntryByExternalReferenceCode((String)itemExternalReference.getExternalReferenceCode(), (long)layout.getGroupId());
        if (layoutPageTemplateEntry == null || !Objects.equals(3, layoutPageTemplateEntry.getType())) {
            throw new UnsupportedOperationException();
        }
        return layoutPageTemplateEntry.getPlid();
    }

    private static long _getStyleBookEntryId(Layout layout, Settings settings) throws Exception {
        if (settings == null) {
            return 0L;
        }
        ItemExternalReference itemExternalReference = settings.getStyleBookItemExternalReference();
        if (itemExternalReference == null || Validator.isNull((String)itemExternalReference.getExternalReferenceCode())) {
            return 0L;
        }
        StyleBookEntry styleBookEntry = StyleBookEntryServiceUtil.getStyleBookEntryByExternalReferenceCode((String)itemExternalReference.getExternalReferenceCode(), (long)layout.getGroupId());
        return styleBookEntry.getStyleBookEntryId();
    }

    private static void _updateLayoutPageTemplateStructureData(Layout layout, PageExperience pageExperience, SegmentsExperience segmentsExperience) throws Exception {
        if (segmentsExperience == null) {
            throw new UnsupportedOperationException();
        }
        LayoutPageTemplateStructure layoutPageTemplateStructure = LayoutPageTemplateStructureLocalServiceUtil.fetchLayoutPageTemplateStructure((long)layout.getGroupId(), (long)layout.getPlid());
        LayoutStructure layoutStructure = LayoutStructure.of((String)layoutPageTemplateStructure.getData(segmentsExperience.getSegmentsExperienceId()));
        LayoutStructure newLayoutStructure = new LayoutStructure();
        newLayoutStructure.addRootLayoutStructureItem(layoutStructure.getMainItemId());
        for (PageElement pageElement : pageExperience.getPageElements()) {
            newLayoutStructure.addLayoutStructureItem(pageElement.getExternalReferenceCode(), PageElementTypeUtil.toInternalType(pageElement.getType()), layoutStructure.getMainItemId(), GetterUtil.getInteger((Object)pageElement.getPosition(), (int)-1));
            LayoutUtil._addChildPageElements(newLayoutStructure, pageElement);
        }
        LayoutPageTemplateStructureLocalServiceUtil.updateLayoutPageTemplateStructureData((long)layoutPageTemplateStructure.getGroupId(), (long)layoutPageTemplateStructure.getPlid(), (long)segmentsExperience.getSegmentsExperienceId(), (String)newLayoutStructure.toString());
    }

    private static Layout _updateLookAndFeel(Layout layout, Settings settings) throws Exception {
        UnicodeProperties unicodeProperties = layout.getTypeSettingsProperties();
        if (settings != null) {
            unicodeProperties.setProperty("javascript", settings.getJavascript());
        } else {
            unicodeProperties.remove((Object)"javascript");
        }
        for (String key : ListUtil.fromCollection((Collection)unicodeProperties.keySet())) {
            if (!key.startsWith("lfr-theme:")) continue;
            unicodeProperties.remove((Object)key);
        }
        if (settings != null && MapUtil.isNotEmpty((Map)settings.getThemeSettings())) {
            unicodeProperties.putAll(settings.getThemeSettings());
        }
        layout = LayoutServiceUtil.updateLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)unicodeProperties.toString());
        Theme theme = null;
        String themeId = null;
        if (settings != null && Validator.isNotNull((String)settings.getThemeName())) {
            for (Theme curTheme : ThemeLocalServiceUtil.getThemes((long)layout.getCompanyId())) {
                if (!Objects.equals(curTheme.getName(), settings.getThemeName())) continue;
                theme = curTheme;
                themeId = curTheme.getThemeId();
                break;
            }
            if (themeId == null) {
                throw new UnsupportedOperationException();
            }
        }
        String colorSchemeId = null;
        if (settings != null && Validator.isNotNull((String)settings.getColorSchemeName())) {
            ColorScheme colorScheme;
            if (theme == null) {
                throw new UnsupportedOperationException();
            }
            for (ColorScheme colorScheme2 : theme.getColorSchemes()) {
                if (!Objects.equals(colorScheme2.getName(), settings.getColorSchemeName())) continue;
                colorSchemeId = colorScheme2.getColorSchemeId();
                break;
            }
            if (colorSchemeId == null && Objects.equals((colorScheme = ColorSchemeFactoryUtil.getDefaultRegularColorScheme()).getName(), settings.getColorSchemeName())) {
                colorSchemeId = colorScheme.getColorSchemeId();
            }
            if (colorSchemeId == null) {
                throw new UnsupportedOperationException();
            }
        }
        String css = null;
        if (settings != null) {
            css = settings.getCss();
        }
        return LayoutServiceUtil.updateLookAndFeel((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), themeId, colorSchemeId, (String)css);
    }

    private static void _updatePageExperiences(Layout layout, PageExperience[] pageExperiences) throws Exception {
        List segmentsExperiences = SegmentsExperienceServiceUtil.getSegmentsExperiences((long)layout.getGroupId(), (long)layout.getPlid(), (boolean)true);
        if (pageExperiences == null || pageExperiences.length != segmentsExperiences.size()) {
            throw new UnsupportedOperationException();
        }
        HashMap<String, SegmentsExperience> segmentsExperiencesMap = new HashMap<String, SegmentsExperience>();
        for (SegmentsExperience segmentsExperience : segmentsExperiences) {
            segmentsExperiencesMap.put(segmentsExperience.getExternalReferenceCode(), segmentsExperience);
        }
        for (PageExperience pageExperience : pageExperiences) {
            LayoutUtil._updateLayoutPageTemplateStructureData(layout, pageExperience, (SegmentsExperience)segmentsExperiencesMap.get(pageExperience.getExternalReferenceCode()));
        }
    }
}

