/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.dto.v1_0.converter;

import com.liferay.headless.admin.site.dto.v1_0.PageCollectionDefinition;
import com.liferay.headless.admin.site.dto.v1_0.PageCollectionItemDefinition;
import com.liferay.headless.admin.site.dto.v1_0.PageColumnDefinition;
import com.liferay.headless.admin.site.dto.v1_0.PageContainerDefinition;
import com.liferay.headless.admin.site.dto.v1_0.PageDropZoneDefinition;
import com.liferay.headless.admin.site.dto.v1_0.PageElement;
import com.liferay.headless.admin.site.dto.v1_0.PageFormDefinition;
import com.liferay.headless.admin.site.dto.v1_0.PageFormStepContainerDefinition;
import com.liferay.headless.admin.site.dto.v1_0.PageFormStepDefinition;
import com.liferay.headless.admin.site.dto.v1_0.PageFragmentDropZoneDefinition;
import com.liferay.headless.admin.site.dto.v1_0.PageFragmentInstanceDefinition;
import com.liferay.headless.admin.site.dto.v1_0.PageRowDefinition;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.PageElementTypeUtil;
import com.liferay.layout.util.structure.CollectionStyledLayoutStructureItem;
import com.liferay.layout.util.structure.ColumnLayoutStructureItem;
import com.liferay.layout.util.structure.ContainerStyledLayoutStructureItem;
import com.liferay.layout.util.structure.FormStepContainerStyledLayoutStructureItem;
import com.liferay.layout.util.structure.FormStyledLayoutStructureItem;
import com.liferay.layout.util.structure.FragmentDropZoneLayoutStructureItem;
import com.liferay.layout.util.structure.FragmentStyledLayoutStructureItem;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.layout.util.structure.RowStyledLayoutStructureItem;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.layout.util.structure.LayoutStructureItem"}, service={DTOConverter.class})
public class PageElementDTOConverter
implements DTOConverter<LayoutStructureItem, PageElement> {
    @Reference(target="(component.name=com.liferay.headless.admin.site.internal.dto.v1_0.converter.PageCollectionDefinitionDTOConverter)")
    private DTOConverter<CollectionStyledLayoutStructureItem, PageCollectionDefinition> _pageCollectionDefinitionDTOConverter;
    @Reference(target="(component.name=com.liferay.headless.admin.site.internal.dto.v1_0.converter.PageColumnDefinitionDTOConverter)")
    private DTOConverter<ColumnLayoutStructureItem, PageColumnDefinition> _pageColumnDefinitionDTOConverter;
    @Reference(target="(component.name=com.liferay.headless.admin.site.internal.dto.v1_0.converter.PageContainerDefinitionDTOConverter)")
    private DTOConverter<ContainerStyledLayoutStructureItem, PageContainerDefinition> _pageContainerDefinitionDTOConverter;
    @Reference(target="(component.name=com.liferay.headless.admin.site.internal.dto.v1_0.converter.PageFormDefinitionDTOConverter)")
    private DTOConverter<FormStyledLayoutStructureItem, PageFormDefinition> _pageFormDefinitionDTOConverter;
    @Reference(target="(component.name=com.liferay.headless.admin.site.internal.dto.v1_0.converter.PageFormStepContainerDefinitionDTOConverter)")
    private DTOConverter<FormStepContainerStyledLayoutStructureItem, PageFormStepContainerDefinition> _pageFormStepContainerDefinitionDTOConverter;
    @Reference(target="(component.name=com.liferay.headless.admin.site.internal.dto.v1_0.converter.PageFragmentDropZoneDefinitionDTOConverter)")
    private DTOConverter<FragmentDropZoneLayoutStructureItem, PageFragmentDropZoneDefinition> _pageFragmentDropZoneDefinitionDTOConverter;
    @Reference(target="(component.name=com.liferay.headless.admin.site.internal.dto.v1_0.converter.PageFragmentInstanceDefinitionDTOConverter)")
    private DTOConverter<FragmentStyledLayoutStructureItem, PageFragmentInstanceDefinition> _pageFragmentInstanceDefinitionDTOConverter;
    @Reference(target="(component.name=com.liferay.headless.admin.site.internal.dto.v1_0.converter.PageRowDefinitionDTOConverter)")
    private DTOConverter<RowStyledLayoutStructureItem, PageRowDefinition> _pageRowDefinitionDTOConverter;

    public String getContentType() {
        return PageElement.class.getSimpleName();
    }

    public PageElement toDTO(final DTOConverterContext dtoConverterContext, final LayoutStructureItem layoutStructureItem) throws Exception {
        if (dtoConverterContext == null) {
            throw new UnsupportedOperationException();
        }
        final LayoutStructure layoutStructure = (LayoutStructure)dtoConverterContext.getAttribute(LayoutStructure.class.getName());
        if (layoutStructure == null) {
            throw new UnsupportedOperationException();
        }
        return new PageElement(){
            {
                this.setDefinition(() -> PageElementDTOConverter.this._getDefinition(layoutStructureItem));
                this.setExternalReferenceCode(() -> ((LayoutStructureItem)layoutStructureItem).getItemId());
                this.setPageElements(() -> PageElementDTOConverter.this._getPageElements(dtoConverterContext, layoutStructure, layoutStructureItem));
                this.setParentExternalReferenceCode(() -> {
                    if (Objects.equals(layoutStructure.getMainItemId(), layoutStructureItem.getParentItemId())) {
                        return "";
                    }
                    return layoutStructureItem.getParentItemId();
                });
                this.setPosition(() -> {
                    LayoutStructureItem parentLayoutStructureItem = layoutStructure.getLayoutStructureItem(layoutStructureItem.getParentItemId());
                    List childrenItemIds = parentLayoutStructureItem.getChildrenItemIds();
                    return childrenItemIds.indexOf(layoutStructureItem.getItemId());
                });
                this.setType(() -> PageElementTypeUtil.toExternalType(layoutStructureItem.getItemType()));
            }
        };
    }

    private Object _getDefinition(LayoutStructureItem layoutStructureItem) throws Exception {
        if (Objects.equals(layoutStructureItem.getItemType(), "collection")) {
            return this._pageCollectionDefinitionDTOConverter.toDTO((Object)((CollectionStyledLayoutStructureItem)layoutStructureItem));
        }
        if (Objects.equals(layoutStructureItem.getItemType(), "collection-item")) {
            return new PageCollectionItemDefinition();
        }
        if (Objects.equals(layoutStructureItem.getItemType(), "column")) {
            return this._pageColumnDefinitionDTOConverter.toDTO((Object)((ColumnLayoutStructureItem)layoutStructureItem));
        }
        if (Objects.equals(layoutStructureItem.getItemType(), "container")) {
            return this._pageContainerDefinitionDTOConverter.toDTO((Object)((ContainerStyledLayoutStructureItem)layoutStructureItem));
        }
        if (Objects.equals(layoutStructureItem.getItemType(), "drop-zone")) {
            return new PageDropZoneDefinition();
        }
        if (Objects.equals(layoutStructureItem.getItemType(), "form")) {
            return this._pageFormDefinitionDTOConverter.toDTO((Object)((FormStyledLayoutStructureItem)layoutStructureItem));
        }
        if (Objects.equals(layoutStructureItem.getItemType(), "form-step")) {
            return new PageFormStepDefinition();
        }
        if (Objects.equals(layoutStructureItem.getItemType(), "form-step-container")) {
            return this._pageFormStepContainerDefinitionDTOConverter.toDTO((Object)((FormStepContainerStyledLayoutStructureItem)layoutStructureItem));
        }
        if (Objects.equals(layoutStructureItem.getItemType(), "fragment")) {
            return this._pageFragmentInstanceDefinitionDTOConverter.toDTO((Object)((FragmentStyledLayoutStructureItem)layoutStructureItem));
        }
        if (Objects.equals(layoutStructureItem.getItemType(), "fragment-drop-zone")) {
            return this._pageFragmentDropZoneDefinitionDTOConverter.toDTO((Object)((FragmentDropZoneLayoutStructureItem)layoutStructureItem));
        }
        if (Objects.equals(layoutStructureItem.getItemType(), "root")) {
            throw new UnsupportedOperationException();
        }
        if (Objects.equals(layoutStructureItem.getItemType(), "row")) {
            return this._pageRowDefinitionDTOConverter.toDTO((Object)((RowStyledLayoutStructureItem)layoutStructureItem));
        }
        throw new UnsupportedOperationException();
    }

    private PageElement[] _getPageElements(DTOConverterContext dtoConverterContext, LayoutStructure layoutStructure, LayoutStructureItem layoutStructureItem) {
        return (PageElement[])TransformUtil.transformToArray((Collection)layoutStructureItem.getChildrenItemIds(), childrenItemId -> this.toDTO(dtoConverterContext, layoutStructure.getLayoutStructureItem(childrenItemId)), PageElement.class);
    }
}

