/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.resource.v1_0;

import com.liferay.headless.admin.site.dto.v1_0.WidgetPageWidgetInstance;
import com.liferay.headless.admin.site.internal.resource.util.GroupUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.BaseWidgetPageWidgetInstanceResourceImpl;
import com.liferay.headless.admin.site.resource.v1_0.WidgetPageWidgetInstanceResource;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.NoSuchPortletException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutType;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.vulcan.pagination.Page;
import java.util.List;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/widget-page-widget-instance.properties"}, scope=ServiceScope.PROTOTYPE, service={WidgetPageWidgetInstanceResource.class})
public class WidgetPageWidgetInstanceResourceImpl
extends BaseWidgetPageWidgetInstanceResourceImpl {
    private static final Log _log = LogFactoryUtil.getLog(WidgetPageWidgetInstanceResourceImpl.class);
    @Reference
    private LayoutLocalService _layoutLocalService;

    @Override
    public void deleteSiteSiteByExternalReferenceCodeWidgetInstanceWidgetInstanceExternalReferenceCode(String siteExternalReferenceCode, String sitePageExternalReferenceCode, String widgetInstanceExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        Layout layout = this._layoutLocalService.fetchLayoutByExternalReferenceCode(sitePageExternalReferenceCode, GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode));
        if (layout == null) {
            throw new UnsupportedOperationException();
        }
        LayoutType layoutType = layout.getLayoutType();
        if (!(layoutType instanceof LayoutTypePortlet)) {
            throw new UnsupportedOperationException();
        }
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        if (!layoutTypePortlet.hasPortletId(widgetInstanceExternalReferenceCode)) {
            throw new NoSuchPortletException();
        }
        layoutTypePortlet.removePortletId(this.contextUser.getUserId(), widgetInstanceExternalReferenceCode);
        this._layoutLocalService.updateLayout(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), layout.getTypeSettings());
    }

    @Override
    public Page<WidgetPageWidgetInstance> getSiteSiteByExternalReferenceCodeSitePageWidgetInstancesPage(String siteExternalReferenceCode, String sitePageExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        Layout layout = this._layoutLocalService.fetchLayoutByExternalReferenceCode(sitePageExternalReferenceCode, GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode));
        if (layout == null) {
            throw new UnsupportedOperationException();
        }
        LayoutType layoutType = layout.getLayoutType();
        if (!(layoutType instanceof LayoutTypePortlet)) {
            throw new UnsupportedOperationException();
        }
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        return Page.of(this.transform(layoutTypePortlet.getPortletIds(), portletId -> this._toWidgetPageWidgetInstance(layout, (String)portletId)));
    }

    @Override
    public WidgetPageWidgetInstance getSiteSiteByExternalReferenceCodeWidgetInstanceWidgetInstanceExternalReferenceCode(String siteExternalReferenceCode, String sitePageExternalReferenceCode, String widgetInstanceExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        Layout layout = this._layoutLocalService.fetchLayoutByExternalReferenceCode(sitePageExternalReferenceCode, GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode));
        if (layout == null) {
            throw new UnsupportedOperationException();
        }
        LayoutType layoutType = layout.getLayoutType();
        if (!(layoutType instanceof LayoutTypePortlet)) {
            throw new UnsupportedOperationException();
        }
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        if (!layoutTypePortlet.hasPortletId(widgetInstanceExternalReferenceCode)) {
            throw new NoSuchPortletException();
        }
        return this._toWidgetPageWidgetInstance(layout, widgetInstanceExternalReferenceCode);
    }

    @Override
    public WidgetPageWidgetInstance postSiteSiteByExternalReferenceCodeSitePageWidgetInstance(String siteExternalReferenceCode, String sitePageExternalReferenceCode, WidgetPageWidgetInstance widgetPageWidgetInstance) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        Layout layout = this._layoutLocalService.fetchLayoutByExternalReferenceCode(sitePageExternalReferenceCode, GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode));
        if (layout == null) {
            throw new UnsupportedOperationException();
        }
        LayoutType layoutType = layout.getLayoutType();
        if (!(layoutType instanceof LayoutTypePortlet)) {
            throw new UnsupportedOperationException();
        }
        String portletId = PortletIdCodec.encode((String)widgetPageWidgetInstance.getWidgetName(), (String)widgetPageWidgetInstance.getWidgetInstanceId());
        return this._addPortletId(widgetPageWidgetInstance.getParentSectionId(), layout, portletId, widgetPageWidgetInstance.getPosition());
    }

    @Override
    public WidgetPageWidgetInstance putSiteSiteByExternalReferenceCodeWidgetInstanceWidgetInstanceExternalReferenceCode(String siteExternalReferenceCode, String sitePageExternalReferenceCode, String widgetInstanceExternalReferenceCode, WidgetPageWidgetInstance widgetPageWidgetInstance) throws Exception {
        String portletId;
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        Layout layout = this._layoutLocalService.fetchLayoutByExternalReferenceCode(sitePageExternalReferenceCode, GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode));
        if (layout == null) {
            throw new UnsupportedOperationException();
        }
        LayoutType layoutType = layout.getLayoutType();
        if (!(layoutType instanceof LayoutTypePortlet)) {
            throw new UnsupportedOperationException();
        }
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        if (!layoutTypePortlet.hasPortletId(portletId = PortletIdCodec.encode((String)widgetPageWidgetInstance.getWidgetName(), (String)widgetPageWidgetInstance.getWidgetInstanceId()))) {
            return this._addPortletId(widgetPageWidgetInstance.getParentSectionId(), layout, portletId, widgetPageWidgetInstance.getPosition());
        }
        if (!Objects.equals(widgetPageWidgetInstance.getParentSectionId(), this._getParentSectionId(layout, portletId)) || !Objects.equals(widgetPageWidgetInstance.getPosition(), this._getPosition(layout, portletId))) {
            layoutTypePortlet.movePortletId(this.contextUser.getUserId(), portletId, widgetPageWidgetInstance.getParentSectionId(), widgetPageWidgetInstance.getPosition().intValue());
        }
        layout = this._layoutLocalService.updateLayout(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), layout.getTypeSettings());
        return this._toWidgetPageWidgetInstance(layout, portletId);
    }

    private WidgetPageWidgetInstance _addPortletId(String columnId, Layout layout, String portletId, int position) throws Exception {
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        String addedPortletId = layoutTypePortlet.addPortletId(this.contextUser.getUserId(), portletId, columnId, position);
        if (addedPortletId == null) {
            throw new PortalException(StringBundler.concat((Object[])new Object[]{"Portlet ", portletId, " cannot be added to layout ", layout.getPlid(), " by user ", this.contextUser.getUserId()}));
        }
        layout = this._layoutLocalService.updateLayout(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), layout.getTypeSettings());
        return this._toWidgetPageWidgetInstance(layout, addedPortletId);
    }

    private String _getParentSectionId(Layout layout, String portletId) {
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        return layoutTypePortlet.getColumn(portletId);
    }

    private Integer _getPosition(Layout layout, String portletId) {
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        List columns = layoutTypePortlet.getColumns();
        UnicodeProperties typeSettingsUnicodeProperties = layout.getTypeSettingsProperties();
        for (String columnId : columns) {
            String columnValue = typeSettingsUnicodeProperties.getProperty(columnId, "");
            List portletIds = ListUtil.fromString((String)columnValue, (String)",");
            int position = portletIds.indexOf(portletId);
            if (position < 0) continue;
            return position;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Position for portlet cannot be obtained since portlet ", portletId, " cannot be found in layout ", layout.getPlid()}));
        }
        return null;
    }

    private WidgetPageWidgetInstance _toWidgetPageWidgetInstance(final Layout layout, final String portletId) {
        return new WidgetPageWidgetInstance(){
            {
                this.setExternalReferenceCode(() -> portletId);
                this.setParentSectionId(() -> WidgetPageWidgetInstanceResourceImpl.this._getParentSectionId(layout, portletId));
                this.setPosition(() -> WidgetPageWidgetInstanceResourceImpl.this._getPosition(layout, portletId));
                this.setWidgetInstanceId(() -> PortletIdCodec.decodeInstanceId((String)portletId));
                this.setWidgetName(() -> PortletIdCodec.decodePortletName((String)portletId));
            }
        };
    }
}

