/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.resource.v1_0;

import com.liferay.headless.admin.site.dto.v1_0.PageExperience;
import com.liferay.headless.admin.site.internal.resource.util.GroupUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.BasePageExperienceResourceImpl;
import com.liferay.headless.admin.site.resource.v1_0.PageExperienceResource;
import com.liferay.headless.common.spi.service.context.ServiceContextBuilder;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructure;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructureRel;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureLocalService;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureRelLocalService;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import com.liferay.segments.model.SegmentsEntry;
import com.liferay.segments.model.SegmentsExperience;
import com.liferay.segments.service.SegmentsEntryLocalService;
import com.liferay.segments.service.SegmentsExperienceService;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/page-experience.properties"}, scope=ServiceScope.PROTOTYPE, service={PageExperienceResource.class})
public class PageExperienceResourceImpl
extends BasePageExperienceResourceImpl {
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateStructureLocalService _layoutPageTemplateStructureLocalService;
    @Reference
    private LayoutPageTemplateStructureRelLocalService _layoutPageTemplateStructureRelLocalService;
    @Reference(target="(component.name=com.liferay.headless.admin.site.internal.dto.v1_0.converter.PageExperienceDTOConverter)")
    private DTOConverter<LayoutPageTemplateStructureRel, PageExperience> _pageExperienceDTOConverter;
    @Reference
    private SegmentsEntryLocalService _segmentsEntryLocalService;
    @Reference
    private SegmentsExperienceService _segmentsExperienceService;

    @Override
    public void deleteSiteSiteByExternalReferenceCodePageExperience(String siteExternalReferenceCode, String pageExperienceExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        this._segmentsExperienceService.deleteSegmentsExperience(pageExperienceExternalReferenceCode, GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode));
    }

    @Override
    public PageExperience getSiteSiteByExternalReferenceCodePageExperience(String siteExternalReferenceCode, String pageExperienceExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        return this._toPageExperience(this._segmentsExperienceService.getSegmentsExperienceByExternalReferenceCode(pageExperienceExternalReferenceCode, GroupUtil.getGroupId(true, this.contextCompany.getCompanyId(), siteExternalReferenceCode)));
    }

    @Override
    public Page<PageExperience> getSiteSiteByExternalReferenceCodePageSpecificationPageExperiencesPage(String siteExternalReferenceCode, String pageSpecificationExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        Layout layout = this._layoutLocalService.fetchLayoutByExternalReferenceCode(pageSpecificationExternalReferenceCode, GroupUtil.getGroupId(true, this.contextCompany.getCompanyId(), siteExternalReferenceCode));
        if (layout == null) {
            return Page.of(Collections.emptyList());
        }
        return Page.of(this.transform(this._segmentsExperienceService.getSegmentsExperiences(layout.getGroupId(), layout.getPlid(), true, -1, -1, null), segmentsExperience -> this._toPageExperience((SegmentsExperience)segmentsExperience)));
    }

    @Override
    public PageExperience postSiteSiteByExternalReferenceCodePageSpecificationPageExperience(String siteExternalReferenceCode, String pageSpecificationExternalReferenceCode, PageExperience pageExperience) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        return this._addPageExperience(GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode), pageExperience);
    }

    @Override
    public PageExperience putSiteSiteByExternalReferenceCodePageExperience(String siteExternalReferenceCode, String pageExperienceExternalReferenceCode, PageExperience pageExperience) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        long groupId = GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode);
        SegmentsExperience segmentsExperience = this._segmentsExperienceService.fetchSegmentsExperienceByExternalReferenceCode(pageExperienceExternalReferenceCode, groupId);
        if (segmentsExperience == null) {
            return this._addPageExperience(groupId, pageExperience);
        }
        if (pageExperience.getPriority() != null && segmentsExperience.getPriority() != pageExperience.getPriority().intValue()) {
            segmentsExperience = this._segmentsExperienceService.updateSegmentsExperiencePriority(segmentsExperience.getSegmentsExperienceId(), GetterUtil.getInteger((Object)pageExperience.getPriority()));
        }
        return this._toPageExperience(this._segmentsExperienceService.updateSegmentsExperience(segmentsExperience.getSegmentsExperienceId(), this._getSegmentsEntryId(groupId, pageExperience.getSegmentExternalReferenceCode()), LocalizedMapUtil.getLocalizedMap((Map)pageExperience.getName_i18n()), true, UnicodePropertiesBuilder.create((boolean)true).build()));
    }

    private PageExperience _addPageExperience(long groupId, PageExperience pageExperience) throws Exception {
        Layout layout = this._layoutLocalService.fetchLayoutByExternalReferenceCode(pageExperience.getSitePageExternalReferenceCode(), groupId);
        if (layout == null || !Objects.equals(layout.getType(), "collection") && !Objects.equals(layout.getType(), "content")) {
            throw new UnsupportedOperationException();
        }
        SegmentsExperience segmentsExperience = this._segmentsExperienceService.addSegmentsExperience(pageExperience.getExternalReferenceCode(), layout.getGroupId(), this._getSegmentsEntryId(layout.getGroupId(), pageExperience.getSegmentExternalReferenceCode()), pageExperience.getKey(), layout.getPlid(), LocalizedMapUtil.getLocalizedMap((Map)pageExperience.getName_i18n()), GetterUtil.getInteger((Object)pageExperience.getPriority()), true, UnicodePropertiesBuilder.create((boolean)true).build(), ServiceContextBuilder.create((long)layout.getGroupId(), (HttpServletRequest)this.contextHttpServletRequest, null).build());
        LayoutStructure layoutStructure = new LayoutStructure();
        layoutStructure.addRootLayoutStructureItem();
        String data = layoutStructure.toString();
        this._layoutPageTemplateStructureLocalService.updateLayoutPageTemplateStructureData(groupId, layout.getPlid(), segmentsExperience.getSegmentsExperienceId(), data);
        Layout draftLayout = layout.fetchDraftLayout();
        this._layoutPageTemplateStructureLocalService.updateLayoutPageTemplateStructureData(groupId, draftLayout.getPlid(), segmentsExperience.getSegmentsExperienceId(), data);
        return this._toPageExperience(segmentsExperience);
    }

    private long _getSegmentsEntryId(long groupId, String segmentExternalReferenceCode) {
        if (Validator.isNull((String)segmentExternalReferenceCode)) {
            return 0L;
        }
        SegmentsEntry segmentsEntry = this._segmentsEntryLocalService.fetchSegmentsEntry(groupId, segmentExternalReferenceCode);
        if (segmentsEntry == null) {
            throw new UnsupportedOperationException();
        }
        return segmentsEntry.getSegmentsEntryId();
    }

    private PageExperience _toPageExperience(SegmentsExperience segmentsExperience) throws Exception {
        LayoutPageTemplateStructure layoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(segmentsExperience.getGroupId(), segmentsExperience.getPlid());
        LayoutPageTemplateStructureRel layoutPageTemplateStructureRel = this._layoutPageTemplateStructureRelLocalService.fetchLayoutPageTemplateStructureRel(layoutPageTemplateStructure.getLayoutPageTemplateStructureId(), segmentsExperience.getSegmentsExperienceId());
        if (layoutPageTemplateStructureRel == null) {
            throw new UnsupportedOperationException();
        }
        return (PageExperience)this._pageExperienceDTOConverter.toDTO((Object)layoutPageTemplateStructureRel);
    }
}

