/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.resource.v1_0;

import com.liferay.headless.admin.site.dto.v1_0.PageElement;
import com.liferay.headless.admin.site.internal.resource.util.GroupUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.BasePageElementResourceImpl;
import com.liferay.headless.admin.site.resource.v1_0.PageElementResource;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructure;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureLocalService;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.layout.util.structure.LayoutStructureItemUtil;
import com.liferay.layout.util.structure.exception.NoSuchLayoutStructureItemException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.segments.model.SegmentsExperience;
import com.liferay.segments.service.SegmentsExperienceLocalService;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/page-element.properties"}, scope=ServiceScope.PROTOTYPE, service={PageElementResource.class})
public class PageElementResourceImpl
extends BasePageElementResourceImpl {
    private static final Map<PageElement.Type, String> _externalToInternalValuesMap = HashMapBuilder.put((Object)PageElement.Type.COLLECTION, (Object)"collection").put((Object)PageElement.Type.COLLECTION_ITEM, (Object)"collection-item").put((Object)PageElement.Type.COLUMN, (Object)"column").put((Object)PageElement.Type.CONTAINER, (Object)"container").put((Object)PageElement.Type.DROP_ZONE, (Object)"drop-zone").put((Object)PageElement.Type.FORM, (Object)"form").put((Object)PageElement.Type.FRAGMENT, (Object)"fragment").put((Object)PageElement.Type.FRAGMENT_DROP_ZONE, (Object)"fragment-drop-zone").put((Object)PageElement.Type.ROW, (Object)"row").build();
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateStructureLocalService _layoutPageTemplateStructureLocalService;
    @Reference(target="(component.name=com.liferay.headless.admin.site.internal.dto.v1_0.converter.PageElementDTOConverter)")
    private DTOConverter<LayoutStructureItem, PageElement> _pageElementDTOConverter;
    @Reference
    private SegmentsExperienceLocalService _segmentsExperienceLocalService;

    @Override
    public void deleteSiteSiteByExternalReferenceCodePageElement(String siteExternalReferenceCode, String pageSpecificationExternalReferenceCode, String pageExperienceExternalReferenceCode, String pageElementExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        long groupId = GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode);
        Layout layout = this._layoutLocalService.fetchLayoutByExternalReferenceCode(pageSpecificationExternalReferenceCode, groupId);
        if (layout == null) {
            throw new UnsupportedOperationException();
        }
        SegmentsExperience segmentsExperience = this._segmentsExperienceLocalService.fetchSegmentsExperienceByExternalReferenceCode(pageExperienceExternalReferenceCode, groupId);
        if (segmentsExperience == null) {
            throw new UnsupportedOperationException();
        }
        LayoutPageTemplateStructure layoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(layout.getGroupId(), layout.getPlid());
        LayoutStructure layoutStructure = LayoutStructure.of((String)layoutPageTemplateStructure.getData(segmentsExperience.getSegmentsExperienceKey()));
        LayoutStructureItem layoutStructureItem = layoutStructure.getLayoutStructureItem(pageElementExternalReferenceCode);
        if (layoutStructureItem == null) {
            throw new NoSuchLayoutStructureItemException();
        }
        layoutStructure.deleteLayoutStructureItem(pageElementExternalReferenceCode);
        this._layoutPageTemplateStructureLocalService.updateLayoutPageTemplateStructureData(layout.getGroupId(), layout.getPlid(), layoutStructure.toString());
    }

    @Override
    public PageElement getSiteSiteByExternalReferenceCodePageElement(String siteExternalReferenceCode, String pageSpecificationExternalReferenceCode, String pageExperienceExternalReferenceCode, String pageElementExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        long groupId = GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode);
        Layout layout = this._layoutLocalService.fetchLayoutByExternalReferenceCode(pageSpecificationExternalReferenceCode, groupId);
        if (layout == null) {
            throw new UnsupportedOperationException();
        }
        SegmentsExperience segmentsExperience = this._segmentsExperienceLocalService.fetchSegmentsExperienceByExternalReferenceCode(pageExperienceExternalReferenceCode, groupId);
        if (segmentsExperience == null) {
            throw new UnsupportedOperationException();
        }
        LayoutPageTemplateStructure layoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(layout.getGroupId(), layout.getPlid());
        LayoutStructure layoutStructure = LayoutStructure.of((String)layoutPageTemplateStructure.getData(segmentsExperience.getSegmentsExperienceKey()));
        LayoutStructureItem layoutStructureItem = layoutStructure.getLayoutStructureItem(pageElementExternalReferenceCode);
        if (layoutStructureItem == null) {
            throw new NoSuchLayoutStructureItemException();
        }
        return (PageElement)this._pageElementDTOConverter.toDTO((Object)layoutStructureItem);
    }

    @Override
    public Page<PageElement> getSiteSiteByExternalReferenceCodePageElementPageElementsPage(String siteExternalReferenceCode, String pageSpecificationExternalReferenceCode, String pageExperienceExternalReferenceCode, String pageElementExternalReferenceCode, Boolean flatten) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        long groupId = GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode);
        Layout layout = this._layoutLocalService.fetchLayoutByExternalReferenceCode(pageSpecificationExternalReferenceCode, groupId);
        if (layout == null) {
            throw new UnsupportedOperationException();
        }
        SegmentsExperience segmentsExperience = this._segmentsExperienceLocalService.fetchSegmentsExperienceByExternalReferenceCode(pageExperienceExternalReferenceCode, groupId);
        if (segmentsExperience == null) {
            throw new UnsupportedOperationException();
        }
        LayoutPageTemplateStructure layoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(layout.getGroupId(), layout.getPlid());
        LayoutStructure layoutStructure = LayoutStructure.of((String)layoutPageTemplateStructure.getData(segmentsExperience.getSegmentsExperienceKey()));
        LayoutStructureItem layoutStructureItem = layoutStructure.getLayoutStructureItem(pageElementExternalReferenceCode);
        return Page.of(this.transform(LayoutStructureItemUtil.getChildrenItemIds((String)layoutStructureItem.getItemId(), (LayoutStructure)layoutStructure), itemId -> (PageElement)this._pageElementDTOConverter.toDTO((Object)layoutStructure.getLayoutStructureItem(itemId))));
    }

    @Override
    public Page<PageElement> getSiteSiteByExternalReferenceCodePageExperiencePageElementsPage(String siteExternalReferenceCode, String pageSpecificationExternalReferenceCode, String pageExperienceExternalReferenceCode, Boolean flatten) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        long groupId = GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode);
        Layout layout = this._layoutLocalService.fetchLayoutByExternalReferenceCode(pageSpecificationExternalReferenceCode, groupId);
        if (layout == null) {
            throw new UnsupportedOperationException();
        }
        SegmentsExperience segmentsExperience = this._segmentsExperienceLocalService.fetchSegmentsExperienceByExternalReferenceCode(pageExperienceExternalReferenceCode, groupId);
        if (segmentsExperience == null) {
            throw new UnsupportedOperationException();
        }
        LayoutPageTemplateStructure layoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(layout.getGroupId(), layout.getPlid());
        LayoutStructure layoutStructure = LayoutStructure.of((String)layoutPageTemplateStructure.getData(segmentsExperience.getSegmentsExperienceId()));
        return Page.of(this.transform(LayoutStructureItemUtil.getChildrenItemIds((String)layoutStructure.getMainItemId(), (LayoutStructure)layoutStructure), itemId -> (PageElement)this._pageElementDTOConverter.toDTO((Object)layoutStructure.getLayoutStructureItem(itemId))));
    }

    @Override
    public PageElement postSiteSiteByExternalReferenceCodePageExperiencePageElement(String siteExternalReferenceCode, String pageSpecificationExternalReferenceCode, String pageExperienceExternalReferenceCode, PageElement pageElement) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        long groupId = GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode);
        Layout layout = this._layoutLocalService.fetchLayoutByExternalReferenceCode(pageSpecificationExternalReferenceCode, groupId);
        if (layout == null) {
            throw new UnsupportedOperationException();
        }
        SegmentsExperience segmentsExperience = this._segmentsExperienceLocalService.fetchSegmentsExperienceByExternalReferenceCode(pageExperienceExternalReferenceCode, groupId);
        if (segmentsExperience == null) {
            throw new UnsupportedOperationException();
        }
        LayoutPageTemplateStructure layoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(layout.getGroupId(), layout.getPlid());
        LayoutStructure layoutStructure = LayoutStructure.of((String)layoutPageTemplateStructure.getData(segmentsExperience.getSegmentsExperienceId()));
        LayoutStructureItem layoutStructureItem = layoutStructure.addLayoutStructureItem(pageElement.getExternalReferenceCode(), _externalToInternalValuesMap.get(pageElement.getType()), pageElement.getParentExternalReferenceCode(), pageElement.getPosition().intValue());
        this._addChildPageElements(layoutStructure, pageElement);
        this._layoutPageTemplateStructureLocalService.updateLayoutPageTemplateStructureData(layout.getGroupId(), layout.getPlid(), layoutStructure.toString());
        return (PageElement)this._pageElementDTOConverter.toDTO((Object)layoutStructureItem);
    }

    private void _addChildPageElements(LayoutStructure layoutStructure, PageElement pageElement) {
        for (PageElement childPageElement : pageElement.getPageElements()) {
            layoutStructure.addLayoutStructureItem(_externalToInternalValuesMap.get(childPageElement.getType()), childPageElement.getParentExternalReferenceCode(), childPageElement.getPosition().intValue());
            this._addChildPageElements(layoutStructure, childPageElement);
        }
    }
}

