/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.dto.v1_0.converter;

import com.liferay.headless.admin.site.dto.v1_0.ClassSubtypeReference;
import com.liferay.headless.admin.site.dto.v1_0.CollectionReference;
import com.liferay.headless.admin.site.dto.v1_0.DisplayPageTemplate;
import com.liferay.headless.admin.site.dto.v1_0.DisplayPageTemplateFolder;
import com.liferay.headless.admin.site.dto.v1_0.ItemExternalReference;
import com.liferay.info.item.InfoItemFormVariation;
import com.liferay.info.item.InfoItemServiceRegistry;
import com.liferay.info.item.provider.InfoItemFormVariationsProvider;
import com.liferay.layout.page.template.model.LayoutPageTemplateCollection;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateCollectionLocalService;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.layout.page.template.model.LayoutPageTemplateEntry"}, service={DTOConverter.class})
public class DisplayPageTemplateDTOConverter
implements DTOConverter<LayoutPageTemplateEntry, DisplayPageTemplate> {
    @Reference(target="(component.name=com.liferay.headless.admin.site.internal.dto.v1_0.converter.DisplayPageTemplateFolderDTOConverter)")
    private DTOConverter<LayoutPageTemplateCollection, DisplayPageTemplateFolder> _displayPageTemplateFolderDTOConverter;
    @Reference
    private InfoItemServiceRegistry _infoItemServiceRegistry;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateCollectionLocalService _layoutPageTemplateCollectionLocalService;
    @Reference
    private PortletFileRepository _portletFileRepository;

    public String getContentType() {
        return DisplayPageTemplate.class.getSimpleName();
    }

    public DisplayPageTemplate toDTO(DTOConverterContext dtoConverterContext, final LayoutPageTemplateEntry layoutPageTemplateEntry) throws Exception {
        final Layout layout = this._layoutLocalService.getLayout(layoutPageTemplateEntry.getPlid());
        return new DisplayPageTemplate(){
            {
                this.setContentTypeReference(() -> new ClassSubtypeReference(){
                    {
                        this.setClassName(() -> ((LayoutPageTemplateEntry)layoutPageTemplateEntry).getClassName());
                        this.setSubTypeExternalReference(() -> DisplayPageTemplateDTOConverter.this._getSubtypeItemExternalReference(layoutPageTemplateEntry));
                    }
                });
                this.setDateCreated(() -> ((LayoutPageTemplateEntry)layoutPageTemplateEntry).getCreateDate());
                this.setDateModified(() -> ((LayoutPageTemplateEntry)layoutPageTemplateEntry).getModifiedDate());
                this.setDatePublished(() -> ((Layout)layout).getPublishDate());
                this.setExternalReferenceCode(() -> ((LayoutPageTemplateEntry)layoutPageTemplateEntry).getExternalReferenceCode());
                this.setFriendlyUrlPath_i18n(() -> LocalizedMapUtil.getI18nMap((boolean)true, (Map)layout.getFriendlyURLMap()));
                this.setKey(() -> ((LayoutPageTemplateEntry)layoutPageTemplateEntry).getLayoutPageTemplateEntryKey());
                this.setMarkedAsDefault(() -> ((LayoutPageTemplateEntry)layoutPageTemplateEntry).isDefaultTemplate());
                this.setName(() -> ((LayoutPageTemplateEntry)layoutPageTemplateEntry).getName());
                this.setParentFolder(() -> {
                    LayoutPageTemplateCollection layoutPageTemplateCollection = DisplayPageTemplateDTOConverter.this._layoutPageTemplateCollectionLocalService.fetchLayoutPageTemplateCollection(layoutPageTemplateEntry.getLayoutPageTemplateCollectionId());
                    if (layoutPageTemplateCollection == null) {
                        return null;
                    }
                    return (DisplayPageTemplateFolder)DisplayPageTemplateDTOConverter.this._displayPageTemplateFolderDTOConverter.toDTO((Object)layoutPageTemplateCollection);
                });
                this.setThumbnail(() -> {
                    if (layoutPageTemplateEntry.getPreviewFileEntryId() <= 0L) {
                        return null;
                    }
                    final FileEntry fileEntry = DisplayPageTemplateDTOConverter.this._portletFileRepository.getPortletFileEntry(layoutPageTemplateEntry.getPreviewFileEntryId());
                    if (fileEntry == null) {
                        return null;
                    }
                    return new ItemExternalReference(){
                        {
                            this.setClassName(() -> FileEntry.class.getName());
                            this.setCollectionType(CollectionReference.CollectionType.COLLECTION);
                            this.setExternalReferenceCode(() -> ((FileEntry)fileEntry).getExternalReferenceCode());
                        }
                    };
                });
                this.setUuid(() -> ((LayoutPageTemplateEntry)layoutPageTemplateEntry).getUuid());
            }
        };
    }

    private ItemExternalReference _getSubtypeItemExternalReference(LayoutPageTemplateEntry layoutPageTemplateEntry) {
        InfoItemFormVariationsProvider infoItemFormVariationsProvider = (InfoItemFormVariationsProvider)this._infoItemServiceRegistry.getFirstInfoItemService(InfoItemFormVariationsProvider.class, layoutPageTemplateEntry.getClassName());
        if (infoItemFormVariationsProvider == null) {
            return null;
        }
        final InfoItemFormVariation infoItemFormVariation = infoItemFormVariationsProvider.getInfoItemFormVariation(layoutPageTemplateEntry.getGroupId(), String.valueOf(layoutPageTemplateEntry.getClassTypeId()));
        if (infoItemFormVariation == null) {
            return null;
        }
        return new ItemExternalReference(){
            {
                this.setCollectionType(CollectionReference.CollectionType.COLLECTION);
                this.setExternalReferenceCode(() -> ((InfoItemFormVariation)infoItemFormVariation).getExternalReferenceCode());
            }
        };
    }
}

