/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.resource.v1_0.util;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.service.AssetCategoryServiceUtil;
import com.liferay.headless.admin.site.dto.v1_0.ContentPageSpecification;
import com.liferay.headless.admin.site.dto.v1_0.ItemExternalReference;
import com.liferay.headless.admin.site.dto.v1_0.PageSettings;
import com.liferay.headless.admin.site.dto.v1_0.PageSpecification;
import com.liferay.headless.admin.site.dto.v1_0.WidgetPageSettings;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.GroupUtil;
import com.liferay.headless.admin.site.internal.util.LogUtil;
import com.liferay.headless.common.spi.service.context.ServiceContextBuilder;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalServiceUtil;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.GroupServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutPrototypeLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetPrototypeLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.scope.Scope;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;

public class ServiceContextUtil {
    public static ServiceContext createServiceContext(ItemExternalReference[] assetCategoriesItemExternalReferences, long companyId, Date createDate, long groupId, HttpServletRequest httpServletRequest, String[] keywords, Date modifiedDate, long userId, String uuid, PageSettings pageSettings) throws Exception {
        ServiceContext serviceContext = ServiceContextBuilder.create((long)groupId, (HttpServletRequest)httpServletRequest, null).build();
        serviceContext.setAssetCategoryIds(ServiceContextUtil._getAssetCategoryIds(groupId, assetCategoriesItemExternalReferences));
        serviceContext.setAssetTagNames(keywords);
        serviceContext.setCompanyId(companyId);
        serviceContext.setCreateDate(createDate);
        serviceContext.setModifiedDate(modifiedDate);
        serviceContext.setUserId(userId);
        serviceContext.setUuid(uuid);
        if (pageSettings instanceof WidgetPageSettings) {
            WidgetPageSettings widgetPageSettings = (WidgetPageSettings)pageSettings;
            serviceContext.setAttribute("layoutPrototypeLinkEnabled", (Serializable)widgetPageSettings.getInheritChanges());
            ItemExternalReference itemExternalReference = widgetPageSettings.getWidgetPageTemplateReference();
            if (itemExternalReference != null) {
                LayoutPageTemplateEntry layoutPageTemplateEntry;
                long scopeGroupId = groupId;
                Scope scope = itemExternalReference.getScope();
                if (scope != null) {
                    Group group = GroupLocalServiceUtil.getGroupByExternalReferenceCode((String)scope.getExternalReferenceCode(), (long)companyId);
                    scopeGroupId = group.getGroupId();
                }
                if ((layoutPageTemplateEntry = LayoutPageTemplateEntryLocalServiceUtil.fetchLayoutPageTemplateEntryByExternalReferenceCode((String)itemExternalReference.getExternalReferenceCode(), (long)scopeGroupId)) == null) {
                    throw new UnsupportedOperationException();
                }
                LayoutPrototype layoutPrototype = LayoutPrototypeLocalServiceUtil.fetchLayoutPrototype((long)layoutPageTemplateEntry.getLayoutPrototypeId());
                if (layoutPrototype == null) {
                    throw new UnsupportedOperationException();
                }
                serviceContext.setAttribute("layoutPrototypeUuid", (Serializable)((Object)layoutPrototype.getUuid()));
            }
        }
        return serviceContext;
    }

    public static ServiceContext createServiceContext(long groupId, HttpServletRequest httpServletRequest, long userId) {
        ServiceContext serviceContext = ServiceContextBuilder.create((long)groupId, (HttpServletRequest)httpServletRequest, null).build();
        serviceContext.setUserId(userId);
        return serviceContext;
    }

    public static void setLayoutSetPrototypeLayoutERC(long groupId, PageSpecification pageSpecification, ServiceContext serviceContext) throws Exception {
        LayoutSet layoutSet;
        ContentPageSpecification contentPageSpecification;
        if (Validator.isNull((String)pageSpecification.getSiteTemplatePageSpecificationExternalReferenceCode())) {
            return;
        }
        boolean privateLayout = Boolean.FALSE;
        int layoutPageTemplateEntryType = GetterUtil.getInteger((Object)serviceContext.getAttribute("layout.page.template.entry.type"), (int)-1);
        if (Objects.equals(0, layoutPageTemplateEntryType) || Objects.equals(3, layoutPageTemplateEntryType) || Objects.equals(2, layoutPageTemplateEntryType)) {
            privateLayout = Boolean.TRUE;
        }
        boolean draftLayout = Boolean.FALSE;
        if (Objects.equals(PageSpecification.Type.CONTENT_PAGE_SPECIFICATION, pageSpecification.getType()) && Validator.isNull((String)(contentPageSpecification = (ContentPageSpecification)pageSpecification).getDraftContentPageSpecificationExternalReferenceCode())) {
            draftLayout = Boolean.TRUE;
            privateLayout = Boolean.TRUE;
        }
        if (!(layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)groupId, (boolean)privateLayout)).isLayoutSetPrototypeLinkActive()) {
            return;
        }
        LayoutSetPrototype layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototypeByUuidAndCompanyId((String)layoutSet.getLayoutSetPrototypeUuid(), (long)layoutSet.getCompanyId());
        String siteTemplatePageSpecificationExternalReferenceCode = pageSpecification.getSiteTemplatePageSpecificationExternalReferenceCode();
        Layout layoutSetPrototypeLayout = LayoutLocalServiceUtil.fetchLayoutByExternalReferenceCode((String)siteTemplatePageSpecificationExternalReferenceCode, (long)layoutSetPrototype.getGroupId());
        if (layoutSetPrototypeLayout == null) {
            LogUtil.logOptionalReference(Layout.class, siteTemplatePageSpecificationExternalReferenceCode, layoutSetPrototype.getGroupId());
        }
        serviceContext.setAttribute(draftLayout ? "draftLayoutLayoutSetPrototypeLayoutERC" : "layoutSetPrototypeLayoutERC", (Serializable)((Object)siteTemplatePageSpecificationExternalReferenceCode));
    }

    private static long[] _getAssetCategoryIds(long groupId, ItemExternalReference[] itemExternalReferences) throws Exception {
        if (ArrayUtil.isEmpty((Object[])itemExternalReferences)) {
            return new long[0];
        }
        Group group = GroupServiceUtil.getGroup((long)groupId);
        return TransformUtil.unsafeTransformToLongArray((Collection)ListUtil.fromArray((Object[])itemExternalReferences), itemExternalReference -> {
            AssetCategory assetCategory;
            long scopeGroupId = groupId;
            Scope scope = itemExternalReference.getScope();
            if (scope != null) {
                scopeGroupId = GroupUtil.getGroupId(true, true, group.getCompanyId(), scope.getExternalReferenceCode());
            }
            if ((assetCategory = AssetCategoryServiceUtil.fetchCategoryByExternalReferenceCode((String)itemExternalReference.getExternalReferenceCode(), (long)scopeGroupId)) == null) {
                throw new UnsupportedOperationException();
            }
            return assetCategory.getCategoryId();
        });
    }
}

