/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.resource.v1_0.util;

import com.liferay.headless.admin.site.dto.v1_0.SEOSettings;
import com.liferay.headless.admin.site.dto.v1_0.SitemapSettings;
import com.liferay.layout.seo.model.LayoutSEOEntry;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.util.HashMap;
import java.util.Map;

public class SEOSettingsUtil {
    private static final Log _log = LogFactoryUtil.getLog(SEOSettingsUtil.class);

    public static SEOSettings getSeoSettings(final Layout layout, final LayoutSEOEntry layoutSEOEntry) {
        return new SEOSettings(){
            {
                this.setCustomCanonicalURL_i18n(() -> {
                    if (layoutSEOEntry == null || !layoutSEOEntry.isCanonicalURLEnabled()) {
                        return new HashMap();
                    }
                    return LocalizedMapUtil.getI18nMap((Map)layoutSEOEntry.getCanonicalURLMap());
                });
                this.setDescription_i18n(() -> LocalizedMapUtil.getI18nMap((Map)layout.getDescriptionMap()));
                this.setHtmlTitle_i18n(() -> LocalizedMapUtil.getI18nMap((Map)layout.getTitleMap()));
                this.setRobots_i18n(() -> LocalizedMapUtil.getI18nMap((Map)layout.getRobotsMap()));
                this.setSeoKeywords_i18n(() -> LocalizedMapUtil.getI18nMap((Map)layout.getKeywordsMap()));
                this.setSitemapSettings(() -> SEOSettingsUtil._toSitemapSettings(layout.getTypeSettingsProperties()));
            }
        };
    }

    private static SitemapSettings _toSitemapSettings(UnicodeProperties unicodeProperties) {
        final String sitemapChangeFreq = unicodeProperties.getProperty("sitemap-changefreq");
        final String sitemapInclude = unicodeProperties.getProperty("sitemap-include");
        final String sitemapIncludeChildLayouts = unicodeProperties.getProperty("sitemap-include-child-layouts");
        final String sitemapPriority = unicodeProperties.getProperty("sitemap-priority");
        if (sitemapChangeFreq == null && sitemapInclude == null && sitemapIncludeChildLayouts == null && sitemapPriority == null) {
            return null;
        }
        return new SitemapSettings(){
            {
                this.setChangeFrequency(() -> {
                    if (sitemapChangeFreq == null) {
                        return null;
                    }
                    return SitemapSettings.ChangeFrequency.create((String)StringUtil.upperCaseFirstLetter((String)sitemapChangeFreq));
                });
                this.setInclude(() -> {
                    if (sitemapInclude == null) {
                        return null;
                    }
                    if (sitemapInclude.equals("0")) {
                        return false;
                    }
                    if (sitemapInclude.equals("1")) {
                        return true;
                    }
                    return null;
                });
                this.setIncludeChildSitePages(() -> {
                    if (sitemapIncludeChildLayouts == null) {
                        return null;
                    }
                    if (sitemapIncludeChildLayouts.equals("false")) {
                        return false;
                    }
                    if (sitemapIncludeChildLayouts.equals("true")) {
                        return true;
                    }
                    return null;
                });
                this.setPagePriority(() -> {
                    if (sitemapPriority == null) {
                        return null;
                    }
                    try {
                        return Double.parseDouble(sitemapPriority);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (_log.isWarnEnabled()) {
                            _log.warn((Throwable)numberFormatException);
                        }
                        return null;
                    }
                });
            }
        };
    }
}

