/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.resource.v1_0.util;

import com.liferay.headless.admin.site.dto.v1_0.NavigationSettings;
import com.liferay.headless.admin.site.dto.v1_0.SitePageNavigationSettings;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.util.Objects;

public class NavigationSettingsUtil {
    public static NavigationSettings toNavigationSettings(final UnicodeProperties unicodeProperties) {
        return new NavigationSettings(){
            {
                this.setTarget(() -> NavigationSettingsUtil._getTarget(unicodeProperties));
                this.setTargetType(() -> {
                    if (NavigationSettingsUtil._isUseNewTab(unicodeProperties)) {
                        return NavigationSettings.TargetType.NEW_TAB;
                    }
                    return NavigationSettings.TargetType.SPECIFIC_FRAME;
                });
            }
        };
    }

    public static SitePageNavigationSettings toSitePageNavigationSettings(final UnicodeProperties unicodeProperties) {
        return new SitePageNavigationSettings(){
            {
                this.setQueryString(() -> unicodeProperties.getProperty("query-string"));
                this.setTarget(() -> NavigationSettingsUtil._getTarget(unicodeProperties));
                this.setTargetType(() -> {
                    if (NavigationSettingsUtil._isUseNewTab(unicodeProperties)) {
                        return SitePageNavigationSettings.TargetType.NEW_TAB;
                    }
                    return SitePageNavigationSettings.TargetType.SPECIFIC_FRAME;
                });
            }
        };
    }

    private static String _getTarget(UnicodeProperties unicodeProperties) {
        return unicodeProperties.getProperty("target");
    }

    private static boolean _isUseNewTab(UnicodeProperties unicodeProperties) {
        return Objects.equals(unicodeProperties.getProperty("targetType"), "useNewTab");
    }
}

