/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.resource.v1_0.layout.structure.item.importer;

import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.processor.DefaultFragmentEntryProcessorContext;
import com.liferay.fragment.processor.FragmentEntryProcessorContext;
import com.liferay.fragment.processor.FragmentEntryProcessorRegistry;
import com.liferay.fragment.processor.PortletRegistry;
import com.liferay.fragment.service.FragmentEntryLinkLocalServiceUtil;
import com.liferay.headless.admin.site.dto.v1_0.BasicFragmentInstancePageElementDefinition;
import com.liferay.headless.admin.site.dto.v1_0.FormFragmentInstancePageElementDefinition;
import com.liferay.headless.admin.site.dto.v1_0.FragmentInstance;
import com.liferay.headless.admin.site.dto.v1_0.PageElement;
import com.liferay.headless.admin.site.dto.v1_0.PageElementDefinition;
import com.liferay.headless.admin.site.dto.v1_0.WidgetInstance;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.FragmentEditableElementUtil;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.FragmentEntryReference;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.FragmentEntryReferenceUtil;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.FragmentViewportUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.layout.structure.item.importer.LayoutStructureItemImporter;
import com.liferay.headless.admin.site.internal.resource.v1_0.layout.structure.item.importer.context.LayoutStructureItemImporterContext;
import com.liferay.headless.admin.site.internal.resource.v1_0.layout.structure.item.importer.util.FragmentConfigurationFieldValuesUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.LayoutStructureUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.PortletUtil;
import com.liferay.layout.util.structure.FragmentStyledLayoutStructureItem;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;

public class FragmentLayoutStructureItemImporter
implements LayoutStructureItemImporter {
    private static final ServiceTracker<PortletRegistry, PortletRegistry> _portletRegistryServiceTracker = ServiceTrackerFactory.open((Bundle)FrameworkUtil.getBundle(FragmentLayoutStructureItemImporter.class), PortletRegistry.class);

    @Override
    public LayoutStructureItem addLayoutStructureItem(LayoutStructure layoutStructure, LayoutStructureItemImporterContext layoutStructureItemImporterContext, PageElement pageElement) throws Exception {
        PageElementDefinition pageElementDefinition = pageElement.getPageElementDefinition();
        FragmentInstance fragmentInstance = this._getFragmentInstance(pageElementDefinition);
        if (fragmentInstance == null) {
            return null;
        }
        List fragmentEntryLinkPortletIds = null;
        FragmentEntryLink fragmentEntryLink = FragmentEntryLinkLocalServiceUtil.fetchFragmentEntryLinkByExternalReferenceCode((String)fragmentInstance.getFragmentInstanceExternalReferenceCode(), (long)layoutStructureItemImporterContext.getGroupId());
        if (fragmentEntryLink == null) {
            fragmentEntryLink = this._addFragmentEntryLink(fragmentInstance, layoutStructureItemImporterContext, pageElementDefinition);
        } else {
            PortletRegistry portletRegistry = (PortletRegistry)_portletRegistryServiceTracker.getService();
            if (portletRegistry != null) {
                fragmentEntryLinkPortletIds = portletRegistry.getFragmentEntryLinkPortletIds(fragmentEntryLink);
            }
            fragmentEntryLink = this._updateFragmentEntryLink(fragmentEntryLink, fragmentInstance, layoutStructureItemImporterContext, pageElementDefinition);
        }
        if (fragmentEntryLink == null) {
            return null;
        }
        Layout layout = layoutStructureItemImporterContext.getLayout();
        if (ArrayUtil.isNotEmpty((Object[])fragmentInstance.getWidgetInstances())) {
            for (WidgetInstance widgetInstance : fragmentInstance.getWidgetInstances()) {
                if (Validator.isNull((String)widgetInstance.getWidgetName())) continue;
                String portletId = PortletIdCodec.encode((String)widgetInstance.getWidgetName(), (String)widgetInstance.getWidgetInstanceId());
                PortletUtil.importPortletPermissions(layout, portletId, widgetInstance.getWidgetName(), widgetInstance.getWidgetPermissions());
                PortletUtil.importPortletPreferences(layout, portletId, widgetInstance.getWidgetConfig());
            }
        }
        if (ListUtil.isNotEmpty((List)fragmentEntryLinkPortletIds)) {
            for (String fragmentEntryLinkPortletId : SetUtil.asymmetricDifference((Collection)fragmentEntryLinkPortletIds, this._getPortletIds(fragmentInstance.getWidgetInstances()))) {
                PortletPreferencesLocalServiceUtil.deletePortletPreferences((long)0L, (int)3, (long)layout.getPlid(), (String)fragmentEntryLinkPortletId);
                ResourcePermissionLocalServiceUtil.deleteResourcePermissions((long)layout.getCompanyId(), (String)fragmentEntryLinkPortletId, (int)4, (String)PortletPermissionUtil.getPrimaryKey((long)layout.getPlid(), (String)fragmentEntryLinkPortletId));
            }
        }
        FragmentStyledLayoutStructureItem fragmentStyledLayoutStructureItem = (FragmentStyledLayoutStructureItem)layoutStructure.addFragmentStyledLayoutStructureItem(fragmentEntryLink.getFragmentEntryLinkId(), pageElement.getExternalReferenceCode(), LayoutStructureUtil.getParentExternalReferenceCode(pageElement, layoutStructure), pageElement.getPosition().intValue());
        fragmentStyledLayoutStructureItem.setCssClasses(SetUtil.fromArray((Object[])fragmentInstance.getCssClasses()));
        fragmentStyledLayoutStructureItem.setIndexed(GetterUtil.getBoolean((Object)fragmentInstance.getIndexed(), (boolean)true));
        fragmentStyledLayoutStructureItem.setName(fragmentInstance.getName());
        JSONObject fragmentViewportsJSONObject = FragmentViewportUtil.toFragmentViewportsJSONObject(fragmentInstance.getFragmentViewports());
        if (fragmentViewportsJSONObject != null) {
            fragmentStyledLayoutStructureItem.updateItemConfig(fragmentViewportsJSONObject);
        }
        return fragmentStyledLayoutStructureItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FragmentEntryLink _addFragmentEntryLink(FragmentInstance fragmentInstance, LayoutStructureItemImporterContext layoutStructureItemImporterContext, PageElementDefinition pageElementDefinition) throws Exception {
        Layout layout = layoutStructureItemImporterContext.getLayout();
        FragmentEntryReference fragmentEntryReference = FragmentEntryReferenceUtil.getFragmentEntryReference(layoutStructureItemImporterContext.getCompanyId(), fragmentInstance.getFragmentReference(), layoutStructureItemImporterContext.getGroupId());
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date createDate = serviceContext.getCreateDate();
        String uuid = serviceContext.getUuid();
        try {
            serviceContext.setCreateDate(fragmentInstance.getDatePropagated());
            serviceContext.setUuid(fragmentInstance.getUuid());
            FragmentEntryLink fragmentEntryLink = FragmentEntryLinkLocalServiceUtil.addFragmentEntryLink((String)fragmentInstance.getFragmentInstanceExternalReferenceCode(), (long)layoutStructureItemImporterContext.getUserId(), (long)layout.getGroupId(), (String)this._getOriginalFragmentEntryLinkERC(fragmentInstance, layoutStructureItemImporterContext), (String)fragmentEntryReference.getFragmentEntryERC(), (String)fragmentEntryReference.getFragmentEntryScopeERC(), (long)layoutStructureItemImporterContext.getSegmentsExperienceId(), (long)layout.getPlid(), (String)GetterUtil.getString((String)fragmentInstance.getCss()), (String)GetterUtil.getString((String)fragmentInstance.getHtml()), (String)GetterUtil.getString((String)fragmentInstance.getJs()), (String)GetterUtil.getString((String)fragmentInstance.getConfiguration()), (String)this._getEditableValues(fragmentInstance, layoutStructureItemImporterContext, pageElementDefinition), (String)fragmentInstance.getNamespace(), (int)0, (String)fragmentEntryReference.getRendererKey(), (int)this._getType(pageElementDefinition.getType()), (ServiceContext)serviceContext);
            FragmentEntryProcessorRegistry fragmentEntryProcessorRegistry = layoutStructureItemImporterContext.getFragmentEntryProcessorRegistry();
            FragmentEntryLink fragmentEntryLink2 = FragmentEntryLinkLocalServiceUtil.updateFragmentEntryLink((long)fragmentEntryLink.getUserId(), (long)fragmentEntryLink.getFragmentEntryLinkId(), (String)fragmentEntryProcessorRegistry.mergeDefaultEditableValues(fragmentEntryLink.getConfigurationJSONObject(), fragmentEntryLink.getEditableValuesJSONObject(), this._getProcessedHTML(fragmentEntryLink, fragmentEntryProcessorRegistry, serviceContext)), (boolean)false);
            return fragmentEntryLink2;
        }
        finally {
            serviceContext.setCreateDate(createDate);
            serviceContext.setUuid(uuid);
        }
    }

    private String _getEditableValues(FragmentInstance fragmentInstance, LayoutStructureItemImporterContext layoutStructureItemImporterContext, PageElementDefinition pageElementDefinition) throws Exception {
        return JSONUtil.put((String)"com.liferay.fragment.entry.processor.background.image.BackgroundImageFragmentEntryProcessor", (Object)FragmentEditableElementUtil.getBackgroundImageFragmentEntryProcessorJSONObject(fragmentInstance.getFragmentEditableElements(), layoutStructureItemImporterContext)).put("com.liferay.fragment.entry.processor.editable.EditableFragmentEntryProcessor", FragmentEditableElementUtil.getEditableFragmentEntryProcessorJSONObject(fragmentInstance.getFragmentEditableElements(), layoutStructureItemImporterContext)).put("com.liferay.fragment.entry.processor.freemarker.FreeMarkerFragmentEntryProcessor", FragmentConfigurationFieldValuesUtil.getFreeMarkerFragmentEntryProcessorJSONObject(pageElementDefinition, layoutStructureItemImporterContext)).toString();
    }

    private FragmentInstance _getFragmentInstance(PageElementDefinition pageElementDefinition) {
        if (pageElementDefinition instanceof BasicFragmentInstancePageElementDefinition) {
            BasicFragmentInstancePageElementDefinition basicFragmentInstancePageElementDefinition = (BasicFragmentInstancePageElementDefinition)pageElementDefinition;
            return basicFragmentInstancePageElementDefinition.getFragmentInstance();
        }
        if (pageElementDefinition instanceof FormFragmentInstancePageElementDefinition) {
            FormFragmentInstancePageElementDefinition formFragmentInstancePageElementDefinition = (FormFragmentInstancePageElementDefinition)pageElementDefinition;
            return formFragmentInstancePageElementDefinition.getFragmentInstance();
        }
        return null;
    }

    private String _getOriginalFragmentEntryLinkERC(FragmentInstance fragmentInstance, LayoutStructureItemImporterContext layoutStructureItemImporterContext) {
        if (Validator.isNull((String)fragmentInstance.getDraftFragmentInstanceExternalReferenceCode())) {
            return null;
        }
        FragmentEntryLink fragmentEntryLink = FragmentEntryLinkLocalServiceUtil.fetchFragmentEntryLinkByExternalReferenceCode((String)fragmentInstance.getDraftFragmentInstanceExternalReferenceCode(), (long)layoutStructureItemImporterContext.getGroupId());
        if (fragmentEntryLink == null) {
            return null;
        }
        return fragmentEntryLink.getExternalReferenceCode();
    }

    private List<String> _getPortletIds(WidgetInstance[] widgetInstances) {
        ArrayList<String> portletIds = new ArrayList<String>();
        if (ArrayUtil.isEmpty((Object[])widgetInstances)) {
            return portletIds;
        }
        for (WidgetInstance widgetInstance : widgetInstances) {
            portletIds.add(PortletIdCodec.encode((String)widgetInstance.getWidgetName(), (String)widgetInstance.getWidgetInstanceId()));
        }
        return portletIds;
    }

    private String _getProcessedHTML(FragmentEntryLink fragmentEntryLink, FragmentEntryProcessorRegistry fragmentEntryProcessorRegistry, ServiceContext serviceContext) throws PortalException {
        if (serviceContext == null) {
            return fragmentEntryLink.getHtml();
        }
        HttpServletRequest httpServletRequest = serviceContext.getRequest();
        HttpServletResponse httpServletResponse = serviceContext.getResponse();
        ThemeDisplay themeDisplay = serviceContext.getThemeDisplay();
        if (httpServletRequest == null && themeDisplay != null) {
            httpServletRequest = themeDisplay.getRequest();
        }
        if (httpServletResponse == null && themeDisplay != null) {
            httpServletResponse = themeDisplay.getResponse();
        }
        if (httpServletRequest == null || httpServletResponse == null) {
            return fragmentEntryLink.getHtml();
        }
        fragmentEntryLink.setEditableValues(null);
        DefaultFragmentEntryProcessorContext fragmentEntryProcessorContext = new DefaultFragmentEntryProcessorContext(httpServletRequest, httpServletResponse, "EDIT", LocaleUtil.getMostRelevantLocale());
        return fragmentEntryProcessorRegistry.processFragmentEntryLinkHTML(fragmentEntryLink, (FragmentEntryProcessorContext)fragmentEntryProcessorContext);
    }

    private int _getType(PageElementDefinition.Type pageElementDefinitionType) {
        int type = 1;
        if (Objects.equals(PageElementDefinition.Type.FORM_FRAGMENT, pageElementDefinitionType)) {
            type = 3;
        }
        return type;
    }

    private FragmentEntryLink _updateFragmentEntryLink(FragmentEntryLink fragmentEntryLink, FragmentInstance fragmentInstance, LayoutStructureItemImporterContext layoutStructureItemImporterContext, PageElementDefinition pageElementDefinition) throws Exception {
        Layout layout = layoutStructureItemImporterContext.getLayout();
        if (fragmentEntryLink.getPlid() != layout.getPlid() || fragmentEntryLink.getSegmentsExperienceId() != layoutStructureItemImporterContext.getSegmentsExperienceId()) {
            throw new UnsupportedOperationException();
        }
        FragmentEntryReference fragmentEntryReference = FragmentEntryReferenceUtil.getFragmentEntryReference(layoutStructureItemImporterContext.getCompanyId(), fragmentInstance.getFragmentReference(), layoutStructureItemImporterContext.getGroupId());
        fragmentEntryLink.setOriginalFragmentEntryLinkERC(this._getOriginalFragmentEntryLinkERC(fragmentInstance, layoutStructureItemImporterContext));
        fragmentEntryLink.setFragmentEntryERC(fragmentEntryReference.getFragmentEntryERC());
        fragmentEntryLink.setFragmentEntryScopeERC(fragmentEntryReference.getFragmentEntryScopeERC());
        fragmentEntryLink.setCss(GetterUtil.getString((String)fragmentInstance.getCss()));
        fragmentEntryLink.setHtml(GetterUtil.getString((String)fragmentInstance.getHtml()));
        fragmentEntryLink.setJs(GetterUtil.getString((String)fragmentInstance.getJs()));
        fragmentEntryLink.setConfiguration(GetterUtil.getString((String)fragmentInstance.getConfiguration()));
        fragmentEntryLink.setEditableValues(this._getEditableValues(fragmentInstance, layoutStructureItemImporterContext, pageElementDefinition));
        fragmentEntryLink.setNamespace(fragmentInstance.getNamespace());
        fragmentEntryLink.setRendererKey(fragmentEntryReference.getRendererKey());
        fragmentEntryLink.setType(this._getType(pageElementDefinition.getType()));
        fragmentEntryLink.setLastPropagationDate(fragmentInstance.getDatePropagated());
        fragmentEntryLink = FragmentEntryLinkLocalServiceUtil.updateFragmentEntryLink((FragmentEntryLink)fragmentEntryLink);
        FragmentEntryProcessorRegistry fragmentEntryProcessorRegistry = layoutStructureItemImporterContext.getFragmentEntryProcessorRegistry();
        return FragmentEntryLinkLocalServiceUtil.updateFragmentEntryLink((long)fragmentEntryLink.getUserId(), (long)fragmentEntryLink.getFragmentEntryLinkId(), (String)fragmentEntryProcessorRegistry.mergeDefaultEditableValues(fragmentEntryLink.getConfigurationJSONObject(), fragmentEntryLink.getEditableValuesJSONObject(), this._getProcessedHTML(fragmentEntryLink, fragmentEntryProcessorRegistry, ServiceContextThreadLocal.getServiceContext())), (boolean)false);
    }
}

