/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.resource.v1_0;

import com.liferay.batch.engine.thread.local.BatchEngineThreadLocal;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.vulcan.batch.engine.ExportImportVulcanBatchEngineTaskItemDelegate;
import com.liferay.headless.admin.site.dto.v1_0.NavigationMenu;
import com.liferay.headless.admin.site.dto.v1_0.NavigationMenuItem;
import com.liferay.headless.admin.site.internal.odata.entity.v1_0.NavigationMenuEntityModel;
import com.liferay.headless.admin.site.internal.resource.v1_0.BaseNavigationMenuResourceImpl;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.GroupUtil;
import com.liferay.headless.admin.site.resource.v1_0.NavigationMenuResource;
import com.liferay.headless.common.spi.service.context.ServiceContextBuilder;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.custom.field.CustomField;
import com.liferay.portal.vulcan.custom.field.CustomFieldsUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.SearchUtil;
import com.liferay.site.navigation.model.SiteNavigationMenu;
import com.liferay.site.navigation.model.SiteNavigationMenuItem;
import com.liferay.site.navigation.service.SiteNavigationMenuItemService;
import com.liferay.site.navigation.service.SiteNavigationMenuLocalService;
import com.liferay.site.navigation.service.SiteNavigationMenuService;
import com.liferay.site.navigation.type.SiteNavigationMenuItemType;
import com.liferay.site.navigation.type.SiteNavigationMenuItemTypeRegistry;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/navigation-menu.properties"}, property={"export.import.vulcan.batch.engine.task.item.delegate=true"}, scope=ServiceScope.PROTOTYPE, service={NavigationMenuResource.class})
public class NavigationMenuResourceImpl
extends BaseNavigationMenuResourceImpl
implements ExportImportVulcanBatchEngineTaskItemDelegate<NavigationMenu> {
    private static final EntityModel _entityModel = new NavigationMenuEntityModel();
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference(target="(component.name=com.liferay.headless.admin.site.internal.dto.v1_0.converter.NavigationMenuDTOConverter)")
    private DTOConverter<SiteNavigationMenu, NavigationMenu> _navigationMenuDTOConverter;
    @Reference
    private SiteNavigationMenuItemService _siteNavigationMenuItemService;
    @Reference
    private SiteNavigationMenuItemTypeRegistry _siteNavigationMenuItemTypeRegistry;
    @Reference
    private SiteNavigationMenuLocalService _siteNavigationMenuLocalService;
    @Reference
    private SiteNavigationMenuService _siteNavigationMenuService;

    @Override
    public void deleteSiteNavigationMenu(String siteExternalReferenceCode, String navigationMenuExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-66179")) {
            throw new UnsupportedOperationException();
        }
        this._siteNavigationMenuService.deleteSiteNavigationMenu(navigationMenuExternalReferenceCode, GroupUtil.getGroupId(true, this.contextCompany.getCompanyId(), siteExternalReferenceCode));
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return _entityModel;
    }

    public ExportImportVulcanBatchEngineTaskItemDelegate.ExportImportDescriptor getExportImportDescriptor() {
        return new ExportImportVulcanBatchEngineTaskItemDelegate.ExportImportDescriptor(){

            public String getLabelLanguageKey() {
                return "navigation-menus";
            }

            public String getModelClassName() {
                return SiteNavigationMenu.class.getName();
            }

            public String getPortletId() {
                return "com_liferay_site_navigation_admin_web_portlet_SiteNavigationAdminPortlet";
            }

            public String getResourceClassName() {
                return NavigationMenuResourceImpl.class.getName();
            }

            public ExportImportVulcanBatchEngineTaskItemDelegate.Scope getScope() {
                return ExportImportVulcanBatchEngineTaskItemDelegate.Scope.SITE;
            }

            public boolean isActive(PortletDataContext portletDataContext) {
                return FeatureFlagManagerUtil.isEnabled((long)portletDataContext.getCompanyId(), (String)"LPD-66179");
            }

            public boolean isStagingSupported() {
                return true;
            }
        };
    }

    @Override
    protected NavigationMenu doGetSiteNavigationMenu(String siteExternalReferenceCode, String navigationMenuExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-66179")) {
            throw new UnsupportedOperationException();
        }
        return this._toNavigationMenu(this._siteNavigationMenuService.getSiteNavigationMenuByExternalReferenceCode(navigationMenuExternalReferenceCode, GroupUtil.getGroupId(true, this.contextCompany.getCompanyId(), siteExternalReferenceCode)));
    }

    @Override
    protected Page<NavigationMenu> doGetSiteNavigationMenusPage(String siteExternalReferenceCode, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-66179")) {
            throw new UnsupportedOperationException();
        }
        long groupId = GroupUtil.getGroupId(true, this.contextCompany.getCompanyId(), siteExternalReferenceCode);
        return SearchUtil.search((Map)HashMapBuilder.put((Object)"create", this.addAction("ADD_SITE_NAVIGATION_MENU", "postSiteNavigationMenu", "com.liferay.site.navigation", groupId)).put((Object)"createBatch", this.addAction("ADD_SITE_NAVIGATION_MENU", "postSiteNavigationMenuBatch", "com.liferay.site.navigation", groupId)).build(), booleanQuery -> {}, (Filter)filter, (String)SiteNavigationMenu.class.getName(), (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
            searchContext.setGroupIds(new long[]{groupId});
        }, (Sort[])sorts, document -> this._toNavigationMenu(this._siteNavigationMenuService.fetchSiteNavigationMenu(GetterUtil.getLong((String)document.get("entryClassPK")))));
    }

    @Override
    protected NavigationMenu doPostSiteNavigationMenu(String siteExternalReferenceCode, NavigationMenu navigationMenu) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-66179")) {
            throw new UnsupportedOperationException();
        }
        return this._addNavigationMenu(navigationMenu.getExternalReferenceCode(), GroupUtil.getGroupId(true, this.contextCompany.getCompanyId(), siteExternalReferenceCode), navigationMenu);
    }

    @Override
    protected NavigationMenu doPutSiteNavigationMenu(String siteExternalReferenceCode, String navigationMenuExternalReferenceCode, NavigationMenu navigationMenu) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-66179")) {
            throw new UnsupportedOperationException();
        }
        long groupId = GroupUtil.getGroupId(true, this.contextCompany.getCompanyId(), siteExternalReferenceCode);
        SiteNavigationMenu siteNavigationMenu = this._siteNavigationMenuLocalService.fetchSiteNavigationMenuByExternalReferenceCode(navigationMenuExternalReferenceCode, groupId);
        if (siteNavigationMenu != null) {
            return this._updateNavigationMenu(navigationMenu, siteNavigationMenu);
        }
        return this._addNavigationMenu(navigationMenuExternalReferenceCode, groupId, navigationMenu);
    }

    @Override
    protected Long getPermissionCheckerResourceId(String groupExternalReferenceCode, String externalReferenceCode) throws Exception {
        SiteNavigationMenu siteNavigationMenu = this._siteNavigationMenuService.getSiteNavigationMenuByExternalReferenceCode(externalReferenceCode, this.getPermissionCheckerGroupId(groupExternalReferenceCode).longValue());
        return siteNavigationMenu.getPrimaryKey();
    }

    @Override
    protected String getPermissionCheckerResourceName(String groupExternalReferenceCode, String externalReferenceCode) {
        return SiteNavigationMenu.class.getName();
    }

    private NavigationMenu _addNavigationMenu(String externalReferenceCode, long groupId, NavigationMenu navigationMenu) throws Exception {
        SiteNavigationMenu siteNavigationMenu = this._siteNavigationMenuService.addSiteNavigationMenu(externalReferenceCode, groupId, navigationMenu.getName(), this._getNavigationMenuType(navigationMenu), this._isAuto(navigationMenu.getAuto()), ServiceContextBuilder.create((long)groupId, (HttpServletRequest)this.contextHttpServletRequest, null).build());
        this._createNavigationMenuItems(groupId, navigationMenu.getNavigationMenuItems(), 0L, siteNavigationMenu.getSiteNavigationMenuId());
        return this._toNavigationMenu(siteNavigationMenu);
    }

    private void _createNavigationMenuItem(long groupId, NavigationMenuItem navigationMenuItem, long parentNavigationMenuId, long siteNavigationMenuId) throws Exception {
        UnicodeProperties unicodeProperties = UnicodePropertiesBuilder.fastLoad((String)this._getTypeSettings(navigationMenuItem)).build();
        if (!this._hasModel(groupId, navigationMenuItem, unicodeProperties)) {
            throw new IllegalArgumentException("Unable to find navigation menu item with external reference code " + navigationMenuItem.getExternalReferenceCode());
        }
        SiteNavigationMenuItem siteNavigationMenuItem = this._siteNavigationMenuItemService.addSiteNavigationMenuItem(navigationMenuItem.getExternalReferenceCode(), groupId, siteNavigationMenuId, parentNavigationMenuId, navigationMenuItem.getType(), this._getTypeSettings(navigationMenuItem), ServiceContextBuilder.create((long)groupId, (HttpServletRequest)this.contextHttpServletRequest, null).expandoBridgeAttributes(CustomFieldsUtil.toMap((String)SiteNavigationMenuItem.class.getName(), (long)this.contextCompany.getCompanyId(), (CustomField[])navigationMenuItem.getCustomFields(), (Locale)this.contextAcceptLanguage.getPreferredLocale())).build());
        this._createNavigationMenuItems(groupId, navigationMenuItem.getNavigationMenuItems(), siteNavigationMenuItem.getSiteNavigationMenuItemId(), siteNavigationMenuId);
    }

    private void _createNavigationMenuItems(long groupId, NavigationMenuItem[] navigationMenuItems, long parentNavigationMenuId, long siteNavigationMenuId) throws Exception {
        if (navigationMenuItems == null) {
            return;
        }
        for (NavigationMenuItem navigationMenuItem : navigationMenuItems) {
            this._createNavigationMenuItem(groupId, navigationMenuItem, parentNavigationMenuId, siteNavigationMenuId);
        }
    }

    private void _deleteNavigationMenuItems(List<SiteNavigationMenuItem> siteNavigationMenuItems) throws Exception {
        for (SiteNavigationMenuItem siteNavigationMenuItem : siteNavigationMenuItems) {
            this._siteNavigationMenuItemService.deleteSiteNavigationMenuItem(siteNavigationMenuItem.getSiteNavigationMenuItemId(), true);
        }
    }

    private String _getLocalizedNamesFromI18nMap(NavigationMenuItem navigationMenuItem) {
        JSONObject localizedNamesJSONObject = this._jsonFactory.createJSONObject();
        Map nameI18n = navigationMenuItem.getName_i18n();
        if (nameI18n == null || nameI18n.isEmpty()) {
            localizedNamesJSONObject.put(navigationMenuItem.getDefaultLanguageId(), navigationMenuItem.getName());
            return localizedNamesJSONObject.toString();
        }
        for (Map.Entry entry : nameI18n.entrySet()) {
            localizedNamesJSONObject.put(String.valueOf(LocaleUtil.fromLanguageId((String)((String)entry.getKey()))), (String)entry.getValue());
        }
        return localizedNamesJSONObject.toString();
    }

    private Map<String, String> _getLocalizedPropertiesMapFromI18nMap(NavigationMenuItem navigationMenuItem) {
        HashMap<String, String> localizedPropertyMap = new HashMap<String, String>();
        Map nameI18n = navigationMenuItem.getName_i18n();
        if (nameI18n == null || nameI18n.isEmpty()) {
            localizedPropertyMap.put("name_" + navigationMenuItem.getDefaultLanguageId(), navigationMenuItem.getName());
            return localizedPropertyMap;
        }
        for (Map.Entry entry : nameI18n.entrySet()) {
            localizedPropertyMap.put("name_" + String.valueOf(LocaleUtil.fromLanguageId((String)((String)entry.getKey()))), (String)nameI18n.get(entry.getKey()));
        }
        return localizedPropertyMap;
    }

    private int _getNavigationMenuType(NavigationMenu navigationMenu) {
        int type = 0;
        NavigationMenu.NavigationType navigationType = navigationMenu.getNavigationType();
        if (navigationType != null) {
            type = navigationType.ordinal() + 1;
        }
        return type;
    }

    private String _getSettingProperty(Object settings, String key) {
        if (settings instanceof Map) {
            Map settingsMap = (Map)settings;
            return String.valueOf(settingsMap.get(key));
        }
        return null;
    }

    private String _getTypeSettings(NavigationMenuItem navigationMenuItem) {
        UnicodeProperties unicodeProperties = UnicodePropertiesBuilder.create((boolean)true).put("defaultLanguageId", navigationMenuItem.getDefaultLanguageId()).put("displayIcon", navigationMenuItem.getDisplayIcon()).put("useCustomName", () -> {
            if (navigationMenuItem.getUseCustomName() != null) {
                return String.valueOf(navigationMenuItem.getUseCustomName());
            }
            return null;
        }).build();
        String localizedNames = this._getLocalizedNamesFromI18nMap(navigationMenuItem);
        Map<String, String> localizedPropertyMap = this._getLocalizedPropertiesMapFromI18nMap(navigationMenuItem);
        Object navigationMenuItemSettings = navigationMenuItem.getNavigationMenuItemSettings();
        String type = navigationMenuItem.getType();
        if (Objects.equals(type, "asset_vocabulary")) {
            String title;
            String showAssetVocabularyLevel;
            String externalReferenceCode;
            String className = this._getSettingProperty(navigationMenuItemSettings, "className");
            if (className != null) {
                unicodeProperties.put("className", className);
            }
            if ((externalReferenceCode = this._getSettingProperty(navigationMenuItemSettings, "externalReferenceCode")) != null) {
                unicodeProperties.put("externalReferenceCode", externalReferenceCode);
            }
            unicodeProperties.put("localizedNames", localizedNames);
            String scopeExternalReferenceCode = this._getSettingProperty(navigationMenuItemSettings, "scopeExternalReferenceCode");
            if (scopeExternalReferenceCode != null) {
                unicodeProperties.put("scopeExternalReferenceCode", scopeExternalReferenceCode);
            }
            if ((showAssetVocabularyLevel = this._getSettingProperty(navigationMenuItemSettings, "showAssetVocabularyLevel")) != null) {
                unicodeProperties.put("showAssetVocabularyLevel", showAssetVocabularyLevel);
            }
            if ((title = this._getSettingProperty(navigationMenuItemSettings, "title")) != null) {
                unicodeProperties.put("title", title);
            }
            if (this._getSettingProperty(navigationMenuItemSettings, "type") != null) {
                unicodeProperties.put("type", this._getSettingProperty(navigationMenuItemSettings, "type"));
            }
        } else if (Objects.equals(type, "layout")) {
            String privatePage;
            String externalReferenceCode = this._getSettingProperty(navigationMenuItemSettings, "externalReferenceCode");
            if (externalReferenceCode != null) {
                unicodeProperties.put("externalReferenceCode", externalReferenceCode);
            }
            if ((privatePage = this._getSettingProperty(navigationMenuItemSettings, "privatePage")) != null) {
                unicodeProperties.put("privateLayout", privatePage);
            }
            unicodeProperties.putAll(localizedPropertyMap);
        } else if (Objects.equals(type, "node")) {
            unicodeProperties.putAll(localizedPropertyMap);
        } else if (Objects.equals(type, "url")) {
            if (this._getSettingProperty(navigationMenuItemSettings, "url") != null) {
                unicodeProperties.put("url", this._getSettingProperty(navigationMenuItemSettings, "url"));
            }
            if (this._getSettingProperty(navigationMenuItemSettings, "useNewTab") != null) {
                unicodeProperties.put("useNewTab", String.valueOf(this._getSettingProperty(navigationMenuItemSettings, "useNewTab")));
            }
            unicodeProperties.putAll(localizedPropertyMap);
        } else {
            SiteNavigationMenuItemType siteNavigationMenuItemType = this._siteNavigationMenuItemTypeRegistry.getSiteNavigationMenuItemType(type);
            Class clazz = siteNavigationMenuItemType.getClass();
            if (Objects.equals(clazz.getName(), "com.liferay.site.navigation.menu.item.display.page.internal.type.DisplayPageTypeSiteNavigationMenuItemType")) {
                String externalReferenceCode;
                String className = this._getSettingProperty(navigationMenuItemSettings, "className");
                if (className != null) {
                    unicodeProperties.put("className", className);
                }
                if ((externalReferenceCode = this._getSettingProperty(navigationMenuItemSettings, "externalReferenceCode")) != null) {
                    unicodeProperties.put("externalReferenceCode", externalReferenceCode);
                }
                unicodeProperties.put("localizedNames", localizedNames);
                String scopeExternalReferenceCode = this._getSettingProperty(navigationMenuItemSettings, "scopeExternalReferenceCode");
                if (scopeExternalReferenceCode != null) {
                    unicodeProperties.put("scopeExternalReferenceCode", scopeExternalReferenceCode);
                }
                if (this._getSettingProperty(navigationMenuItemSettings, "title") != null) {
                    unicodeProperties.put("title", this._getSettingProperty(navigationMenuItemSettings, "title"));
                }
                if (this._getSettingProperty(navigationMenuItemSettings, "type") != null) {
                    unicodeProperties.put("type", this._getSettingProperty(navigationMenuItemSettings, "type"));
                }
            }
        }
        return unicodeProperties.toString();
    }

    private boolean _hasModel(long groupId, NavigationMenuItem navigationMenuItem, UnicodeProperties unicodeProperties) throws Exception {
        if (BatchEngineThreadLocal.isBatchImportInProcess()) {
            return true;
        }
        String navigationMenuItemType = navigationMenuItem.getType();
        SiteNavigationMenuItemType siteNavigationMenuItemType = this._siteNavigationMenuItemTypeRegistry.getSiteNavigationMenuItemType(navigationMenuItemType);
        return siteNavigationMenuItemType.hasModel(this.contextCompany.getCompanyId(), groupId, unicodeProperties);
    }

    private boolean _isAuto(Boolean auto) {
        if (auto == null) {
            return true;
        }
        return auto;
    }

    private NavigationMenu _toNavigationMenu(SiteNavigationMenu siteNavigationMenu) throws Exception {
        return (NavigationMenu)this._navigationMenuDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), (Map)HashMapBuilder.put((Object)"delete", this.addAction("DELETE", (GroupedModel)siteNavigationMenu, "deleteSiteNavigationMenu")).put((Object)"replace", this.addAction("UPDATE", (GroupedModel)siteNavigationMenu, "putSiteNavigationMenu")).build(), this._dtoConverterRegistry, this.contextHttpServletRequest, (Object)siteNavigationMenu.getSiteNavigationMenuId(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser), (Object)siteNavigationMenu);
    }

    private NavigationMenu _updateNavigationMenu(NavigationMenu navigationMenu, SiteNavigationMenu siteNavigationMenu) throws Exception {
        this._updateNavigationMenuItems(siteNavigationMenu.getGroupId(), navigationMenu.getNavigationMenuItems(), 0L, siteNavigationMenu.getSiteNavigationMenuId());
        ServiceContext serviceContext = ServiceContextBuilder.create((long)siteNavigationMenu.getGroupId(), (HttpServletRequest)this.contextHttpServletRequest, null).build();
        this._siteNavigationMenuService.updateSiteNavigationMenu(siteNavigationMenu.getSiteNavigationMenuId(), this._getNavigationMenuType(navigationMenu), this._isAuto(navigationMenu.getAuto()), serviceContext);
        return this._toNavigationMenu(this._siteNavigationMenuService.updateSiteNavigationMenu(siteNavigationMenu.getSiteNavigationMenuId(), navigationMenu.getName(), serviceContext));
    }

    private void _updateNavigationMenuItems(long groupId, NavigationMenuItem[] navigationMenuItems, long parentSiteNavigationMenuItemId, long siteNavigationMenuId) throws Exception {
        ArrayList<SiteNavigationMenuItem> siteNavigationMenuItems = new ArrayList<SiteNavigationMenuItem>(this._siteNavigationMenuItemService.getSiteNavigationMenuItems(siteNavigationMenuId, parentSiteNavigationMenuItemId));
        if (navigationMenuItems == null) {
            this._deleteNavigationMenuItems(siteNavigationMenuItems);
            return;
        }
        for (NavigationMenuItem navigationMenuItem : navigationMenuItems) {
            String navigationMenuItemExternalReferenceCode = navigationMenuItem.getExternalReferenceCode();
            SiteNavigationMenuItem siteNavigationMenuItem = null;
            for (SiteNavigationMenuItem curSiteNavigationMenuItem : siteNavigationMenuItems) {
                if (!Objects.equals(navigationMenuItemExternalReferenceCode, curSiteNavigationMenuItem.getExternalReferenceCode())) continue;
                siteNavigationMenuItem = curSiteNavigationMenuItem;
                break;
            }
            if (siteNavigationMenuItem != null) {
                UnicodeProperties unicodeProperties = UnicodePropertiesBuilder.fastLoad((String)this._getTypeSettings(navigationMenuItem)).build();
                if (!this._hasModel(groupId, navigationMenuItem, unicodeProperties)) {
                    throw new IllegalArgumentException("Unable to find navigation menu item with external reference code " + navigationMenuItemExternalReferenceCode);
                }
                SiteNavigationMenuItem updatedSiteNavigationMenuItem = this._siteNavigationMenuItemService.updateSiteNavigationMenuItem(siteNavigationMenuItem.getSiteNavigationMenuItemId(), this._getTypeSettings(navigationMenuItem), ServiceContextBuilder.create((long)groupId, (HttpServletRequest)this.contextHttpServletRequest, null).expandoBridgeAttributes(CustomFieldsUtil.toMap((String)SiteNavigationMenuItem.class.getName(), (long)this.contextCompany.getCompanyId(), (CustomField[])navigationMenuItem.getCustomFields(), (Locale)this.contextAcceptLanguage.getPreferredLocale())).build());
                this._updateNavigationMenuItems(groupId, navigationMenuItem.getNavigationMenuItems(), updatedSiteNavigationMenuItem.getSiteNavigationMenuItemId(), siteNavigationMenuId);
                siteNavigationMenuItems.remove(siteNavigationMenuItem);
                continue;
            }
            this._createNavigationMenuItem(groupId, navigationMenuItem, parentSiteNavigationMenuItemId, siteNavigationMenuId);
        }
        this._deleteNavigationMenuItems(siteNavigationMenuItems);
    }
}

