/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.dto.v1_0.util;

import com.liferay.headless.admin.site.dto.v1_0.WidgetInstance;
import com.liferay.headless.admin.site.dto.v1_0.WidgetPermission;
import com.liferay.layout.exporter.PortletPermissionsExporter;
import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.MapUtil;
import jakarta.portlet.PortletPreferences;
import java.util.Map;
import java.util.TreeMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;

public class WidgetInstanceUtil {
    private static final ServiceTracker<PortletPermissionsExporter, PortletPermissionsExporter> _portletPermissionsExporterServiceTracker = ServiceTrackerFactory.open((Bundle)FrameworkUtil.getBundle(WidgetInstanceUtil.class), PortletPermissionsExporter.class);

    public static WidgetInstance getWidgetInstance(final String instanceId, final long plid, final String portletId) {
        return new WidgetInstance(){
            {
                this.setWidgetConfig(() -> WidgetInstanceUtil._getWidgetConfig(plid, portletId));
                this.setWidgetInstanceId(() -> instanceId);
                this.setWidgetName(() -> PortletIdCodec.decodePortletName((String)portletId));
                this.setWidgetPermissions(() -> WidgetInstanceUtil._getWidgetPermissions(plid, portletId));
            }
        };
    }

    private static Map<String, Object> _getWidgetConfig(long plid, String portletId) {
        Layout layout = LayoutLocalServiceUtil.fetchLayout((long)plid);
        if (layout == null) {
            return null;
        }
        Portlet portlet = PortletLocalServiceUtil.getPortletById((String)PortletIdCodec.decodePortletName((String)portletId));
        if (portlet == null) {
            return null;
        }
        PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup((long)layout.getCompanyId(), (long)0L, (int)3, (long)layout.getPlid(), (String)portletId, (String)portlet.getDefaultPreferences());
        if (portletPreferences == null) {
            return null;
        }
        TreeMap<String, Object> portletConfigurationMap = new TreeMap<String, Object>();
        Map portletPreferencesMap = portletPreferences.getMap();
        for (Map.Entry entrySet : portletPreferencesMap.entrySet()) {
            String[] values = (String[])entrySet.getValue();
            if (values == null) {
                portletConfigurationMap.put((String)entrySet.getKey(), "");
                continue;
            }
            if (values.length == 1) {
                portletConfigurationMap.put((String)entrySet.getKey(), values[0]);
                continue;
            }
            portletConfigurationMap.put((String)entrySet.getKey(), values);
        }
        return portletConfigurationMap;
    }

    private static WidgetPermission[] _getWidgetPermissions(long plid, String portletId) {
        PortletPermissionsExporter portletPermissionsExporter = (PortletPermissionsExporter)_portletPermissionsExporterServiceTracker.getService();
        if (portletPermissionsExporter == null) {
            return null;
        }
        Map portletPermissions = portletPermissionsExporter.getPortletPermissions(plid, portletId);
        if (MapUtil.isEmpty((Map)portletPermissions)) {
            return new WidgetPermission[0];
        }
        return (WidgetPermission[])TransformUtil.transformToArray(portletPermissions.entrySet(), entry -> {
            if (ArrayUtil.isEmpty((Object[])((Object[])entry.getValue()))) {
                return null;
            }
            return new WidgetPermission((Map.Entry)entry){
                final /* synthetic */ Map.Entry val$entry;
                {
                    this.val$entry = entry;
                    this.setActionIds(this.val$entry::getValue);
                    this.setRoleName(this.val$entry::getKey);
                }
            };
        }, WidgetPermission.class);
    }
}

