/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.dto.v1_0.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.util.ScopeUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.scope.Scope;

public class ItemScopeUtil {
    public static Long getItemGroupId(long companyId, Scope scope, long scopeGroupId) {
        return ScopeUtil.getItemGroupId((long)companyId, (String)ItemScopeUtil._getScopeExternalReferenceCode(scope), (long)scopeGroupId);
    }

    public static Scope getItemScope(long itemScopeGroupId, long scopeGroupId) throws Exception {
        if (scopeGroupId == itemScopeGroupId) {
            return null;
        }
        Group group = GroupLocalServiceUtil.getGroup((long)itemScopeGroupId);
        Scope.Type type = group.getType() == 5 ? Scope.Type.ASSET_LIBRARY : Scope.Type.SITE;
        return Scope.ofReference((String)group.getExternalReferenceCode(), (Scope.Type)type);
    }

    public static Scope getItemScope(long companyId, String itemGroupExternalReferenceCode, long scopeGroupId) {
        if (Validator.isNull((String)itemGroupExternalReferenceCode)) {
            return null;
        }
        Group group = GroupLocalServiceUtil.fetchGroupByExternalReferenceCode((String)itemGroupExternalReferenceCode, (long)companyId);
        if (group == null) {
            return Scope.ofReference((String)itemGroupExternalReferenceCode, (Scope.Type)Scope.Type.SITE);
        }
        if (group.getGroupId() == scopeGroupId) {
            return null;
        }
        Scope.Type type = group.getType() == 5 ? Scope.Type.ASSET_LIBRARY : Scope.Type.SITE;
        return Scope.ofReference((String)group.getExternalReferenceCode(), (Scope.Type)type);
    }

    public static String getItemScopeExternalReferenceCode(Scope itemScope, long scopeGroupId) throws PortalException {
        return ScopeUtil.getItemScopeExternalReferenceCode((String)ItemScopeUtil._getScopeExternalReferenceCode(itemScope), (long)scopeGroupId);
    }

    private static String _getScopeExternalReferenceCode(Scope scope) {
        if (scope == null) {
            return null;
        }
        return scope.getExternalReferenceCode();
    }
}

