/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.dto.v1_0.util;

import com.liferay.headless.admin.site.dto.v1_0.FragmentMappedValue;
import com.liferay.headless.admin.site.dto.v1_0.FragmentMappedValueItemContextReference;
import com.liferay.headless.admin.site.dto.v1_0.FragmentMappedValueItemExternalReference;
import com.liferay.headless.admin.site.dto.v1_0.FragmentMappedValueItemReference;
import com.liferay.headless.admin.site.dto.v1_0.Mapping;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.InfoItemUtil;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.ItemScopeUtil;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.LayoutUtil;
import com.liferay.info.item.ERCInfoItemIdentifier;
import com.liferay.info.item.InfoItemServiceRegistry;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.scope.Scope;
import java.util.Objects;

public class FragmentMappingUtil {
    private static final Log _log = LogFactoryUtil.getLog(FragmentMappingUtil.class);

    public static String getFieldKey(JSONObject jsonObject) {
        String collectionFieldId = jsonObject.getString("collectionFieldId");
        if (Validator.isNotNull((String)collectionFieldId)) {
            return collectionFieldId;
        }
        String fieldId = jsonObject.getString("fieldId");
        if (Validator.isNotNull((String)fieldId)) {
            return fieldId;
        }
        String mappedField = jsonObject.getString("mappedField");
        if (Validator.isNotNull((String)mappedField)) {
            return mappedField;
        }
        return null;
    }

    public static FragmentMappedValueItemReference getFragmentMappedValueItemReference(long companyId, InfoItemServiceRegistry infoItemServiceRegistry, JSONObject jsonObject, long scopeGroupId) throws Exception {
        if (!jsonObject.has("collectionFieldId") && !jsonObject.has("mappedField")) {
            return FragmentMappingUtil._getFragmentMappedValueItemExternalReference(companyId, infoItemServiceRegistry, jsonObject, scopeGroupId);
        }
        FragmentMappedValueItemContextReference fragmentMappedValueItemContextReference = new FragmentMappedValueItemContextReference();
        FragmentMappedValueItemContextReference.ContextSource contextSource = jsonObject.has("collectionFieldId") ? FragmentMappedValueItemContextReference.ContextSource.COLLECTION_ITEM : FragmentMappedValueItemContextReference.ContextSource.DISPLAY_PAGE_ITEM;
        fragmentMappedValueItemContextReference.setContextSource(() -> contextSource);
        fragmentMappedValueItemContextReference.setType(() -> FragmentMappedValueItemReference.Type.CONTEXT_REFERENCE);
        return fragmentMappedValueItemContextReference;
    }

    public static JSONObject getFragmentMappedValueJSONObject(long companyId, InfoItemServiceRegistry infoItemServiceRegistry, Mapping mapping, long scopeGroupId) throws PortalException {
        if (mapping == null) {
            return null;
        }
        FragmentMappedValueItemReference fragmentMappedValueItemReference = mapping.getItemReference();
        if (fragmentMappedValueItemReference == null) {
            return null;
        }
        String fieldKey = mapping.getFieldKey();
        if (fragmentMappedValueItemReference instanceof FragmentMappedValueItemContextReference) {
            if (Validator.isNull((String)fieldKey)) {
                return null;
            }
            FragmentMappedValueItemContextReference fragmentMappedValueItemContextReference = (FragmentMappedValueItemContextReference)fragmentMappedValueItemReference;
            FragmentMappedValueItemContextReference.ContextSource contextSource = fragmentMappedValueItemContextReference.getContextSource();
            if (contextSource == FragmentMappedValueItemContextReference.ContextSource.COLLECTION_ITEM) {
                return JSONUtil.put((String)"collectionFieldId", (Object)fieldKey);
            }
            if (contextSource == FragmentMappedValueItemContextReference.ContextSource.DISPLAY_PAGE_ITEM) {
                return JSONUtil.put((String)"mappedField", (Object)fieldKey);
            }
            return null;
        }
        if (!(fragmentMappedValueItemReference instanceof FragmentMappedValueItemExternalReference)) {
            return null;
        }
        FragmentMappedValueItemExternalReference fragmentMappedValueItemExternalReference = (FragmentMappedValueItemExternalReference)fragmentMappedValueItemReference;
        String className = fragmentMappedValueItemExternalReference.getClassName();
        if (Validator.isNull((String)className) || Validator.isNull((String)fragmentMappedValueItemExternalReference.getExternalReferenceCode())) {
            return null;
        }
        if (Objects.equals(className, Layout.class.getName())) {
            return JSONUtil.put((String)"layout", (Object)LayoutUtil.getMappedLayoutJSONObject(companyId, fragmentMappedValueItemExternalReference.getExternalReferenceCode(), fragmentMappedValueItemExternalReference.getScope(), scopeGroupId));
        }
        return InfoItemUtil.getMappedItemJSONObject(fragmentMappedValueItemExternalReference.getClassName(), fragmentMappedValueItemExternalReference.getExternalReferenceCode(), fieldKey, infoItemServiceRegistry, fragmentMappedValueItemExternalReference.getScope(), scopeGroupId);
    }

    public static boolean isMappedValue(JSONObject jsonObject) {
        if (jsonObject == null) {
            return false;
        }
        if (jsonObject.has("classNameId") && jsonObject.has("classPK") || jsonObject.has("externalReferenceCode") && jsonObject.has("fieldId")) {
            return true;
        }
        return jsonObject.has("collectionFieldId") || jsonObject.has("layout") || jsonObject.has("mappedField");
    }

    public static FragmentMappedValue toFragmentMappedValue(long companyId, InfoItemServiceRegistry infoItemServiceRegistry, final JSONObject jsonObject, long scopeGroupId) throws Exception {
        final FragmentMappedValueItemReference fragmentMappedValueItemReference = FragmentMappingUtil.getFragmentMappedValueItemReference(companyId, infoItemServiceRegistry, jsonObject, scopeGroupId);
        if (fragmentMappedValueItemReference == null) {
            return null;
        }
        FragmentMappedValue fragmentMappedValue = new FragmentMappedValue();
        fragmentMappedValue.setMapping(() -> new Mapping(){
            {
                this.setFieldKey(() -> FragmentMappingUtil.getFieldKey(jsonObject));
                this.setItemReference(() -> fragmentMappedValueItemReference);
            }
        });
        return fragmentMappedValue;
    }

    private static FragmentMappedValueItemExternalReference _getFragmentMappedValueItemExternalReference(long companyId, InfoItemServiceRegistry infoItemServiceRegistry, JSONObject jsonObject, long scopeGroupId) throws Exception {
        ERCInfoItemIdentifier ercInfoItemIdentifier;
        String fieldId = jsonObject.getString("fieldId");
        JSONObject layoutJSONObject = jsonObject.getJSONObject("layout");
        if (Validator.isNull((String)fieldId) && layoutJSONObject == null) {
            return null;
        }
        if (layoutJSONObject != null) {
            return FragmentMappingUtil._toLayoutFragmentMappedValueItemExternalReference(companyId, layoutJSONObject, scopeGroupId);
        }
        String className = FragmentMappingUtil._toItemClassName(jsonObject);
        if (className == null) {
            return null;
        }
        FragmentMappedValueItemExternalReference fragmentMappedValueItemExternalReference = new FragmentMappedValueItemExternalReference();
        fragmentMappedValueItemExternalReference.setClassName(() -> className);
        fragmentMappedValueItemExternalReference.setType(() -> FragmentMappedValueItemReference.Type.ITEM_EXTERNAL_REFERENCE);
        if (jsonObject.has("classPK") && (ercInfoItemIdentifier = InfoItemUtil.getERCInfoItemIdentifier(className, jsonObject.getLong("classPK"), infoItemServiceRegistry, scopeGroupId)) != null) {
            fragmentMappedValueItemExternalReference.setExternalReferenceCode(() -> ((ERCInfoItemIdentifier)ercInfoItemIdentifier).getExternalReferenceCode());
            fragmentMappedValueItemExternalReference.setScope(() -> ItemScopeUtil.getItemScope(companyId, ercInfoItemIdentifier.getScopeExternalReferenceCode(), scopeGroupId));
            return fragmentMappedValueItemExternalReference;
        }
        String externalReferenceCode = jsonObject.getString("externalReferenceCode");
        if (Validator.isNull((String)externalReferenceCode)) {
            return null;
        }
        fragmentMappedValueItemExternalReference.setExternalReferenceCode(() -> externalReferenceCode);
        fragmentMappedValueItemExternalReference.setScope(() -> ItemScopeUtil.getItemScope(companyId, jsonObject.getString("scopeExternalReferenceCode"), scopeGroupId));
        return fragmentMappedValueItemExternalReference;
    }

    private static String _getLayoutExternalReferenceCode(Layout layout, JSONObject layoutJSONObject) {
        if (layout != null) {
            return layout.getExternalReferenceCode();
        }
        return layoutJSONObject.getString("externalReferenceCode");
    }

    private static Scope _getLayoutScope(long companyId, Layout layout, JSONObject layoutJSONObject, long scopeGroupId) throws Exception {
        if (layout != null) {
            return ItemScopeUtil.getItemScope(layout.getGroupId(), scopeGroupId);
        }
        return ItemScopeUtil.getItemScope(companyId, layoutJSONObject.getString("scopeExternalReferenceCode"), scopeGroupId);
    }

    private static String _toItemClassName(JSONObject jsonObject) {
        String classNameIdString = jsonObject.getString("classNameId");
        if (Validator.isNull((String)classNameIdString)) {
            return null;
        }
        long classNameId = 0L;
        try {
            classNameId = Long.parseLong(classNameIdString);
        }
        catch (NumberFormatException numberFormatException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)String.format("Item class name could not be set since class name ID %s could not be parsed to a long", classNameIdString), (Throwable)numberFormatException);
            }
            return null;
        }
        String className = null;
        try {
            className = PortalUtil.getClassName((long)classNameId);
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Item class name could not be set since no class name could be obtained for class name ID " + classNameId), (Throwable)exception);
            }
            return null;
        }
        return className;
    }

    private static FragmentMappedValueItemExternalReference _toLayoutFragmentMappedValueItemExternalReference(long companyId, JSONObject layoutJSONObject, long scopeGroupId) throws Exception {
        Layout layout = LayoutLocalServiceUtil.fetchLayout((long)layoutJSONObject.getLong("groupId"), (boolean)layoutJSONObject.getBoolean("privateLayout"), (long)layoutJSONObject.getLong("layoutId"));
        String externalReferenceCode = FragmentMappingUtil._getLayoutExternalReferenceCode(layout, layoutJSONObject);
        if (Validator.isNull((String)externalReferenceCode)) {
            return null;
        }
        FragmentMappedValueItemExternalReference fragmentMappedValueItemExternalReference = new FragmentMappedValueItemExternalReference();
        fragmentMappedValueItemExternalReference.setClassName(Layout.class::getName);
        fragmentMappedValueItemExternalReference.setExternalReferenceCode(() -> externalReferenceCode);
        fragmentMappedValueItemExternalReference.setScope(() -> FragmentMappingUtil._getLayoutScope(companyId, layout, layoutJSONObject, scopeGroupId));
        fragmentMappedValueItemExternalReference.setType(() -> FragmentMappedValueItemReference.Type.ITEM_EXTERNAL_REFERENCE);
        return fragmentMappedValueItemExternalReference;
    }
}

