/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.dto.v1_0.converter;

import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.headless.admin.site.dto.v1_0.PageElementDefinition;
import com.liferay.headless.admin.site.dto.v1_0.WidgetInstance;
import com.liferay.headless.admin.site.dto.v1_0.WidgetInstancePageElementDefinition;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.FragmentViewportUtil;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.WidgetInstanceUtil;
import com.liferay.layout.util.structure.FragmentStyledLayoutStructureItem;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.util.Collection;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.layout.util.structure.FragmentStyledLayoutStructureItem"}, service={DTOConverter.class})
public class WidgetInstancePageElementDefinitionDTOConverter
implements DTOConverter<FragmentStyledLayoutStructureItem, WidgetInstancePageElementDefinition> {
    @Reference
    private FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;

    public String getContentType() {
        return WidgetInstancePageElementDefinition.class.getSimpleName();
    }

    public WidgetInstancePageElementDefinition toDTO(DTOConverterContext dtoConverterContext, FragmentStyledLayoutStructureItem fragmentStyledLayoutStructureItem) throws Exception {
        FragmentEntryLink fragmentEntryLink = this._fragmentEntryLinkLocalService.fetchFragmentEntryLink(fragmentStyledLayoutStructureItem.getFragmentEntryLinkId());
        if (fragmentEntryLink == null) {
            throw new UnsupportedOperationException();
        }
        WidgetInstancePageElementDefinition widgetInstancePageElementDefinition = new WidgetInstancePageElementDefinition();
        widgetInstancePageElementDefinition.setCssClasses(() -> {
            Set cssClasses = fragmentStyledLayoutStructureItem.getCssClasses();
            if (SetUtil.isEmpty((Set)cssClasses)) {
                return null;
            }
            return ArrayUtil.toStringArray((Collection)cssClasses);
        });
        widgetInstancePageElementDefinition.setDraftWidgetInstanceExternalReferenceCode(() -> {
            FragmentEntryLink originalFragmentEntryLink = this._fragmentEntryLinkLocalService.fetchFragmentEntryLinkByExternalReferenceCode(fragmentEntryLink.getOriginalFragmentEntryLinkERC(), fragmentEntryLink.getGroupId());
            if (originalFragmentEntryLink == null) {
                return null;
            }
            return originalFragmentEntryLink.getExternalReferenceCode();
        });
        widgetInstancePageElementDefinition.setFragmentViewports(() -> FragmentViewportUtil.toFragmentViewports(fragmentStyledLayoutStructureItem.getItemConfigJSONObject()));
        widgetInstancePageElementDefinition.setIndexed(() -> ((FragmentStyledLayoutStructureItem)fragmentStyledLayoutStructureItem).isIndexed());
        widgetInstancePageElementDefinition.setName(() -> ((FragmentStyledLayoutStructureItem)fragmentStyledLayoutStructureItem).getName());
        widgetInstancePageElementDefinition.setType(() -> PageElementDefinition.Type.WIDGET);
        widgetInstancePageElementDefinition.setWidgetInstance(() -> this._getWidgetInstance(fragmentEntryLink));
        widgetInstancePageElementDefinition.setWidgetInstanceExternalReferenceCode(() -> ((FragmentEntryLink)fragmentEntryLink).getExternalReferenceCode());
        return widgetInstancePageElementDefinition;
    }

    private WidgetInstance _getWidgetInstance(FragmentEntryLink fragmentEntryLink) {
        JSONObject jsonObject = fragmentEntryLink.getEditableValuesJSONObject();
        if (JSONUtil.isEmpty((JSONObject)jsonObject) || !jsonObject.has("portletId")) {
            return null;
        }
        String instanceId = jsonObject.getString("instanceId", null);
        String portletId = PortletIdCodec.encode((String)jsonObject.getString("portletId"), (String)instanceId);
        return WidgetInstanceUtil.getWidgetInstance(instanceId, fragmentEntryLink.getPlid(), portletId);
    }
}

