/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.dto.v1_0.converter;

import com.liferay.headless.admin.site.dto.v1_0.ItemExternalReference;
import com.liferay.headless.admin.site.dto.v1_0.PageElement;
import com.liferay.headless.admin.site.dto.v1_0.PageExperience;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.ItemScopeUtil;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructureRel;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import com.liferay.segments.model.SegmentsEntry;
import com.liferay.segments.model.SegmentsExperience;
import com.liferay.segments.service.SegmentsEntryLocalService;
import com.liferay.segments.service.SegmentsExperienceLocalService;
import java.util.Collection;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=import com.liferay.layout.page.template.model.LayoutPageTemplateStructureRel"}, service={DTOConverter.class})
public class PageExperienceDTOConverter
implements DTOConverter<LayoutPageTemplateStructureRel, PageExperience> {
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference(target="(component.name=com.liferay.headless.admin.site.internal.dto.v1_0.converter.PageElementDTOConverter)")
    private DTOConverter<LayoutStructureItem, PageElement> _pageElementDTOConverter;
    @Reference
    private SegmentsEntryLocalService _segmentsEntryLocalService;
    @Reference
    private SegmentsExperienceLocalService _segmentsExperienceLocalService;

    public String getContentType() {
        return PageExperience.class.getSimpleName();
    }

    public PageExperience toDTO(DTOConverterContext dtoConverterContext, final LayoutPageTemplateStructureRel layoutPageTemplateStructureRel) throws Exception {
        final SegmentsExperience segmentsExperience = this._segmentsExperienceLocalService.fetchSegmentsExperience(layoutPageTemplateStructureRel.getSegmentsExperienceId());
        final Layout layout = this._layoutLocalService.getLayout(segmentsExperience.getPlid());
        return new PageExperience(){
            {
                this.setExternalReferenceCode(() -> ((SegmentsExperience)segmentsExperience).getExternalReferenceCode());
                this.setKey(() -> ((SegmentsExperience)segmentsExperience).getSegmentsExperienceKey());
                this.setName_i18n(() -> LocalizedMapUtil.getI18nMap((boolean)true, (Map)segmentsExperience.getNameMap()));
                this.setPageElements(() -> PageExperienceDTOConverter.this._getPageElements(layoutPageTemplateStructureRel));
                this.setPageSpecificationExternalReferenceCode(() -> ((Layout)layout).getExternalReferenceCode());
                this.setPriority(() -> ((SegmentsExperience)segmentsExperience).getPriority());
                this.setSegmentItemExternalReference(() -> {
                    if (segmentsExperience.getSegmentsEntryId() == 0L) {
                        return null;
                    }
                    final SegmentsEntry segmentsEntry = PageExperienceDTOConverter.this._segmentsEntryLocalService.fetchSegmentsEntry(segmentsExperience.getSegmentsEntryId());
                    if (segmentsEntry == null) {
                        throw new UnsupportedOperationException();
                    }
                    return new ItemExternalReference(){
                        {
                            this.setClassName(SegmentsEntry.class::getName);
                            this.setExternalReferenceCode(() -> ((SegmentsEntry)segmentsEntry).getExternalReferenceCode());
                            this.setScope(() -> ItemScopeUtil.getItemScope(segmentsEntry.getGroupId(), layout.getGroupId()));
                        }
                    };
                });
            }
        };
    }

    private DTOConverterContext _getDTOConverterContext(long companyId, LayoutStructure layoutStructure, long scopeGroupId) {
        DefaultDTOConverterContext dtoConverterContext = new DefaultDTOConverterContext(null, null, null, null, null);
        dtoConverterContext.setAttribute(LayoutStructure.class.getName(), (Object)layoutStructure);
        dtoConverterContext.setAttribute("companyId", (Object)companyId);
        dtoConverterContext.setAttribute("scopeGroupId", (Object)scopeGroupId);
        return dtoConverterContext;
    }

    private PageElement[] _getPageElements(LayoutPageTemplateStructureRel layoutPageTemplateStructureRel) {
        LayoutStructure layoutStructure = LayoutStructure.of((String)layoutPageTemplateStructureRel.getData());
        LayoutStructureItem rootLayoutStructureItem = layoutStructure.getMainLayoutStructureItem();
        return (PageElement[])TransformUtil.transformToArray((Collection)rootLayoutStructureItem.getChildrenItemIds(), childrenItemId -> (PageElement)this._pageElementDTOConverter.toDTO(this._getDTOConverterContext(layoutPageTemplateStructureRel.getCompanyId(), layoutStructure, layoutPageTemplateStructureRel.getGroupId()), (Object)layoutStructure.getLayoutStructureItem(childrenItemId)), PageElement.class);
    }
}

