/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.dto.v1_0.converter;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.headless.admin.site.dto.v1_0.DisplayPageNavigationMenuItemSettings;
import com.liferay.headless.admin.site.dto.v1_0.NavigationMenuItem;
import com.liferay.headless.admin.site.dto.v1_0.PageNavigationMenuItemSettings;
import com.liferay.headless.admin.site.dto.v1_0.URLNavigationMenuItemSettings;
import com.liferay.headless.admin.site.dto.v1_0.VocabularyNavigationMenuItemSettings;
import com.liferay.headless.admin.user.dto.v1_0.Creator;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.vulcan.custom.field.CustomFieldsUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import com.liferay.site.navigation.model.SiteNavigationMenuItem;
import com.liferay.site.navigation.type.SiteNavigationMenuItemType;
import com.liferay.site.navigation.type.SiteNavigationMenuItemTypeRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DTOConverter.class})
public class NavigationMenuItemDTOConverter
implements DTOConverter<SiteNavigationMenuItem, NavigationMenuItem> {
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private SiteNavigationMenuItemTypeRegistry _siteNavigationMenuItemTypeRegistry;
    @Reference
    private UserLocalService _userLocalService;

    public String getContentType() {
        return NavigationMenuItem.class.getSimpleName();
    }

    public NavigationMenuItem toDTO(final DTOConverterContext dtoConverterContext, final SiteNavigationMenuItem siteNavigationMenuItem) throws Exception {
        final UnicodeProperties unicodeProperties = this._getUnicodeProperties(siteNavigationMenuItem);
        final Layout layout = this._layoutLocalService.fetchLayoutByExternalReferenceCode(unicodeProperties.getProperty("externalReferenceCode"), siteNavigationMenuItem.getGroupId());
        final String navigationMenuItemType = this._toType(siteNavigationMenuItem.getType());
        return new NavigationMenuItem(){
            {
                this.setAvailableLanguages(() -> {
                    Map<Locale, String> localizedMap = NavigationMenuItemDTOConverter.this._getLocalizedNamesFromProperties(unicodeProperties);
                    Set<Locale> locales = localizedMap.keySet();
                    return LocaleUtil.toW3cLanguageIds((Locale[])locales.toArray(new Locale[localizedMap.size()]));
                });
                this.setCreator(() -> {
                    final User user = NavigationMenuItemDTOConverter.this._userLocalService.fetchUser(siteNavigationMenuItem.getUserId());
                    if (user == null) {
                        return null;
                    }
                    return new Creator(){
                        {
                            this.setExternalReferenceCode(() -> ((User)user).getExternalReferenceCode());
                        }
                    };
                });
                this.setCustomFields(() -> CustomFieldsUtil.toCustomFields((boolean)dtoConverterContext.isAcceptAllLanguages(), (String)SiteNavigationMenuItem.class.getName(), (long)siteNavigationMenuItem.getSiteNavigationMenuItemId(), (long)siteNavigationMenuItem.getCompanyId(), (Locale)dtoConverterContext.getLocale()));
                this.setDateCreated(() -> ((SiteNavigationMenuItem)siteNavigationMenuItem).getCreateDate());
                this.setDateModified(() -> ((SiteNavigationMenuItem)siteNavigationMenuItem).getModifiedDate());
                this.setDefaultLanguageId(() -> {
                    String defaultLanguageId = unicodeProperties.getProperty("defaultLanguageId");
                    if (defaultLanguageId != null) {
                        return defaultLanguageId;
                    }
                    return LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault());
                });
                this.setDisplayIcon(() -> unicodeProperties.getProperty("displayIcon"));
                this.setExternalReferenceCode(() -> ((SiteNavigationMenuItem)siteNavigationMenuItem).getExternalReferenceCode());
                this.setId(() -> ((SiteNavigationMenuItem)siteNavigationMenuItem).getSiteNavigationMenuItemId());
                this.setName(() -> NavigationMenuItemDTOConverter.this._getName(layout, dtoConverterContext.getLocale(), navigationMenuItemType, unicodeProperties, this.getUseCustomName()));
                this.setName_i18n(() -> {
                    Map localizedNames = NavigationMenuItemDTOConverter.this._getLocalizedNamesFromProperties(unicodeProperties);
                    if ((!this.useCustomName.booleanValue() || localizedNames.isEmpty()) && layout != null) {
                        localizedNames = layout.getNameMap();
                    }
                    return LocalizedMapUtil.getI18nMap(localizedNames);
                });
                this.setNavigationMenuItems(() -> {
                    Map siteNavigationMenuItemsMap = (Map)dtoConverterContext.getAttribute("siteNavigationMenuItemsMap");
                    if (siteNavigationMenuItemsMap == null) {
                        return null;
                    }
                    return (NavigationMenuItem[])TransformUtil.transformToArray((Collection)siteNavigationMenuItemsMap.getOrDefault(siteNavigationMenuItem.getSiteNavigationMenuItemId(), new ArrayList()), item -> {
                        DefaultDTOConverterContext defaultDTOConverterContext = new DefaultDTOConverterContext(dtoConverterContext.isAcceptAllLanguages(), null, NavigationMenuItemDTOConverter.this._dtoConverterRegistry, (Object)siteNavigationMenuItem.getSiteNavigationMenuItemId(), dtoConverterContext.getLocale(), dtoConverterContext.getUriInfo(), dtoConverterContext.getUser());
                        defaultDTOConverterContext.setAttribute("siteNavigationMenuItemsMap", (Object)siteNavigationMenuItemsMap);
                        return NavigationMenuItemDTOConverter.this.toDTO((DTOConverterContext)defaultDTOConverterContext, (SiteNavigationMenuItem)item);
                    }, NavigationMenuItem.class);
                });
                this.setType(() -> ((SiteNavigationMenuItem)siteNavigationMenuItem).getType());
                Object navigationMenuItemSettings = NavigationMenuItemDTOConverter.this._getNavigationMenuItemSettings(siteNavigationMenuItem.getType(), unicodeProperties);
                if (navigationMenuItemSettings != null) {
                    this.setNavigationMenuItemSettings(() -> navigationMenuItemSettings);
                }
                this.setUseCustomName(() -> Boolean.valueOf(unicodeProperties.getProperty("useCustomName")));
            }
        };
    }

    private Locale _getLocaleFromProperty(Map.Entry<String, String> property) {
        return LocaleUtil.fromLanguageId((String)StringUtil.removeSubstring((String)property.getKey(), (String)"name_"));
    }

    private Map<Locale, String> _getLocalizedNamesFromProperties(UnicodeProperties unicodeProperties) throws JSONException {
        if (unicodeProperties == null) {
            return new HashMap<Locale, String>();
        }
        String localizedNames = unicodeProperties.getProperty("localizedNames");
        HashMap<Locale, String> properties = new HashMap<Locale, String>();
        if (localizedNames != null) {
            JSONObject localizedNamesJSONObject = this._jsonFactory.createJSONObject(localizedNames);
            for (String key : localizedNamesJSONObject.keySet()) {
                properties.put(LocaleUtil.fromLanguageId((String)key), localizedNamesJSONObject.getString(key));
            }
            return properties;
        }
        for (Map.Entry entry : unicodeProperties.entrySet()) {
            if (!this._isNameProperty(entry)) continue;
            properties.put(this._getLocaleFromProperty(entry), (String)entry.getValue());
        }
        return properties;
    }

    private String _getName(Layout layout, Locale preferredLocale, String type, UnicodeProperties unicodeProperties, boolean useCustomName) throws JSONException {
        String defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault());
        String preferredLanguageId = LocaleUtil.toLanguageId((Locale)preferredLocale);
        if (StringUtil.equals((String)type, (String)"page")) {
            if (useCustomName) {
                return unicodeProperties.getProperty("name_" + preferredLanguageId, unicodeProperties.getProperty("name_" + defaultLanguageId));
            }
            if (layout == null) {
                return null;
            }
            return layout.getName(preferredLocale);
        }
        if (useCustomName) {
            JSONObject customNameJSONObject = this._jsonFactory.createJSONObject(unicodeProperties.getProperty("localizedNames"));
            return customNameJSONObject.getString(preferredLanguageId, customNameJSONObject.getString(defaultLanguageId));
        }
        if (StringUtil.equals((String)type, (String)"navigationMenu") || StringUtil.equals((String)type, (String)"url")) {
            return unicodeProperties.getProperty("name_" + preferredLanguageId, unicodeProperties.getProperty("name_" + defaultLanguageId));
        }
        return unicodeProperties.getProperty("title");
    }

    private Object _getNavigationMenuItemSettings(String type, final UnicodeProperties unicodeProperties) {
        if (Objects.equals(type, "asset_vocabulary")) {
            return new VocabularyNavigationMenuItemSettings(){
                {
                    this.setClassName(() -> unicodeProperties.getProperty("className"));
                    this.setExternalReferenceCode(() -> unicodeProperties.getProperty("externalReferenceCode"));
                    this.setScopeExternalReferenceCode(() -> unicodeProperties.getProperty("scopeExternalReferenceCode"));
                    this.setShowAssetVocabularyLevel(() -> Boolean.valueOf(unicodeProperties.getProperty("showAssetVocabularyLevel")));
                    this.setTitle(() -> unicodeProperties.getProperty("title"));
                    this.setType(() -> unicodeProperties.getProperty("type"));
                }
            };
        }
        if (Objects.equals(type, "layout")) {
            return new PageNavigationMenuItemSettings(){
                {
                    this.setExternalReferenceCode(() -> unicodeProperties.getProperty("externalReferenceCode"));
                    this.setPrivatePage(() -> Boolean.valueOf(unicodeProperties.getProperty("privateLayout")));
                }
            };
        }
        if (Objects.equals(type, "url")) {
            return new URLNavigationMenuItemSettings(){
                {
                    this.setUrl(() -> unicodeProperties.getProperty("url"));
                    this.setUseNewTab(() -> Boolean.valueOf(unicodeProperties.getProperty("useNewTab")));
                }
            };
        }
        SiteNavigationMenuItemType siteNavigationMenuItemType = this._siteNavigationMenuItemTypeRegistry.getSiteNavigationMenuItemType(type);
        Class clazz = siteNavigationMenuItemType.getClass();
        if (Objects.equals(clazz.getName(), "com.liferay.site.navigation.menu.item.display.page.internal.type.DisplayPageTypeSiteNavigationMenuItemType")) {
            return new DisplayPageNavigationMenuItemSettings(){
                {
                    this.setClassName(() -> unicodeProperties.getProperty("className"));
                    this.setExternalReferenceCode(() -> unicodeProperties.getProperty("externalReferenceCode"));
                    this.setScopeExternalReferenceCode(() -> unicodeProperties.getProperty("scopeExternalReferenceCode"));
                    this.setTitle(() -> unicodeProperties.getProperty("title"));
                    this.setType(() -> unicodeProperties.getProperty("type"));
                }
            };
        }
        return null;
    }

    private UnicodeProperties _getUnicodeProperties(SiteNavigationMenuItem siteNavigationMenuItem) {
        if (siteNavigationMenuItem == null) {
            return null;
        }
        return UnicodePropertiesBuilder.fastLoad((String)siteNavigationMenuItem.getTypeSettings()).build();
    }

    private boolean _isNameProperty(Map.Entry<String, String> entry) {
        String key = entry.getKey();
        return key.startsWith("name_");
    }

    private String _toType(String type) {
        if (type.equals("layout")) {
            return "page";
        }
        if (type.equals("node")) {
            return "navigationMenu";
        }
        if (type.equals(FileEntry.class.getName())) {
            return DLFileEntry.class.getName();
        }
        return type;
    }
}

