/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.dto.v1_0.converter;

import com.liferay.headless.admin.site.dto.v1_0.NavigationMenu;
import com.liferay.headless.admin.site.dto.v1_0.NavigationMenuItem;
import com.liferay.headless.admin.user.dto.v1_0.Creator;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.PermissionService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedFieldsSupplier;
import com.liferay.portal.vulcan.permission.Permission;
import com.liferay.portal.vulcan.permission.PermissionUtil;
import com.liferay.site.navigation.model.SiteNavigationMenu;
import com.liferay.site.navigation.model.SiteNavigationMenuItem;
import com.liferay.site.navigation.service.SiteNavigationMenuItemService;
import com.liferay.site.navigation.util.comparator.SiteNavigationMenuItemOrderComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DTOConverter.class})
public class NavigationMenuDTOConverter
implements DTOConverter<SiteNavigationMenu, NavigationMenu> {
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference(target="(component.name=com.liferay.headless.admin.site.internal.dto.v1_0.converter.NavigationMenuItemDTOConverter)")
    private DTOConverter<SiteNavigationMenuItem, NavigationMenuItem> _navigationMenuItemDTOConverter;
    @Reference
    private PermissionService _permissionService;
    @Reference
    private ResourceActionLocalService _resourceActionLocalService;
    @Reference
    private SiteNavigationMenuItemService _siteNavigationMenuItemService;
    @Reference
    private UserLocalService _userLocalService;

    public String getContentType() {
        return NavigationMenu.class.getSimpleName();
    }

    public NavigationMenu toDTO(final DTOConverterContext dtoConverterContext, final SiteNavigationMenu siteNavigationMenu) throws Exception {
        return new NavigationMenu(){
            {
                this.setActions(() -> ((DTOConverterContext)dtoConverterContext).getActions());
                this.setAuto(() -> ((SiteNavigationMenu)siteNavigationMenu).getAuto());
                this.setCreator(() -> {
                    final User user = NavigationMenuDTOConverter.this._userLocalService.fetchUser(siteNavigationMenu.getUserId());
                    if (user == null) {
                        return null;
                    }
                    return new Creator(){
                        {
                            this.setExternalReferenceCode(() -> ((User)user).getExternalReferenceCode());
                        }
                    };
                });
                this.setDateCreated(() -> ((SiteNavigationMenu)siteNavigationMenu).getCreateDate());
                this.setDateModified(() -> ((SiteNavigationMenu)siteNavigationMenu).getModifiedDate());
                this.setExternalReferenceCode(() -> ((SiteNavigationMenu)siteNavigationMenu).getExternalReferenceCode());
                this.setId(() -> ((SiteNavigationMenu)siteNavigationMenu).getSiteNavigationMenuId());
                this.setName(() -> ((SiteNavigationMenu)siteNavigationMenu).getName());
                this.setNavigationMenuItems(() -> {
                    Map<Long, List<SiteNavigationMenuItem>> siteNavigationMenuItemsMap = NavigationMenuDTOConverter.this._getSiteNavigationMenuItemsMap(NavigationMenuDTOConverter.this._siteNavigationMenuItemService.getSiteNavigationMenuItems(siteNavigationMenu.getSiteNavigationMenuId(), (OrderByComparator)SiteNavigationMenuItemOrderComparator.getInstance((boolean)true)));
                    return (NavigationMenuItem[])TransformUtil.transformToArray((Collection)siteNavigationMenuItemsMap.getOrDefault(0L, new ArrayList()), siteNavigationMenuItem -> {
                        DefaultDTOConverterContext defaultDTOConverterContext = new DefaultDTOConverterContext(dtoConverterContext.isAcceptAllLanguages(), null, NavigationMenuDTOConverter.this._dtoConverterRegistry, (Object)siteNavigationMenuItem.getSiteNavigationMenuItemId(), dtoConverterContext.getLocale(), dtoConverterContext.getUriInfo(), dtoConverterContext.getUser());
                        defaultDTOConverterContext.setAttribute("siteNavigationMenuItemsMap", (Object)siteNavigationMenuItemsMap);
                        return (NavigationMenuItem)NavigationMenuDTOConverter.this._navigationMenuItemDTOConverter.toDTO((DTOConverterContext)defaultDTOConverterContext, siteNavigationMenuItem);
                    }, NavigationMenuItem.class);
                });
                this.setNavigationType(() -> {
                    if (siteNavigationMenu.getType() == 0) {
                        return null;
                    }
                    return NavigationMenu.NavigationType.values()[siteNavigationMenu.getType() - 1];
                });
                this.setPermissions(() -> NavigationMenuDTOConverter.this._toPermissions(siteNavigationMenu));
                this.setSiteExternalReferenceCode(() -> {
                    Group group = NavigationMenuDTOConverter.this._groupLocalService.fetchGroup(siteNavigationMenu.getGroupId());
                    if (group != null) {
                        return group.getExternalReferenceCode();
                    }
                    return "";
                });
            }
        };
    }

    private Map<Long, List<SiteNavigationMenuItem>> _getSiteNavigationMenuItemsMap(List<SiteNavigationMenuItem> siteNavigationMenuItems) {
        HashMap<Long, List<SiteNavigationMenuItem>> siteNavigationMenuItemsMap = new HashMap<Long, List<SiteNavigationMenuItem>>();
        for (SiteNavigationMenuItem siteNavigationMenuItem : siteNavigationMenuItems) {
            long parentSiteNavigationMenuItemId = siteNavigationMenuItem.getParentSiteNavigationMenuItemId();
            if (siteNavigationMenuItemsMap.containsKey(parentSiteNavigationMenuItemId)) continue;
            for (SiteNavigationMenuItem childSiteNavigationMenuItem : siteNavigationMenuItems) {
                if (parentSiteNavigationMenuItemId != childSiteNavigationMenuItem.getParentSiteNavigationMenuItemId()) continue;
                List parentSiteNavigationMenuItems = siteNavigationMenuItemsMap.getOrDefault(parentSiteNavigationMenuItemId, new ArrayList());
                parentSiteNavigationMenuItems.add(childSiteNavigationMenuItem);
                siteNavigationMenuItemsMap.put(parentSiteNavigationMenuItemId, parentSiteNavigationMenuItems);
            }
        }
        return siteNavigationMenuItemsMap;
    }

    private Permission[] _toPermissions(SiteNavigationMenu siteNavigationMenu) throws Exception {
        return (Permission[])NestedFieldsSupplier.supply((String)"permissions", nestedFieldNames -> {
            this._permissionService.checkPermission(siteNavigationMenu.getGroupId(), siteNavigationMenu.getModelClassName(), siteNavigationMenu.getSiteNavigationMenuId());
            Collection permissions = PermissionUtil.getPermissions((long)siteNavigationMenu.getCompanyId(), (List)this._resourceActionLocalService.getResourceActions(siteNavigationMenu.getModelClassName()), (long)siteNavigationMenu.getSiteNavigationMenuId(), (String)siteNavigationMenu.getModelClassName(), null);
            return permissions.toArray(new Permission[0]);
        });
    }
}

