/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.dto.v1_0.converter;

import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.processor.PortletRegistry;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.fragment.util.configuration.FragmentConfigurationField;
import com.liferay.fragment.util.configuration.FragmentEntryConfigurationParser;
import com.liferay.headless.admin.site.dto.v1_0.BasicFragmentInstancePageElementDefinition;
import com.liferay.headless.admin.site.dto.v1_0.DefaultFragmentReference;
import com.liferay.headless.admin.site.dto.v1_0.FormFragmentInstancePageElementDefinition;
import com.liferay.headless.admin.site.dto.v1_0.FragmentConfigurationFieldValue;
import com.liferay.headless.admin.site.dto.v1_0.FragmentInstance;
import com.liferay.headless.admin.site.dto.v1_0.FragmentItemExternalReference;
import com.liferay.headless.admin.site.dto.v1_0.FragmentReference;
import com.liferay.headless.admin.site.dto.v1_0.PageElementDefinition;
import com.liferay.headless.admin.site.dto.v1_0.WidgetInstance;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.FragmentEditableElementUtil;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.FragmentViewportUtil;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.ItemScopeUtil;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.LocalizedValueUtil;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.WidgetInstanceUtil;
import com.liferay.info.item.InfoItemServiceRegistry;
import com.liferay.layout.util.structure.FragmentStyledLayoutStructureItem;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.layout.util.structure.FragmentStyledLayoutStructureItem"}, service={DTOConverter.class})
public class FragmentInstancePageElementDefinitionDTOConverter
implements DTOConverter<FragmentStyledLayoutStructureItem, PageElementDefinition> {
    @Reference(target="(component.name=com.liferay.headless.admin.site.internal.dto.v1_0.converter.FragmentConfigurationFieldValueDTOConverter)")
    private DTOConverter<FragmentConfigurationField, FragmentConfigurationFieldValue> _configurationFieldValueDTOConverter;
    @Reference
    private FragmentEntryConfigurationParser _fragmentEntryConfigurationParser;
    @Reference
    private FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;
    @Reference
    private InfoItemServiceRegistry _infoItemServiceRegistry;
    @Reference
    private PortletRegistry _portletRegistry;

    public String getContentType() {
        return PageElementDefinition.class.getSimpleName();
    }

    public PageElementDefinition toDTO(DTOConverterContext dtoConverterContext, final FragmentStyledLayoutStructureItem fragmentStyledLayoutStructureItem) throws Exception {
        final Long companyId = (Long)dtoConverterContext.getAttribute("companyId");
        final Long scopeGroupId = (Long)dtoConverterContext.getAttribute("scopeGroupId");
        if (companyId == null || scopeGroupId == null) {
            throw new UnsupportedOperationException();
        }
        final FragmentEntryLink fragmentEntryLink = this._fragmentEntryLinkLocalService.fetchFragmentEntryLink(fragmentStyledLayoutStructureItem.getFragmentEntryLinkId());
        if (fragmentEntryLink == null) {
            throw new UnsupportedOperationException();
        }
        JSONObject editableValuesJSONObject = fragmentEntryLink.getEditableValuesJSONObject();
        final JSONObject freeMarkerJSONObject = editableValuesJSONObject.getJSONObject("com.liferay.fragment.entry.processor.freemarker.FreeMarkerFragmentEntryProcessor");
        if (fragmentEntryLink.isTypeComponent()) {
            return new BasicFragmentInstancePageElementDefinition(){
                {
                    this.setFragmentInstance(() -> FragmentInstancePageElementDefinitionDTOConverter.this._getFragmentInstance(companyId, fragmentEntryLink, fragmentStyledLayoutStructureItem, freeMarkerJSONObject, scopeGroupId));
                    this.setType(PageElementDefinition.Type.BASIC_FRAGMENT);
                }
            };
        }
        return new FormFragmentInstancePageElementDefinition(){
            {
                this.setFieldKey(() -> GetterUtil.getString((String)FragmentInstancePageElementDefinitionDTOConverter.this._getStringValue(freeMarkerJSONObject, "inputFieldId"), null));
                this.setFragmentInstance(() -> FragmentInstancePageElementDefinitionDTOConverter.this._getFragmentInstance(companyId, fragmentEntryLink, fragmentStyledLayoutStructureItem, freeMarkerJSONObject, scopeGroupId));
                this.setHelpText_i18n(() -> FragmentInstancePageElementDefinitionDTOConverter.this._getI18nMap(freeMarkerJSONObject, "inputHelpText"));
                this.setLabel_i18n(() -> FragmentInstancePageElementDefinitionDTOConverter.this._getI18nMap(freeMarkerJSONObject, "inputLabel"));
                this.setMarkAsRequired(() -> FragmentInstancePageElementDefinitionDTOConverter.this._getBooleanValue(freeMarkerJSONObject, "inputRequired"));
                this.setReadOnlyField(() -> FragmentInstancePageElementDefinitionDTOConverter.this._getBooleanValue(freeMarkerJSONObject, "inputReadOnly"));
                this.setShowHelpText(() -> FragmentInstancePageElementDefinitionDTOConverter.this._getBooleanValue(freeMarkerJSONObject, "inputShowHelpText"));
                this.setShowLabel(() -> FragmentInstancePageElementDefinitionDTOConverter.this._getBooleanValue(freeMarkerJSONObject, "inputShowLabel"));
                this.setType(PageElementDefinition.Type.FORM_FRAGMENT);
            }
        };
    }

    private Boolean _getBooleanValue(JSONObject jsonObject, String key) {
        if (jsonObject == null || !jsonObject.has(key)) {
            return null;
        }
        return jsonObject.getBoolean(key);
    }

    private String _getDraftFragmentInstanceExternalReferenceCode(FragmentEntryLink fragmentEntryLink) {
        String originalFragmentEntryLinkERC = fragmentEntryLink.getOriginalFragmentEntryLinkERC();
        if (Validator.isNull((String)originalFragmentEntryLinkERC)) {
            return null;
        }
        FragmentEntryLink originalFragmentEntryLink = this._fragmentEntryLinkLocalService.fetchFragmentEntryLinkByExternalReferenceCode(originalFragmentEntryLinkERC, fragmentEntryLink.getGroupId());
        if (originalFragmentEntryLink == null) {
            return null;
        }
        return originalFragmentEntryLink.getExternalReferenceCode();
    }

    private DTOConverterContext _getDTOConverterContext(long companyId, long scopeGroupId) {
        DefaultDTOConverterContext dtoConverterContext = new DefaultDTOConverterContext(null, null, null, null, null);
        dtoConverterContext.setAttribute("companyId", (Object)companyId);
        dtoConverterContext.setAttribute("scopeGroupId", (Object)scopeGroupId);
        return dtoConverterContext;
    }

    private Map<String, FragmentConfigurationFieldValue> _getFragmentConfigurationFieldValues(FragmentEntryLink fragmentEntryLink, JSONObject freeMarkerJSONObject) throws Exception {
        if (freeMarkerJSONObject == null) {
            return Collections.emptyMap();
        }
        JSONObject configurationJSONObject = fragmentEntryLink.getConfigurationJSONObject();
        if (configurationJSONObject == null) {
            return Collections.emptyMap();
        }
        HashMap<String, FragmentConfigurationFieldValue> map = new HashMap<String, FragmentConfigurationFieldValue>();
        DTOConverterContext dtoConverterContext = this._getDTOConverterContext(fragmentEntryLink.getCompanyId(), fragmentEntryLink.getGroupId());
        for (FragmentConfigurationField fragmentConfigurationField : this._fragmentEntryConfigurationParser.getFragmentConfigurationFields(fragmentEntryLink.getConfigurationJSONObject())) {
            if (!freeMarkerJSONObject.has(fragmentConfigurationField.getName())) continue;
            dtoConverterContext.setAttribute("fragmentFragmentConfigurationFieldValue", freeMarkerJSONObject.get(fragmentConfigurationField.getName()));
            map.put(fragmentConfigurationField.getName(), (FragmentConfigurationFieldValue)this._configurationFieldValueDTOConverter.toDTO(dtoConverterContext, (Object)fragmentConfigurationField));
        }
        return map;
    }

    private FragmentInstance _getFragmentInstance(final long companyId, final FragmentEntryLink fragmentEntryLink, final FragmentStyledLayoutStructureItem fragmentStyledLayoutStructureItem, final JSONObject freeMarkerJSONObject, final long scopeGroupId) {
        return new FragmentInstance(){
            {
                this.setConfiguration(() -> ((FragmentEntryLink)fragmentEntryLink).getConfiguration());
                this.setCss(() -> ((FragmentEntryLink)fragmentEntryLink).getCss());
                this.setCssClasses(() -> {
                    if (SetUtil.isEmpty((Set)fragmentStyledLayoutStructureItem.getCssClasses())) {
                        return null;
                    }
                    return ArrayUtil.toStringArray((Collection)fragmentStyledLayoutStructureItem.getCssClasses());
                });
                this.setDatePropagated(() -> ((FragmentEntryLink)fragmentEntryLink).getLastPropagationDate());
                this.setDraftFragmentInstanceExternalReferenceCode(() -> FragmentInstancePageElementDefinitionDTOConverter.this._getDraftFragmentInstanceExternalReferenceCode(fragmentEntryLink));
                this.setFragmentConfigurationFieldValues(() -> FragmentInstancePageElementDefinitionDTOConverter.this._getFragmentConfigurationFieldValues(fragmentEntryLink, freeMarkerJSONObject));
                this.setFragmentEditableElements(() -> FragmentEditableElementUtil.getFragmentEditableElements(companyId, fragmentEntryLink, FragmentInstancePageElementDefinitionDTOConverter.this._infoItemServiceRegistry, scopeGroupId));
                this.setFragmentInstanceExternalReferenceCode(() -> ((FragmentEntryLink)fragmentEntryLink).getExternalReferenceCode());
                this.setFragmentReference(() -> {
                    if (Validator.isNull((String)fragmentEntryLink.getFragmentEntryERC()) && Validator.isNull((String)fragmentEntryLink.getRendererKey())) {
                        return null;
                    }
                    if (Validator.isNotNull((String)fragmentEntryLink.getFragmentEntryERC())) {
                        return new FragmentItemExternalReference(){
                            {
                                this.setExternalReferenceCode(() -> ((FragmentEntryLink)fragmentEntryLink).getFragmentEntryERC());
                                this.setFragmentReferenceType(() -> FragmentReference.FragmentReferenceType.FRAGMENT_ITEM_EXTERNAL_REFERENCE);
                                this.setScope(() -> ItemScopeUtil.getItemScope(fragmentEntryLink.getCompanyId(), fragmentEntryLink.getFragmentEntryScopeERC(), fragmentEntryLink.getGroupId()));
                            }
                        };
                    }
                    return new DefaultFragmentReference(){
                        {
                            this.setDefaultFragmentKey(() -> ((FragmentEntryLink)fragmentEntryLink).getRendererKey());
                            this.setFragmentReferenceType(() -> FragmentReference.FragmentReferenceType.DEFAULT_FRAGMENT_REFERENCE);
                        }
                    };
                });
                this.setFragmentViewports(() -> FragmentViewportUtil.toFragmentViewports(fragmentStyledLayoutStructureItem.getItemConfigJSONObject()));
                this.setHtml(() -> ((FragmentEntryLink)fragmentEntryLink).getHtml());
                this.setIndexed(() -> ((FragmentStyledLayoutStructureItem)fragmentStyledLayoutStructureItem).isIndexed());
                this.setJs(() -> ((FragmentEntryLink)fragmentEntryLink).getJs());
                this.setName(() -> ((FragmentStyledLayoutStructureItem)fragmentStyledLayoutStructureItem).getName());
                this.setNamespace(() -> ((FragmentEntryLink)fragmentEntryLink).getNamespace());
                this.setUuid(() -> ((FragmentEntryLink)fragmentEntryLink).getUuid());
                this.setWidgetInstances(() -> FragmentInstancePageElementDefinitionDTOConverter.this._getWidgetInstances(fragmentEntryLink));
            }
        };
    }

    private Map<String, String> _getI18nMap(JSONObject jsonObject, String key) {
        if (jsonObject == null || !jsonObject.has(key)) {
            return null;
        }
        Map i18nMap = null;
        Object value = jsonObject.get(key);
        if (value instanceof JSONObject) {
            JSONObject valueJSONObject = (JSONObject)value;
            i18nMap = LocalizedValueUtil.toLocalizedValues(valueJSONObject, languageId -> valueJSONObject.getString(languageId));
        }
        if (MapUtil.isEmpty(i18nMap)) {
            return null;
        }
        return i18nMap;
    }

    private String _getStringValue(JSONObject jsonObject, String key) {
        if (jsonObject == null || !jsonObject.has(key)) {
            return null;
        }
        return jsonObject.getString(key);
    }

    private WidgetInstance[] _getWidgetInstances(FragmentEntryLink fragmentEntryLink) {
        List fragmentEntryLinkPortletIds = this._portletRegistry.getFragmentEntryLinkPortletIds(fragmentEntryLink);
        if (ListUtil.isEmpty((List)fragmentEntryLinkPortletIds)) {
            return null;
        }
        ArrayList<WidgetInstance> widgetInstances = new ArrayList<WidgetInstance>();
        for (String fragmentEntryLinkPortletId : fragmentEntryLinkPortletIds) {
            widgetInstances.add(WidgetInstanceUtil.getWidgetInstance(PortletIdCodec.decodeInstanceId((String)fragmentEntryLinkPortletId), fragmentEntryLink.getPlid(), fragmentEntryLinkPortletId));
        }
        return widgetInstances.toArray(new WidgetInstance[0]);
    }
}

