/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.dto.v1_0.converter;

import com.liferay.headless.admin.site.dto.v1_0.ContainerPageElementDefinition;
import com.liferay.headless.admin.site.dto.v1_0.HtmlProperties;
import com.liferay.headless.admin.site.dto.v1_0.PageElementDefinition;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.ContainerLayoutUtil;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.FragmentLinkUtil;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.FragmentViewportUtil;
import com.liferay.info.item.InfoItemServiceRegistry;
import com.liferay.layout.converter.ContentVisibilityConverter;
import com.liferay.layout.util.structure.ContainerStyledLayoutStructureItem;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.layout.util.structure.ContainerStyledLayoutStructureItem"}, service={DTOConverter.class})
public class ContainerPageElementDefinitionDTOConverter
implements DTOConverter<ContainerStyledLayoutStructureItem, ContainerPageElementDefinition> {
    private static final Map<String, HtmlProperties.HtmlTag> _internalToExternalValuesMap = HashMapBuilder.put((Object)"article", (Object)HtmlProperties.HtmlTag.ARTICLE).put((Object)"aside", (Object)HtmlProperties.HtmlTag.ASIDE).put((Object)"div", (Object)HtmlProperties.HtmlTag.DIV).put((Object)"footer", (Object)HtmlProperties.HtmlTag.FOOTER).put((Object)"header", (Object)HtmlProperties.HtmlTag.HEADER).put((Object)"nav", (Object)HtmlProperties.HtmlTag.NAV).put((Object)"section", (Object)HtmlProperties.HtmlTag.SECTION).build();
    @Reference
    private InfoItemServiceRegistry _infoItemServiceRegistry;

    public String getContentType() {
        return ContainerPageElementDefinition.class.getSimpleName();
    }

    public ContainerPageElementDefinition toDTO(DTOConverterContext dtoConverterContext, final ContainerStyledLayoutStructureItem containerStyledLayoutStructureItem) throws Exception {
        final Long companyId = (Long)dtoConverterContext.getAttribute("companyId");
        final Long scopeGroupId = (Long)dtoConverterContext.getAttribute("scopeGroupId");
        if (companyId == null || scopeGroupId == null) {
            throw new UnsupportedOperationException();
        }
        return new ContainerPageElementDefinition(){
            {
                this.setContentVisibility(() -> {
                    String contentVisibility = containerStyledLayoutStructureItem.getContentVisibility();
                    if (Validator.isNull((String)contentVisibility)) {
                        return null;
                    }
                    return ContainerPageElementDefinition.ContentVisibility.create((String)ContentVisibilityConverter.convertToExternalValue((String)contentVisibility));
                });
                this.setCssClasses(() -> {
                    Set cssClasses = containerStyledLayoutStructureItem.getCssClasses();
                    if (SetUtil.isEmpty((Set)cssClasses)) {
                        return null;
                    }
                    return ArrayUtil.toStringArray((Collection)cssClasses);
                });
                this.setFragmentLink(() -> FragmentLinkUtil.toFragmentLink(companyId, ContainerPageElementDefinitionDTOConverter.this._infoItemServiceRegistry, containerStyledLayoutStructureItem.getLinkJSONObject(), scopeGroupId));
                this.setFragmentViewports(() -> FragmentViewportUtil.toFragmentViewports(containerStyledLayoutStructureItem.getItemConfigJSONObject()));
                this.setHtmlProperties(() -> ContainerPageElementDefinitionDTOConverter.this._toHtmlProperties(containerStyledLayoutStructureItem));
                this.setIndexed(() -> ((ContainerStyledLayoutStructureItem)containerStyledLayoutStructureItem).isIndexed());
                this.setLayout(() -> ContainerLayoutUtil.toLayout(containerStyledLayoutStructureItem.getItemConfigJSONObject()));
                this.setName(() -> ((ContainerStyledLayoutStructureItem)containerStyledLayoutStructureItem).getName());
                this.setType(PageElementDefinition.Type.CONTAINER);
            }
        };
    }

    private HtmlProperties _toHtmlProperties(final ContainerStyledLayoutStructureItem containerStyledLayoutStructureItem) {
        if (Validator.isNull((String)containerStyledLayoutStructureItem.getHtmlTag())) {
            return null;
        }
        return new HtmlProperties(){
            {
                this.setHtmlTag(() -> _internalToExternalValuesMap.get(containerStyledLayoutStructureItem.getHtmlTag()));
            }
        };
    }
}

