/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.resource.v1_0.util;

import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.headless.admin.site.dto.v1_0.ItemExternalReference;
import com.liferay.headless.admin.site.dto.v1_0.OpenGraphSettings;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.ItemScopeUtil;
import com.liferay.layout.seo.model.LayoutSEOEntry;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.util.Map;

public class OpenGraphSettingsUtil {
    public static OpenGraphSettings getOpenGraphSettings(final DLAppService dlAppService, final LayoutSEOEntry layoutSEOEntry) {
        if (layoutSEOEntry == null || MapUtil.isEmpty((Map)layoutSEOEntry.getOpenGraphDescriptionMap()) && MapUtil.isEmpty((Map)layoutSEOEntry.getOpenGraphImageAltMap()) && layoutSEOEntry.getOpenGraphImageFileEntryId() == 0L && MapUtil.isEmpty((Map)layoutSEOEntry.getOpenGraphTitleMap())) {
            return null;
        }
        return new OpenGraphSettings(){
            {
                this.setDescription_i18n(() -> {
                    Map map = layoutSEOEntry.getOpenGraphDescriptionMap();
                    if (MapUtil.isEmpty((Map)map)) {
                        return null;
                    }
                    return LocalizedMapUtil.getI18nMap((Map)map);
                });
                this.setImage(() -> {
                    long openGraphImageFileEntryId = layoutSEOEntry.getOpenGraphImageFileEntryId();
                    if (openGraphImageFileEntryId == 0L) {
                        return null;
                    }
                    final FileEntry fileEntry = dlAppService.getFileEntry(openGraphImageFileEntryId);
                    return new ItemExternalReference(){
                        {
                            this.setClassName(FileEntry.class::getName);
                            this.setExternalReferenceCode(() -> ((FileEntry)fileEntry).getExternalReferenceCode());
                            this.setScope(() -> ItemScopeUtil.getItemScope(fileEntry.getGroupId(), layoutSEOEntry.getGroupId()));
                        }
                    };
                });
                this.setImageAlt_i18n(() -> {
                    Map map = layoutSEOEntry.getOpenGraphImageAltMap();
                    if (MapUtil.isEmpty((Map)map)) {
                        return null;
                    }
                    return LocalizedMapUtil.getI18nMap((Map)map);
                });
                this.setTitle_i18n(() -> {
                    Map map = layoutSEOEntry.getOpenGraphTitleMap();
                    if (MapUtil.isEmpty((Map)map)) {
                        return null;
                    }
                    return LocalizedMapUtil.getI18nMap((Map)map);
                });
            }
        };
    }
}

