/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.resource.v1_0.layout.structure.item.importer;

import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.processor.DefaultFragmentEntryProcessorContext;
import com.liferay.fragment.processor.FragmentEntryProcessorContext;
import com.liferay.fragment.processor.FragmentEntryProcessorRegistry;
import com.liferay.fragment.processor.PortletRegistry;
import com.liferay.fragment.service.FragmentEntryLinkLocalServiceUtil;
import com.liferay.headless.admin.site.dto.v1_0.FragmentInstancePageElementDefinition;
import com.liferay.headless.admin.site.dto.v1_0.PageElement;
import com.liferay.headless.admin.site.dto.v1_0.WidgetInstance;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.FragmentEditableElementUtil;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.FragmentEntryReference;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.FragmentEntryReferenceUtil;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.FragmentViewportUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.layout.structure.item.importer.LayoutStructureItemImporter;
import com.liferay.headless.admin.site.internal.resource.v1_0.layout.structure.item.importer.context.LayoutStructureItemImporterContext;
import com.liferay.headless.admin.site.internal.resource.v1_0.layout.structure.item.importer.util.FragmentConfigurationFieldValuesUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.LayoutStructureUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.PortletUtil;
import com.liferay.layout.util.structure.FragmentStyledLayoutStructureItem;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;

public class FragmentLayoutStructureItemImporter
implements LayoutStructureItemImporter {
    private static final ServiceTracker<PortletRegistry, PortletRegistry> _portletRegistryServiceTracker = ServiceTrackerFactory.open((Bundle)FrameworkUtil.getBundle(FragmentLayoutStructureItemImporter.class), PortletRegistry.class);

    @Override
    public LayoutStructureItem addLayoutStructureItem(LayoutStructure layoutStructure, LayoutStructureItemImporterContext layoutStructureItemImporterContext, PageElement pageElement) throws Exception {
        FragmentInstancePageElementDefinition fragmentInstancePageElementDefinition = (FragmentInstancePageElementDefinition)pageElement.getPageElementDefinition();
        if (fragmentInstancePageElementDefinition == null) {
            return null;
        }
        List fragmentEntryLinkPortletIds = null;
        FragmentEntryLink fragmentEntryLink = FragmentEntryLinkLocalServiceUtil.fetchFragmentEntryLinkByExternalReferenceCode((String)fragmentInstancePageElementDefinition.getFragmentInstanceExternalReferenceCode(), (long)layoutStructureItemImporterContext.getGroupId());
        if (fragmentEntryLink == null) {
            fragmentEntryLink = this._addFragmentEntryLink(fragmentInstancePageElementDefinition, layoutStructureItemImporterContext);
        } else {
            PortletRegistry portletRegistry = (PortletRegistry)_portletRegistryServiceTracker.getService();
            if (portletRegistry != null) {
                fragmentEntryLinkPortletIds = portletRegistry.getFragmentEntryLinkPortletIds(fragmentEntryLink);
            }
            fragmentEntryLink = this._updateFragmentEntryLink(fragmentEntryLink, fragmentInstancePageElementDefinition, layoutStructureItemImporterContext);
        }
        if (fragmentEntryLink == null) {
            return null;
        }
        Layout layout = layoutStructureItemImporterContext.getLayout();
        if (ArrayUtil.isNotEmpty((Object[])fragmentInstancePageElementDefinition.getWidgetInstances())) {
            for (WidgetInstance widgetInstance : fragmentInstancePageElementDefinition.getWidgetInstances()) {
                if (Validator.isNull((String)widgetInstance.getWidgetName())) continue;
                String portletId = PortletIdCodec.encode((String)widgetInstance.getWidgetName(), (String)widgetInstance.getWidgetInstanceId());
                PortletUtil.importPortletPermissions(layout, portletId, widgetInstance.getWidgetName(), widgetInstance.getWidgetPermissions());
                PortletUtil.importPortletPreferences(layout, portletId, widgetInstance.getWidgetConfig());
            }
        }
        if (ListUtil.isNotEmpty((List)fragmentEntryLinkPortletIds)) {
            for (String fragmentEntryLinkPortletId : SetUtil.asymmetricDifference((Collection)fragmentEntryLinkPortletIds, this._getPortletIds(fragmentInstancePageElementDefinition.getWidgetInstances()))) {
                PortletPreferencesLocalServiceUtil.deletePortletPreferences((long)0L, (int)3, (long)layout.getPlid(), (String)fragmentEntryLinkPortletId);
                ResourcePermissionLocalServiceUtil.deleteResourcePermissions((long)layout.getCompanyId(), (String)fragmentEntryLinkPortletId, (int)4, (String)PortletPermissionUtil.getPrimaryKey((long)layout.getPlid(), (String)fragmentEntryLinkPortletId));
            }
        }
        FragmentStyledLayoutStructureItem fragmentStyledLayoutStructureItem = (FragmentStyledLayoutStructureItem)layoutStructure.addFragmentStyledLayoutStructureItem(fragmentEntryLink.getFragmentEntryLinkId(), pageElement.getExternalReferenceCode(), LayoutStructureUtil.getParentExternalReferenceCode(pageElement, layoutStructure), pageElement.getPosition().intValue());
        fragmentStyledLayoutStructureItem.setCssClasses(SetUtil.fromArray((Object[])fragmentInstancePageElementDefinition.getCssClasses()));
        fragmentStyledLayoutStructureItem.setIndexed(GetterUtil.getBoolean((Object)fragmentInstancePageElementDefinition.getIndexed(), (boolean)true));
        fragmentStyledLayoutStructureItem.setName(fragmentInstancePageElementDefinition.getName());
        JSONObject fragmentViewportsJSONObject = FragmentViewportUtil.toFragmentViewportsJSONObject(fragmentInstancePageElementDefinition.getFragmentViewports());
        if (fragmentViewportsJSONObject != null) {
            fragmentStyledLayoutStructureItem.updateItemConfig(fragmentViewportsJSONObject);
        }
        return fragmentStyledLayoutStructureItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FragmentEntryLink _addFragmentEntryLink(FragmentInstancePageElementDefinition fragmentInstancePageElementDefinition, LayoutStructureItemImporterContext layoutStructureItemImporterContext) throws Exception {
        Layout layout = layoutStructureItemImporterContext.getLayout();
        FragmentEntryReference fragmentEntryReference = FragmentEntryReferenceUtil.getFragmentEntryReference(layoutStructureItemImporterContext.getCompanyId(), fragmentInstancePageElementDefinition.getFragmentReference(), layoutStructureItemImporterContext.getGroupId());
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date createDate = serviceContext.getCreateDate();
        String uuid = serviceContext.getUuid();
        try {
            serviceContext.setCreateDate(fragmentInstancePageElementDefinition.getDatePropagated());
            serviceContext.setUuid(fragmentInstancePageElementDefinition.getUuid());
            FragmentEntryLink fragmentEntryLink = FragmentEntryLinkLocalServiceUtil.addFragmentEntryLink((String)fragmentInstancePageElementDefinition.getFragmentInstanceExternalReferenceCode(), (long)layoutStructureItemImporterContext.getUserId(), (long)layout.getGroupId(), (String)this._getOriginalFragmentEntryLinkERC(fragmentInstancePageElementDefinition, layoutStructureItemImporterContext), (String)fragmentEntryReference.getFragmentEntryERC(), (String)fragmentEntryReference.getFragmentEntryScopeERC(), (long)layoutStructureItemImporterContext.getSegmentsExperienceId(), (long)layout.getPlid(), (String)GetterUtil.getString((String)fragmentInstancePageElementDefinition.getCss()), (String)GetterUtil.getString((String)fragmentInstancePageElementDefinition.getHtml()), (String)GetterUtil.getString((String)fragmentInstancePageElementDefinition.getJs()), (String)GetterUtil.getString((String)fragmentInstancePageElementDefinition.getConfiguration()), (String)this._getEditableValues(fragmentInstancePageElementDefinition, layoutStructureItemImporterContext), (String)fragmentInstancePageElementDefinition.getNamespace(), (int)0, (String)fragmentEntryReference.getRendererKey(), (int)this._getType(fragmentInstancePageElementDefinition), (ServiceContext)serviceContext);
            FragmentEntryProcessorRegistry fragmentEntryProcessorRegistry = layoutStructureItemImporterContext.getFragmentEntryProcessorRegistry();
            FragmentEntryLink fragmentEntryLink2 = FragmentEntryLinkLocalServiceUtil.updateFragmentEntryLink((long)fragmentEntryLink.getUserId(), (long)fragmentEntryLink.getFragmentEntryLinkId(), (String)fragmentEntryProcessorRegistry.mergeDefaultEditableValues(fragmentEntryLink.getConfigurationJSONObject(), fragmentEntryLink.getEditableValuesJSONObject(), this._getProcessedHTML(fragmentEntryLink, fragmentEntryProcessorRegistry, serviceContext)), (boolean)false);
            return fragmentEntryLink2;
        }
        finally {
            serviceContext.setCreateDate(createDate);
            serviceContext.setUuid(uuid);
        }
    }

    private String _getEditableValues(FragmentInstancePageElementDefinition fragmentInstancePageElementDefinition, LayoutStructureItemImporterContext layoutStructureItemImporterContext) throws Exception {
        return JSONUtil.put((String)"com.liferay.fragment.entry.processor.background.image.BackgroundImageFragmentEntryProcessor", (Object)FragmentEditableElementUtil.getBackgroundImageFragmentEntryProcessorJSONObject(fragmentInstancePageElementDefinition.getFragmentEditableElements(), layoutStructureItemImporterContext)).put("com.liferay.fragment.entry.processor.editable.EditableFragmentEntryProcessor", FragmentEditableElementUtil.getEditableFragmentEntryProcessorJSONObject(fragmentInstancePageElementDefinition.getFragmentEditableElements(), layoutStructureItemImporterContext)).put("com.liferay.fragment.entry.processor.freemarker.FreeMarkerFragmentEntryProcessor", FragmentConfigurationFieldValuesUtil.getFreeMarkerFragmentEntryProcessorJSONObject(fragmentInstancePageElementDefinition.getConfiguration(), fragmentInstancePageElementDefinition.getFragmentConfigurationFieldValues(), layoutStructureItemImporterContext)).toString();
    }

    private String _getOriginalFragmentEntryLinkERC(FragmentInstancePageElementDefinition fragmentInstancePageElementDefinition, LayoutStructureItemImporterContext layoutStructureItemImporterContext) {
        if (Validator.isNull((String)fragmentInstancePageElementDefinition.getDraftFragmentInstanceExternalReferenceCode())) {
            return null;
        }
        FragmentEntryLink fragmentEntryLink = FragmentEntryLinkLocalServiceUtil.fetchFragmentEntryLinkByExternalReferenceCode((String)fragmentInstancePageElementDefinition.getDraftFragmentInstanceExternalReferenceCode(), (long)layoutStructureItemImporterContext.getGroupId());
        if (fragmentEntryLink == null) {
            return null;
        }
        return fragmentEntryLink.getExternalReferenceCode();
    }

    private List<String> _getPortletIds(WidgetInstance[] widgetInstances) {
        ArrayList<String> portletIds = new ArrayList<String>();
        if (ArrayUtil.isEmpty((Object[])widgetInstances)) {
            return portletIds;
        }
        for (WidgetInstance widgetInstance : widgetInstances) {
            portletIds.add(PortletIdCodec.encode((String)widgetInstance.getWidgetName(), (String)widgetInstance.getWidgetInstanceId()));
        }
        return portletIds;
    }

    private String _getProcessedHTML(FragmentEntryLink fragmentEntryLink, FragmentEntryProcessorRegistry fragmentEntryProcessorRegistry, ServiceContext serviceContext) throws PortalException {
        if (serviceContext == null) {
            return fragmentEntryLink.getHtml();
        }
        HttpServletRequest httpServletRequest = serviceContext.getRequest();
        HttpServletResponse httpServletResponse = serviceContext.getResponse();
        ThemeDisplay themeDisplay = serviceContext.getThemeDisplay();
        if (httpServletRequest == null && themeDisplay != null) {
            httpServletRequest = themeDisplay.getRequest();
        }
        if (httpServletResponse == null && themeDisplay != null) {
            httpServletResponse = themeDisplay.getResponse();
        }
        if (httpServletRequest == null || httpServletResponse == null) {
            return fragmentEntryLink.getHtml();
        }
        fragmentEntryLink.setEditableValues(null);
        DefaultFragmentEntryProcessorContext fragmentEntryProcessorContext = new DefaultFragmentEntryProcessorContext(httpServletRequest, httpServletResponse, "EDIT", LocaleUtil.getMostRelevantLocale());
        return fragmentEntryProcessorRegistry.processFragmentEntryLinkHTML(fragmentEntryLink, (FragmentEntryProcessorContext)fragmentEntryProcessorContext);
    }

    private int _getType(FragmentInstancePageElementDefinition fragmentInstancePageElementDefinition) {
        int type = 1;
        if (Objects.equals(FragmentInstancePageElementDefinition.FragmentType.FORM, fragmentInstancePageElementDefinition.getFragmentType())) {
            type = 3;
        }
        return type;
    }

    private FragmentEntryLink _updateFragmentEntryLink(FragmentEntryLink fragmentEntryLink, FragmentInstancePageElementDefinition fragmentInstancePageElementDefinition, LayoutStructureItemImporterContext layoutStructureItemImporterContext) throws Exception {
        Layout layout = layoutStructureItemImporterContext.getLayout();
        if (fragmentEntryLink.getPlid() != layout.getPlid() || fragmentEntryLink.getSegmentsExperienceId() != layoutStructureItemImporterContext.getSegmentsExperienceId()) {
            throw new UnsupportedOperationException();
        }
        FragmentEntryReference fragmentEntryReference = FragmentEntryReferenceUtil.getFragmentEntryReference(layoutStructureItemImporterContext.getCompanyId(), fragmentInstancePageElementDefinition.getFragmentReference(), layoutStructureItemImporterContext.getGroupId());
        fragmentEntryLink.setOriginalFragmentEntryLinkERC(this._getOriginalFragmentEntryLinkERC(fragmentInstancePageElementDefinition, layoutStructureItemImporterContext));
        fragmentEntryLink.setFragmentEntryERC(fragmentEntryReference.getFragmentEntryERC());
        fragmentEntryLink.setFragmentEntryScopeERC(fragmentEntryReference.getFragmentEntryScopeERC());
        fragmentEntryLink.setCss(GetterUtil.getString((String)fragmentInstancePageElementDefinition.getCss()));
        fragmentEntryLink.setHtml(GetterUtil.getString((String)fragmentInstancePageElementDefinition.getHtml()));
        fragmentEntryLink.setJs(GetterUtil.getString((String)fragmentInstancePageElementDefinition.getJs()));
        fragmentEntryLink.setConfiguration(GetterUtil.getString((String)fragmentInstancePageElementDefinition.getConfiguration()));
        fragmentEntryLink.setEditableValues(this._getEditableValues(fragmentInstancePageElementDefinition, layoutStructureItemImporterContext));
        fragmentEntryLink.setNamespace(fragmentInstancePageElementDefinition.getNamespace());
        fragmentEntryLink.setRendererKey(fragmentEntryReference.getRendererKey());
        fragmentEntryLink.setType(this._getType(fragmentInstancePageElementDefinition));
        fragmentEntryLink.setLastPropagationDate(fragmentInstancePageElementDefinition.getDatePropagated());
        fragmentEntryLink = FragmentEntryLinkLocalServiceUtil.updateFragmentEntryLink((FragmentEntryLink)fragmentEntryLink);
        FragmentEntryProcessorRegistry fragmentEntryProcessorRegistry = layoutStructureItemImporterContext.getFragmentEntryProcessorRegistry();
        return FragmentEntryLinkLocalServiceUtil.updateFragmentEntryLink((long)fragmentEntryLink.getUserId(), (long)fragmentEntryLink.getFragmentEntryLinkId(), (String)fragmentEntryProcessorRegistry.mergeDefaultEditableValues(fragmentEntryLink.getConfigurationJSONObject(), fragmentEntryLink.getEditableValuesJSONObject(), this._getProcessedHTML(fragmentEntryLink, fragmentEntryProcessorRegistry, ServiceContextThreadLocal.getServiceContext())), (boolean)false);
    }
}

