/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.resource.v1_0.layout.structure.item.importer;

import com.liferay.headless.admin.site.dto.v1_0.DisplayPageFormContainerSubmissionResult;
import com.liferay.headless.admin.site.dto.v1_0.EmbeddedMessageFormContainerSubmissionResult;
import com.liferay.headless.admin.site.dto.v1_0.FormContainerClassSubtypeReference;
import com.liferay.headless.admin.site.dto.v1_0.FormContainerConfig;
import com.liferay.headless.admin.site.dto.v1_0.FormContainerContextReference;
import com.liferay.headless.admin.site.dto.v1_0.FormContainerPageElementDefinition;
import com.liferay.headless.admin.site.dto.v1_0.FragmentInlineValue;
import com.liferay.headless.admin.site.dto.v1_0.ItemExternalReference;
import com.liferay.headless.admin.site.dto.v1_0.LocalizationConfig;
import com.liferay.headless.admin.site.dto.v1_0.PageElement;
import com.liferay.headless.admin.site.dto.v1_0.SitePageFormContainerSubmissionResult;
import com.liferay.headless.admin.site.dto.v1_0.StayInPageFormContainerSubmissionResult;
import com.liferay.headless.admin.site.dto.v1_0.SuccessFormContainerSubmissionResult;
import com.liferay.headless.admin.site.dto.v1_0.SuccessNotificationMessage;
import com.liferay.headless.admin.site.dto.v1_0.URLFormContainerSubmissionResult;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.FragmentViewportUtil;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.ItemScopeUtil;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.LocalizedValueUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.layout.structure.item.importer.LayoutStructureItemImporter;
import com.liferay.headless.admin.site.internal.resource.v1_0.layout.structure.item.importer.context.LayoutStructureItemImporterContext;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.LayoutStructureUtil;
import com.liferay.headless.admin.site.internal.util.LogUtil;
import com.liferay.layout.converter.AlignConverter;
import com.liferay.layout.converter.ContentDisplayConverter;
import com.liferay.layout.converter.FlexWrapConverter;
import com.liferay.layout.converter.JustifyConverter;
import com.liferay.layout.converter.WidthTypeConverter;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalServiceUtil;
import com.liferay.layout.util.structure.FormStyledLayoutStructureItem;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.object.model.ObjectEntry;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Objects;

public class FormContainerLayoutStructureItemImporter
implements LayoutStructureItemImporter {
    @Override
    public LayoutStructureItem addLayoutStructureItem(LayoutStructure layoutStructure, LayoutStructureItemImporterContext layoutStructureItemImporterContext, PageElement pageElement) throws Exception {
        FormContainerConfig formContainerConfig;
        FormStyledLayoutStructureItem formStyledLayoutStructureItem = (FormStyledLayoutStructureItem)layoutStructure.addFormStyledLayoutStructureItem(pageElement.getExternalReferenceCode(), LayoutStructureUtil.getParentExternalReferenceCode(pageElement, layoutStructure), pageElement.getPosition().intValue());
        FormContainerPageElementDefinition formContainerPageElementDefinition = (FormContainerPageElementDefinition)pageElement.getPageElementDefinition();
        if (formContainerPageElementDefinition == null) {
            return formStyledLayoutStructureItem;
        }
        formStyledLayoutStructureItem.setCssClasses(this._getCssClasses(formContainerPageElementDefinition.getCssClasses()));
        formStyledLayoutStructureItem.setIndexed(GetterUtil.getBoolean((Object)formContainerPageElementDefinition.getIndexed(), (boolean)true));
        formStyledLayoutStructureItem.setName(formContainerPageElementDefinition.getName());
        JSONObject fragmentViewportsJSONObject = FragmentViewportUtil.toFragmentViewportsJSONObject(formContainerPageElementDefinition.getFragmentViewports());
        if (fragmentViewportsJSONObject != null) {
            formStyledLayoutStructureItem.updateItemConfig(fragmentViewportsJSONObject);
        }
        if ((formContainerConfig = formContainerPageElementDefinition.getFormContainerConfig()) == null) {
            return formStyledLayoutStructureItem;
        }
        if (formContainerConfig.getFormContainerReference() instanceof FormContainerContextReference) {
            formStyledLayoutStructureItem.setFormConfig(1);
        } else {
            FormContainerClassSubtypeReference formContainerClassSubtypeReference = (FormContainerClassSubtypeReference)formContainerConfig.getFormContainerReference();
            formStyledLayoutStructureItem.setClassNameId(PortalUtil.getClassNameId((String)formContainerClassSubtypeReference.getClassName()));
            formStyledLayoutStructureItem.setFormConfig(2);
        }
        formStyledLayoutStructureItem.setFormType(this._toFormContainerType(formContainerConfig.getFormContainerType()));
        com.liferay.headless.admin.site.dto.v1_0.Layout layout = formContainerPageElementDefinition.getLayout();
        if (layout != null) {
            String widthType;
            String justify;
            String flexWrap;
            String contentDisplay;
            String align = layout.getAlignAsString();
            if (align != null) {
                formStyledLayoutStructureItem.setAlign(AlignConverter.convertToInternalValue((String)align));
            }
            if ((contentDisplay = layout.getContentDisplayAsString()) != null) {
                formStyledLayoutStructureItem.setContentDisplay(ContentDisplayConverter.convertToInternalValue((String)contentDisplay));
            }
            if ((flexWrap = layout.getFlexWrapAsString()) != null) {
                formStyledLayoutStructureItem.setFlexWrap(FlexWrapConverter.convertToInternalValue((String)flexWrap));
            }
            if ((justify = layout.getJustifyAsString()) != null) {
                formStyledLayoutStructureItem.setJustify(JustifyConverter.convertToInternalValue((String)justify));
            }
            if ((widthType = layout.getWidthTypeAsString()) != null) {
                formStyledLayoutStructureItem.setWidthType(WidthTypeConverter.convertToInternalValue((String)widthType));
            }
        } else {
            formStyledLayoutStructureItem.setAlign(null);
            formStyledLayoutStructureItem.setContentDisplay(null);
            formStyledLayoutStructureItem.setFlexWrap(null);
            formStyledLayoutStructureItem.setJustify(null);
            formStyledLayoutStructureItem.setWidthType(null);
        }
        LocalizationConfig localizationConfig = formContainerConfig.getLocalizationConfig();
        if (localizationConfig != null) {
            formStyledLayoutStructureItem.setLocalizationConfigJSONObject(JSONUtil.put((String)"unlocalizedFieldsMessage", (Object)this._toFragmentInlineValueJSONObject(localizationConfig.getUnlocalizedFieldsMessageFragmentInlineValue())).put("unlocalizedFieldsState", () -> {
                LocalizationConfig.UnlocalizedFieldsState unlocalizedFieldsState = localizationConfig.getUnlocalizedFieldsState();
                if (unlocalizedFieldsState == null || Objects.equals(unlocalizedFieldsState, LocalizationConfig.UnlocalizedFieldsState.DISABLED)) {
                    return "disabled";
                }
                return "read-only";
            }));
        }
        formStyledLayoutStructureItem.setNumberOfSteps(formContainerConfig.getNumberOfSteps().intValue());
        this._setSuccessMessageJSONObject(formStyledLayoutStructureItem, layoutStructureItemImporterContext, formContainerConfig.getSuccessFormContainerSubmissionResult());
        return formStyledLayoutStructureItem;
    }

    private LinkedHashSet<String> _getCssClasses(String[] cssClasses) {
        if (cssClasses == null) {
            return null;
        }
        return new LinkedHashSet<String>(Arrays.asList(cssClasses));
    }

    private void _setSuccessMessageJSONObject(FormStyledLayoutStructureItem formStyledLayoutStructureItem, LayoutStructureItemImporterContext layoutStructureItemImporterContext, SuccessFormContainerSubmissionResult successFormContainerSubmissionResult) throws Exception {
        if (successFormContainerSubmissionResult == null) {
            formStyledLayoutStructureItem.setSuccessMessageJSONObject(JSONUtil.put((String)"type", (Object)"embedded"));
        } else {
            JSONObject jsonObject = null;
            jsonObject = successFormContainerSubmissionResult instanceof DisplayPageFormContainerSubmissionResult ? this._toDisplayPageFormContainerSubmissionResultJSONObject((DisplayPageFormContainerSubmissionResult)successFormContainerSubmissionResult, layoutStructureItemImporterContext) : (successFormContainerSubmissionResult instanceof EmbeddedMessageFormContainerSubmissionResult ? this._toEmbeddedMessageFormContainerSubmissionResultJSONObject((EmbeddedMessageFormContainerSubmissionResult)successFormContainerSubmissionResult) : (successFormContainerSubmissionResult instanceof StayInPageFormContainerSubmissionResult ? this._toStayInPageFormContainerSubmissionResultJSONObject((StayInPageFormContainerSubmissionResult)successFormContainerSubmissionResult) : (successFormContainerSubmissionResult instanceof SitePageFormContainerSubmissionResult ? this._toSitePageFormContainerSubmissionResultJSONObject(layoutStructureItemImporterContext, (SitePageFormContainerSubmissionResult)successFormContainerSubmissionResult) : this._toURLFormContainerSubmissionResultJSONObject((URLFormContainerSubmissionResult)successFormContainerSubmissionResult))));
            formStyledLayoutStructureItem.setSuccessMessageJSONObject(jsonObject);
        }
    }

    private JSONObject _toDisplayPageFormContainerSubmissionResultJSONObject(DisplayPageFormContainerSubmissionResult displayPageFormContainerSubmissionResult, LayoutStructureItemImporterContext layoutStructureItemImporterContext) throws Exception {
        JSONObject jsonObject = this._toSuccessNotificationMessageJSONObject(displayPageFormContainerSubmissionResult.getSuccessNotificationMessage());
        if (GetterUtil.getBoolean((Object)displayPageFormContainerSubmissionResult.getDefaultDisplayPage())) {
            return jsonObject.put("displayPage", ObjectEntry.class.getSimpleName() + "_displayPageURL").put("type", "displayPage");
        }
        ItemExternalReference itemExternalReference = displayPageFormContainerSubmissionResult.getItemExternalReference();
        if (itemExternalReference == null) {
            return null;
        }
        return JSONUtil.merge((JSONObject)this._toMappedLayoutPageTemplateEntryJSONObject(layoutStructureItemImporterContext.getCompanyId(), itemExternalReference, layoutStructureItemImporterContext.getGroupId()), (JSONObject)jsonObject.put("type", "displayPage"));
    }

    private JSONObject _toEmbeddedMessageFormContainerSubmissionResultJSONObject(EmbeddedMessageFormContainerSubmissionResult embeddedMessageFormContainerSubmissionResult) {
        return this._toSuccessNotificationMessageJSONObject(embeddedMessageFormContainerSubmissionResult.getSuccessNotificationMessage()).put("message", () -> this._toFragmentInlineValueJSONObject(embeddedMessageFormContainerSubmissionResult.getMessage())).put("type", "embedded");
    }

    private String _toFormContainerType(FormContainerConfig.FormContainerType formType) {
        if (Objects.equals(formType, FormContainerConfig.FormContainerType.SIMPLE)) {
            return "simple";
        }
        return "multistep";
    }

    private JSONObject _toFragmentInlineValueJSONObject(FragmentInlineValue fragmentInlineValue) {
        if (fragmentInlineValue == null) {
            return null;
        }
        return LocalizedValueUtil.toJSONObject(fragmentInlineValue.getValue_i18n());
    }

    private JSONObject _toMappedLayoutJSONObject(long companyId, ItemExternalReference itemExternalReference, long scopeGroupId) throws PortalException {
        String scopeExternalReferenceCode = ItemScopeUtil.getItemScopeExternalReferenceCode(itemExternalReference.getScope(), scopeGroupId);
        JSONObject jsonObject = JSONUtil.put((String)"externalReferenceCode", (Object)itemExternalReference.getExternalReferenceCode()).put("scopeExternalReferenceCode", scopeExternalReferenceCode);
        Long groupId = ItemScopeUtil.getItemGroupId(companyId, itemExternalReference.getScope(), scopeGroupId);
        if (groupId == null) {
            LogUtil.logOptionalReference(itemExternalReference.getClassName(), itemExternalReference.getExternalReferenceCode(), itemExternalReference.getScope(), scopeGroupId);
            return jsonObject;
        }
        Layout layout = LayoutLocalServiceUtil.fetchLayoutByExternalReferenceCode((String)itemExternalReference.getExternalReferenceCode(), (long)groupId);
        if (layout == null) {
            LogUtil.logOptionalReference(itemExternalReference.getClassName(), itemExternalReference.getExternalReferenceCode(), itemExternalReference.getScope(), scopeGroupId);
            return jsonObject;
        }
        return JSONUtil.put((String)"externalReferenceCode", (Object)itemExternalReference.getExternalReferenceCode()).put("groupId", String.valueOf(layout.getGroupId())).put("layoutId", String.valueOf(layout.getLayoutId())).put("layoutUuid", layout.getUuid()).put("privateLayout", layout.isPrivateLayout()).put("scopeExternalReferenceCode", scopeExternalReferenceCode).put("title", layout.getName(LocaleUtil.getMostRelevantLocale()));
    }

    private JSONObject _toMappedLayoutPageTemplateEntryJSONObject(long companyId, ItemExternalReference itemExternalReference, long scopeGroupId) throws Exception {
        String scopeExternalReferenceCode = ItemScopeUtil.getItemScopeExternalReferenceCode(itemExternalReference.getScope(), scopeGroupId);
        JSONObject jsonObject = JSONUtil.put((String)"layoutPageTemplateEntryExternalReferenceCode", (Object)itemExternalReference.getExternalReferenceCode()).put("layoutPageTemplateEntryScopeExternalReferenceCode", scopeExternalReferenceCode);
        Long groupId = ItemScopeUtil.getItemGroupId(companyId, itemExternalReference.getScope(), scopeGroupId);
        if (groupId == null) {
            LogUtil.logOptionalReference(itemExternalReference.getClassName(), itemExternalReference.getExternalReferenceCode(), itemExternalReference.getScope(), scopeGroupId);
            return jsonObject;
        }
        LayoutPageTemplateEntry layoutPageTemplateEntry = LayoutPageTemplateEntryLocalServiceUtil.fetchLayoutPageTemplateEntryByExternalReferenceCode((String)itemExternalReference.getExternalReferenceCode(), (long)groupId);
        if (layoutPageTemplateEntry == null) {
            LogUtil.logOptionalReference(itemExternalReference.getClassName(), itemExternalReference.getExternalReferenceCode(), itemExternalReference.getScope(), scopeGroupId);
            return jsonObject;
        }
        return JSONUtil.put((String)"displayPage", (Object)(LayoutPageTemplateEntry.class.getSimpleName() + "_" + layoutPageTemplateEntry.getLayoutPageTemplateEntryId())).put("layoutPageTemplateEntryExternalReferenceCode", itemExternalReference.getExternalReferenceCode()).put("layoutPageTemplateEntryScopeExternalReferenceCode", scopeExternalReferenceCode);
    }

    private JSONObject _toSitePageFormContainerSubmissionResultJSONObject(LayoutStructureItemImporterContext layoutStructureItemImporterContext, SitePageFormContainerSubmissionResult sitePageFormContainerSubmissionResult) {
        ItemExternalReference itemExternalReference = sitePageFormContainerSubmissionResult.getItemExternalReference();
        if (itemExternalReference == null) {
            return null;
        }
        return this._toSuccessNotificationMessageJSONObject(sitePageFormContainerSubmissionResult.getSuccessNotificationMessage()).put("layout", () -> this._toMappedLayoutJSONObject(layoutStructureItemImporterContext.getCompanyId(), itemExternalReference, layoutStructureItemImporterContext.getGroupId())).put("type", "page");
    }

    private JSONObject _toStayInPageFormContainerSubmissionResultJSONObject(StayInPageFormContainerSubmissionResult stayInPageFormContainerSubmissionResult) {
        return this._toSuccessNotificationMessageJSONObject(stayInPageFormContainerSubmissionResult.getSuccessNotificationMessage()).put("type", "none");
    }

    private JSONObject _toSuccessNotificationMessageJSONObject(SuccessNotificationMessage successNotificationMessage) {
        if (successNotificationMessage == null) {
            return JSONFactoryUtil.createJSONObject();
        }
        return JSONUtil.put((String)"notificationText", () -> this._toFragmentInlineValueJSONObject(successNotificationMessage.getMessage())).put("showNotification", () -> GetterUtil.getBoolean((Object)successNotificationMessage.getShowNotification()));
    }

    private JSONObject _toURLFormContainerSubmissionResultJSONObject(URLFormContainerSubmissionResult urlFormContainerSubmissionResult) {
        return JSONUtil.put((String)"type", (Object)"url").put("url", () -> this._toFragmentInlineValueJSONObject(urlFormContainerSubmissionResult.getUrl()));
    }
}

