/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.resource.v1_0;

import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.headless.admin.site.dto.v1_0.StyleBook;
import com.liferay.headless.admin.site.internal.resource.v1_0.BaseStyleBookResourceImpl;
import com.liferay.headless.admin.site.resource.v1_0.StyleBookResource;
import com.liferay.headless.admin.user.dto.v1_0.Creator;
import com.liferay.headless.common.spi.service.context.ServiceContextBuilder;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.style.book.model.StyleBookEntry;
import com.liferay.style.book.service.StyleBookEntryService;
import com.liferay.style.book.util.comparator.StyleBookEntryCreateDateComparator;
import com.liferay.style.book.util.comparator.StyleBookEntryNameComparator;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.NotFoundException;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/style-book.properties"}, scope=ServiceScope.PROTOTYPE, service={StyleBookResource.class})
public class StyleBookResourceImpl
extends BaseStyleBookResourceImpl {
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private StyleBookEntryService _styleBookEntryService;
    @Reference
    private UserLocalService _userLocalService;

    @Override
    public void deleteSiteStyleBook(String siteExternalReferenceCode, String styleBookExternalReferenceCode) throws Exception {
        this._checkFeatureFlag();
        StyleBookEntry styleBookEntry = this._getStyleBookEntry(siteExternalReferenceCode, styleBookExternalReferenceCode);
        this._styleBookEntryService.deleteStyleBookEntry(styleBookEntry.getStyleBookEntryId());
    }

    @Override
    public StyleBook getSiteStyleBook(String siteExternalReferenceCode, String styleBookExternalReferenceCode) throws Exception {
        this._checkFeatureFlag();
        return this._toStyleBook(this._getStyleBookEntry(siteExternalReferenceCode, styleBookExternalReferenceCode));
    }

    @Override
    public Page<StyleBook> getSiteStyleBooksPage(String siteExternalReferenceCode, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        this._checkFeatureFlag();
        List styleBookEntries = null;
        long totalCount = 0L;
        long groupId = this._getGroupId(siteExternalReferenceCode);
        OrderByComparator<StyleBookEntry> orderByComparator = this._getStyleBookEntryOrderByComparator(sorts);
        if (Validator.isNull((String)search)) {
            styleBookEntries = this._styleBookEntryService.getStyleBookEntries(groupId, pagination.getStartPosition(), pagination.getEndPosition(), orderByComparator);
            totalCount = this._styleBookEntryService.getStyleBookEntriesCount(groupId);
        } else {
            styleBookEntries = this._styleBookEntryService.getStyleBookEntries(groupId, search, pagination.getStartPosition(), pagination.getEndPosition(), orderByComparator);
            totalCount = this._styleBookEntryService.getStyleBookEntriesCount(groupId, search);
        }
        return Page.of((Map)HashMapBuilder.put((Object)"createBatch", this.addAction("MANAGE_STYLE_BOOK_ENTRIES", "postSiteStyleBookBatch", "com.liferay.style.book", groupId)).build(), this.transform(styleBookEntries, this::_toStyleBook), (Pagination)pagination, (long)totalCount);
    }

    @Override
    public StyleBook postSiteStyleBook(String siteExternalReferenceCode, StyleBook styleBook) throws Exception {
        this._checkFeatureFlag();
        long groupId = this._getGroupId(siteExternalReferenceCode);
        StyleBookEntry styleBookEntry = this._styleBookEntryService.addStyleBookEntry(styleBook.getExternalReferenceCode(), groupId, styleBook.getDefaultStyleBook().booleanValue(), styleBook.getFrontendTokensValues(), styleBook.getName(), styleBook.getKey(), styleBook.getThemeId(), this._getServiceContext(groupId));
        long previewFileEntryId = this._getPreviewFileEntryId(groupId, styleBook.getPreviewFileEntryExternalReferenceCode());
        if (previewFileEntryId != 0L) {
            styleBookEntry = this._styleBookEntryService.updatePreviewFileEntryId(styleBookEntry.getStyleBookEntryId(), previewFileEntryId);
        }
        return this._toStyleBook(styleBookEntry);
    }

    @Override
    public StyleBook putSiteStyleBook(String siteExternalReferenceCode, String styleBookExternalReferenceCode, StyleBook styleBook) throws Exception {
        this._checkFeatureFlag();
        styleBook.setExternalReferenceCode(() -> styleBookExternalReferenceCode);
        StyleBookEntry styleBookEntry = this._styleBookEntryService.fetchStyleBookEntryByExternalReferenceCode(styleBookExternalReferenceCode, this._getGroupId(siteExternalReferenceCode));
        if (styleBookEntry == null) {
            return this.postSiteStyleBook(siteExternalReferenceCode, styleBook);
        }
        return this._toStyleBook(this._styleBookEntryService.updateStyleBookEntry(styleBookEntry.getStyleBookEntryId(), styleBook.getDefaultStyleBook().booleanValue(), styleBook.getFrontendTokensValues(), styleBook.getName(), styleBook.getKey(), this._getPreviewFileEntryId(this._getGroupId(siteExternalReferenceCode), styleBook.getPreviewFileEntryExternalReferenceCode())));
    }

    private void _checkFeatureFlag() {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-56718")) {
            throw new UnsupportedOperationException();
        }
    }

    private long _getGroupId(String siteExternalReferenceCode) {
        Group group = this._groupLocalService.fetchGroupByExternalReferenceCode(siteExternalReferenceCode, this.contextCompany.getCompanyId());
        if (group == null) {
            throw new NotFoundException("Unable to find group with external reference code '" + siteExternalReferenceCode + "'");
        }
        return group.getGroupId();
    }

    private long _getPreviewFileEntryId(long groupId, String previewFileEntryExternalReferenceCode) throws Exception {
        long previewFileEntryId = 0L;
        FileEntry fileEntry = this._dlAppLocalService.fetchFileEntryByExternalReferenceCode(groupId, previewFileEntryExternalReferenceCode);
        if (fileEntry != null) {
            previewFileEntryId = fileEntry.getFileEntryId();
        }
        return previewFileEntryId;
    }

    private ServiceContext _getServiceContext(long groupId) {
        ServiceContext serviceContext = ServiceContextBuilder.create((long)groupId, (HttpServletRequest)this.contextHttpServletRequest, null).build();
        serviceContext.setCompanyId(this.contextCompany.getCompanyId());
        serviceContext.setUserId(this.contextUser.getUserId());
        return serviceContext;
    }

    private StyleBookEntry _getStyleBookEntry(String siteExternalReferenceCode, String styleBookExternalReferenceCode) throws Exception {
        StyleBookEntry styleBookEntry = this._styleBookEntryService.fetchStyleBookEntryByExternalReferenceCode(styleBookExternalReferenceCode, this._getGroupId(siteExternalReferenceCode));
        if (styleBookEntry == null) {
            throw new NotFoundException("Unable to find style book with external reference code " + styleBookExternalReferenceCode);
        }
        return styleBookEntry;
    }

    private OrderByComparator<StyleBookEntry> _getStyleBookEntryOrderByComparator(Sort[] sorts) {
        StyleBookEntryNameComparator orderByComparator = null;
        if (ArrayUtil.isNotEmpty((Object[])sorts)) {
            Sort sort = sorts[0];
            if (StringUtil.equalsIgnoreCase((String)sort.getFieldName(), (String)"name")) {
                orderByComparator = StyleBookEntryNameComparator.getInstance((!sort.isReverse() ? 1 : 0) != 0);
            } else if (StringUtil.equalsIgnoreCase((String)sort.getFieldName(), (String)"dateCreated")) {
                orderByComparator = StyleBookEntryCreateDateComparator.getInstance((!sort.isReverse() ? 1 : 0) != 0);
            } else {
                throw new BadRequestException("Invalid sort field name '" + sort.getFieldName() + "'");
            }
        }
        return orderByComparator;
    }

    private StyleBook _toStyleBook(StyleBookEntry styleBookEntry) {
        StyleBook styleBook = new StyleBook();
        styleBook.setCreator(() -> {
            final User user = this._userLocalService.fetchUser(styleBookEntry.getUserId());
            if (user == null) {
                return null;
            }
            return new Creator(){
                {
                    this.setExternalReferenceCode(() -> ((User)user).getExternalReferenceCode());
                }
            };
        });
        styleBook.setDateCreated(() -> ((StyleBookEntry)styleBookEntry).getCreateDate());
        styleBook.setDateModified(() -> ((StyleBookEntry)styleBookEntry).getModifiedDate());
        styleBook.setDefaultStyleBook(() -> ((StyleBookEntry)styleBookEntry).getDefaultStyleBookEntry());
        styleBook.setExternalReferenceCode(() -> ((StyleBookEntry)styleBookEntry).getExternalReferenceCode());
        styleBook.setFrontendTokensValues(() -> ((StyleBookEntry)styleBookEntry).getFrontendTokensValues());
        styleBook.setKey(() -> ((StyleBookEntry)styleBookEntry).getStyleBookEntryKey());
        styleBook.setName(() -> ((StyleBookEntry)styleBookEntry).getName());
        styleBook.setPreviewFileEntryExternalReferenceCode(() -> {
            long previewFileEntryId = styleBookEntry.getPreviewFileEntryId();
            if (previewFileEntryId == 0L) {
                return null;
            }
            FileEntry fileEntry = this._dlAppLocalService.getFileEntry(previewFileEntryId);
            if (fileEntry == null) {
                return null;
            }
            return fileEntry.getExternalReferenceCode();
        });
        styleBook.setThemeId(() -> ((StyleBookEntry)styleBookEntry).getThemeId());
        return styleBook;
    }
}

