/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.resource.v1_0;

import com.liferay.headless.admin.site.dto.v1_0.AnalyticsConfiguration;
import com.liferay.headless.admin.site.dto.v1_0.GoogleAnalyticsConfiguration;
import com.liferay.headless.admin.site.dto.v1_0.RatingsTypes;
import com.liferay.headless.admin.site.dto.v1_0.Site;
import com.liferay.headless.admin.site.internal.resource.v1_0.BaseSiteResourceImpl;
import com.liferay.headless.admin.site.resource.v1_0.SiteResource;
import com.liferay.layout.util.LayoutServiceContextHelper;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.events.ServicePreAction;
import com.liferay.portal.events.ThemeServicePreAction;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.exception.NoSuchGroupException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.lazy.referencing.LazyReferencingThreadLocal;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.GroupConstants;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.GroupService;
import com.liferay.portal.kernel.service.LayoutSetPrototypeLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.servlet.DummyHttpServletResponse;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.util.comparator.GroupNameComparator;
import com.liferay.portal.liveusers.LiveUsers;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.vulcan.multipart.MultipartBody;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import com.liferay.site.initializer.SiteInitializer;
import com.liferay.site.initializer.SiteInitializerFactory;
import com.liferay.site.initializer.SiteInitializerRegistry;
import com.liferay.site.initializer.SiteInitializerSerializer;
import com.liferay.sites.kernel.util.Sites;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.NotSupportedException;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@CTAware
@Component(properties={"OSGI-INF/liferay/rest/v1_0/site.properties"}, scope=ServiceScope.PROTOTYPE, service={SiteResource.class})
public class SiteResourceImpl
extends BaseSiteResourceImpl {
    private static final String[] _EXCLUDED_TYPE_SETTINGS = new String[]{"GOOGLE_PLACES_API_KEY", "defaultSiteRoleIds", "defaultTeamIds", "googleMapsAPIKey"};
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private GroupService _groupService;
    @Reference
    private LayoutServiceContextHelper _layoutServiceContextHelper;
    @Reference
    private LayoutSetPrototypeLocalService _layoutSetPrototypeLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private SiteInitializerFactory _siteInitializerFactory;
    @Reference
    private SiteInitializerRegistry _siteInitializerRegistry;
    @Reference
    private SiteInitializerSerializer _siteInitializerSerializer;
    @Reference
    private Sites _sites;

    @Override
    public void deleteSite(String externalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-41306")) {
            throw new UnsupportedOperationException();
        }
        Group group = this._groupLocalService.fetchGroupByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (group == null) {
            throw new NoSuchGroupException("No site exists with external reference code " + externalReferenceCode);
        }
        this._groupService.deleteGroup(group.getGroupId());
    }

    @Override
    public Response getSiteSiteInitializer(String externalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-41306") || !FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-19870")) {
            throw new UnsupportedOperationException();
        }
        Group group = this._groupLocalService.getGroupByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        File file = this._siteInitializerSerializer.serialize(group.getGroupId());
        return Response.ok((Object)file).header("Content-Disposition", (Object)("attachment; filename=\"" + file.getName() + "\"")).build();
    }

    @Override
    public Site postSiteSiteInitializer(MultipartBody multipartBody) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-41306")) {
            throw new UnsupportedOperationException();
        }
        Site site = (Site)multipartBody.getValueAsInstance("site", Site.class);
        return this.putSiteSiteInitializer(site.getExternalReferenceCode(), multipartBody);
    }

    @Override
    public Site putSiteSiteInitializer(String externalReferenceCode, MultipartBody multipartBody) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-41306")) {
            throw new UnsupportedOperationException();
        }
        Group group = this._groupLocalService.fetchGroupByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (group != null) {
            if (!group.isSite()) {
                throw new IllegalArgumentException("No site exists with external reference code " + externalReferenceCode);
            }
            GroupPermissionUtil.check((PermissionChecker)PermissionThreadLocal.getPermissionChecker(), (Group)group, (String)"UPDATE");
            group = this._updateGroup(group, (Site)multipartBody.getValueAsInstance("site", Site.class));
            return this._toSite(group);
        }
        group = this._addGroup(externalReferenceCode, (Site)multipartBody.getValueAsInstance("site", Site.class));
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        String name = PrincipalThreadLocal.getName();
        File tempFile = FileUtil.createTempFile((byte[])multipartBody.getBinaryFileAsBytes("file"));
        File tempFolder = FileUtil.createTempFolder();
        FileUtil.unzip((File)tempFile, (File)tempFolder);
        tempFile.delete();
        try (SafeCloseable safeCloseable = CompanyThreadLocal.setCompanyIdWithSafeCloseable((Long)this.contextCompany.getCompanyId());){
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)PermissionCheckerFactoryUtil.create((User)this.contextUser));
            PrincipalThreadLocal.setName((long)this.contextUser.getUserId());
            ServiceContextThreadLocal.pushServiceContext((ServiceContext)this._getServiceContext(group));
            SiteInitializer siteInitializer = this._siteInitializerFactory.create(new File(tempFolder, "site-initializer"), group.getName(LocaleUtil.getDefault()));
            siteInitializer.initialize(group.getGroupId());
        }
        catch (Exception exception) {
            PermissionCacheUtil.clearCache((long[])new long[]{this.contextUser.getUserId()});
            throw exception;
        }
        finally {
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
            PrincipalThreadLocal.setName((String)name);
            ServiceContextThreadLocal.popServiceContext();
            tempFolder.delete();
        }
        Group finalGroup = group;
        return this._toSite(finalGroup);
    }

    @Override
    public void update(Collection<Site> sites, Map<String, Serializable> parameters) throws Exception {
        UnsafeFunction unsafeFunction = null;
        String updateStrategy = (String)((Object)parameters.getOrDefault("updateStrategy", (Serializable)((Object)"UPDATE")));
        if (StringUtil.equalsIgnoreCase((String)updateStrategy, (String)"UPDATE")) {
            unsafeFunction = site -> this.putSite(site.getExternalReferenceCode(), (Site)site);
        }
        if (unsafeFunction == null) {
            throw new NotSupportedException("Update strategy \"" + updateStrategy + "\" is not supported for Site");
        }
        if (this.contextBatchUnsafeBiConsumer != null) {
            this.contextBatchUnsafeBiConsumer.accept(sites, (Object)unsafeFunction);
        } else if (this.contextBatchUnsafeConsumer != null) {
            this.contextBatchUnsafeConsumer.accept(sites, arg_0 -> ((UnsafeFunction)unsafeFunction).apply(arg_0));
        } else {
            for (Site site2 : sites) {
                unsafeFunction.apply((Object)site2);
            }
        }
    }

    @Override
    protected Site doGetSite(String externalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-41306")) {
            throw new UnsupportedOperationException();
        }
        Group group = this._groupLocalService.getGroupByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        return this._toSite(group);
    }

    @Override
    protected Page<Site> doGetSitesPage(Boolean active, String search, Pagination pagination) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-41306")) {
            throw new UnsupportedOperationException();
        }
        long[] classNameIds = new long[]{this._portal.getClassNameId(Company.class.getName()), this._portal.getClassNameId(Group.class.getName())};
        LinkedHashMap params = LinkedHashMapBuilder.put((Object)"active", () -> {
            if (active != null) {
                return GetterUtil.getBoolean((Object)active);
            }
            return null;
        }).put((Object)"site", (Object)true).build();
        return Page.of((Map)HashMapBuilder.put((Object)"create", this.addAction("UPDATE", "postSite", Group.class.getName(), null)).put((Object)"createBatch", this.addAction("UPDATE", "postSiteBatch", Group.class.getName(), null)).put((Object)"deleteBatch", this.addAction("DELETE", "deleteSiteBatch", Group.class.getName(), null)).build(), this.transform(this._groupService.search(this.contextCompany.getCompanyId(), classNameIds, search, null, params, true, pagination.getStartPosition(), pagination.getEndPosition(), (OrderByComparator)new GroupNameComparator()), this::_toSite), (Pagination)pagination, (long)this._groupService.searchCount(this.contextCompany.getCompanyId(), classNameIds, search, params));
    }

    @Override
    protected Site doPostSite(Site site) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-41306")) {
            throw new UnsupportedOperationException();
        }
        Group group = this._addGroup(site.getExternalReferenceCode(), site);
        return this._toSite(group);
    }

    @Override
    protected Site doPutSite(String siteExternalReferenceCode, Site site) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-41306")) {
            throw new UnsupportedOperationException();
        }
        if (site.getExternalReferenceCode() == null) {
            site.setExternalReferenceCode(() -> siteExternalReferenceCode);
        }
        if (!Objects.equals(siteExternalReferenceCode, site.getExternalReferenceCode())) {
            throw new UnsupportedOperationException();
        }
        Group group = this._groupLocalService.fetchGroupByExternalReferenceCode(siteExternalReferenceCode, this.contextCompany.getCompanyId());
        group = group == null ? this._addGroup(siteExternalReferenceCode, site) : this._updateGroup(group, site);
        return this._toSite(group);
    }

    @Override
    protected Long getPermissionCheckerResourceId(String externalReferenceCode) throws Exception {
        Group group = this._groupLocalService.fetchGroupByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        return group.getPrimaryKey();
    }

    @Override
    protected String getPermissionCheckerResourceName(String externalReferenceCode) {
        return Group.class.getName();
    }

    private Group _addGroup(String externalReferenceCode, Site site) throws Exception {
        if (Validator.isNull((String)site.getTemplateKey()) && Validator.isNotNull((Object)site.getTemplateType())) {
            throw new IllegalArgumentException("Template key cannot be empty if template type is specified");
        }
        if (Validator.isNotNull((String)site.getTemplateKey()) && Validator.isNull((Object)site.getTemplateType())) {
            throw new IllegalArgumentException("Template type cannot be empty if template key is specified");
        }
        if (Objects.equals(Site.TemplateType.SITE_INITIALIZER, site.getTemplateType())) {
            SiteInitializer siteInitializer = this._siteInitializerRegistry.getSiteInitializer(site.getTemplateKey());
            if (siteInitializer == null) {
                throw new IllegalArgumentException("No site initializer was found for site template key " + site.getTemplateKey());
            }
            if (!siteInitializer.isActive(this.contextCompany.getCompanyId())) {
                throw new IllegalArgumentException("Site initializer with site template key " + site.getTemplateKey() + " is inactive");
            }
        } else if (Objects.equals(Site.TemplateType.SITE_TEMPLATE, site.getTemplateType())) {
            LayoutSetPrototype layoutSetPrototype = this._layoutSetPrototypeLocalService.fetchLayoutSetPrototype(GetterUtil.getLongStrict((String)site.getTemplateKey()));
            if (layoutSetPrototype == null) {
                throw new IllegalArgumentException("No site template was found for site template key " + site.getTemplateKey());
            }
            if (!layoutSetPrototype.isActive()) {
                throw new IllegalArgumentException("Site template with site template key " + site.getTemplateKey() + " is inactive");
            }
        }
        this._initThemeDisplay();
        try {
            Group group;
            block20: {
                AutoCloseable autoCloseable = this._layoutServiceContextHelper.getServiceContextAutoCloseable(this.contextCompany, this.contextUser);
                try {
                    group = this._addGroup(externalReferenceCode, site, this._getServiceContext());
                    if (autoCloseable == null) break block20;
                }
                catch (Throwable throwable) {
                    try {
                        if (autoCloseable != null) {
                            try {
                                autoCloseable.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        PermissionCacheUtil.clearCache((long[])new long[]{this.contextUser.getUserId()});
                        throw exception;
                    }
                }
                autoCloseable.close();
            }
            return group;
        }
        finally {
            ServiceContextThreadLocal.popServiceContext();
        }
    }

    private Group _addGroup(String externalReferenceCode, Site site, ServiceContext serviceContext) throws Exception {
        Group group = this._groupService.addGroup(externalReferenceCode, this._getParentGroupId(null, site.getParentSiteExternalReferenceCode()), 0L, this._getNameMap(site), this._getDescriptionMap(site), this._getType(site.getMembershipType()), this._getTypeSettings(site, null), this._isManualMembership(site.getManualMembership()), this._getMembershipRestriction(site.getMembershipRestriction()), this._getFriendlyUrlPath(site), true, false, this._isActive(site.getActive()), serviceContext);
        LiveUsers.joinGroup((long)this.contextCompany.getCompanyId(), (long)group.getGroupId(), (long)this.contextUser.getUserId());
        if (Objects.equals(Site.TemplateType.SITE_TEMPLATE, site.getTemplateType())) {
            this._sites.updateLayoutSetPrototypesLinks(group, GetterUtil.getLongStrict((String)site.getTemplateKey()), 0L, true, false);
        } else {
            String siteInitializerKey = "blank-site-initializer";
            if (Validator.isNotNull((String)site.getTemplateKey())) {
                siteInitializerKey = site.getTemplateKey();
            }
            SiteInitializer siteInitializer = this._siteInitializerRegistry.getSiteInitializer(siteInitializerKey);
            siteInitializer.initialize(group.getGroupId());
        }
        return group;
    }

    private Map<Locale, String> _getDescriptionMap(Site site) {
        if (Validator.isNotNull((Object)site.getDescription_i18n())) {
            return LocalizedMapUtil.getLocalizedMap((Map)site.getDescription_i18n());
        }
        if (site.getDescription() == null) {
            return null;
        }
        return HashMapBuilder.put((Object)LocaleUtil.getDefault(), (Object)site.getDescription()).build();
    }

    private String _getFriendlyUrlPath(Site site) {
        Object friendlyUrlPath = site.getFriendlyUrlPath();
        if (Validator.isNotNull((String)friendlyUrlPath) && !((String)friendlyUrlPath).startsWith("/")) {
            friendlyUrlPath = "/" + (String)friendlyUrlPath;
        }
        return friendlyUrlPath;
    }

    private GoogleAnalyticsConfiguration _getGoogleAnalyticsConfiguration(final Group group) {
        return new GoogleAnalyticsConfiguration(){
            {
                this.setGoogleAnalytics4CustomConfig(() -> group.getTypeSettingsProperty("googleAnalytics4CustomConfiguration"));
                this.setGoogleAnalytics4Id(() -> group.getTypeSettingsProperty("googleAnalytics4Id"));
                this.setGoogleAnalyticsCreateCustomConfig(() -> group.getTypeSettingsProperty("googleAnalyticsCreateCustomConfiguration"));
                this.setGoogleAnalyticsCustomConfig(() -> group.getTypeSettingsProperty("googleAnalyticsCustomConfiguration"));
                this.setGoogleAnalyticsId(() -> group.getTypeSettingsProperty("googleAnalyticsId"));
            }
        };
    }

    private int _getMembershipRestriction(Integer membershipRestriction) {
        if (membershipRestriction == null) {
            return 0;
        }
        return membershipRestriction;
    }

    private Map<Locale, String> _getNameMap(Site site) {
        if (Validator.isNotNull((Object)site.getName_i18n())) {
            return LocalizedMapUtil.getLocalizedMap((Map)site.getName_i18n());
        }
        return HashMapBuilder.put((Object)LocaleUtil.getDefault(), (Object)site.getName()).build();
    }

    private long _getParentGroupId(Group group, String parentSiteExternalReferenceCode) {
        if (Validator.isNull((String)parentSiteExternalReferenceCode)) {
            return 0L;
        }
        Group parentGroup = this._groupLocalService.fetchGroupByExternalReferenceCode(parentSiteExternalReferenceCode, this.contextCompany.getCompanyId());
        if (parentGroup == null) {
            return 0L;
        }
        if (!LazyReferencingThreadLocal.isEnabled()) {
            return parentGroup.getGroupId();
        }
        if (group != null) {
            Group currentParentGroup = group.getParentGroup();
            if (currentParentGroup != null && Objects.equals(currentParentGroup.getExternalReferenceCode(), parentSiteExternalReferenceCode)) {
                return currentParentGroup.getGroupId();
            }
            return 0L;
        }
        return parentGroup.getGroupId();
    }

    private RatingsTypes _getRatingsTypes(final Group group) {
        return new RatingsTypes(){
            {
                this.setBlogPosting(() -> RatingsTypes.BlogPosting.create((String)group.getTypeSettingsProperty("com.liferay.blogs.model.BlogsEntry_RatingsType")));
                this.setBookmarksEntry(() -> RatingsTypes.BookmarksEntry.create((String)group.getTypeSettingsProperty("com.liferay.bookmarks.model.BookmarksEntry_RatingsType")));
                this.setComment(() -> RatingsTypes.Comment.create((String)group.getTypeSettingsProperty("com.liferay.message.boards.model.MBDiscussion_RatingsType")));
                this.setDocument(() -> RatingsTypes.Document.create((String)group.getTypeSettingsProperty("com.liferay.document.library.kernel.model.DLFileEntry_RatingsType")));
                this.setKnowledgeBaseArticle(() -> RatingsTypes.KnowledgeBaseArticle.create((String)group.getTypeSettingsProperty("com.liferay.knowledge.base.model.KBArticle_RatingsType")));
                this.setMessageBoardMessage(() -> RatingsTypes.MessageBoardMessage.create((String)group.getTypeSettingsProperty("com.liferay.message.boards.model.MBMessage_RatingsType")));
                this.setSitePage(() -> RatingsTypes.SitePage.create((String)group.getTypeSettingsProperty("com.liferay.portal.kernel.model.Layout_RatingsType")));
                this.setStructuredContent(() -> RatingsTypes.StructuredContent.create((String)group.getTypeSettingsProperty("com.liferay.journal.model.JournalArticle_RatingsType")));
                this.setWikiPage(() -> RatingsTypes.WikiPage.create((String)group.getTypeSettingsProperty("com.liferay.wiki.model.WikiPage_RatingsType")));
            }
        };
    }

    private ServiceContext _getServiceContext() throws PortalException {
        ServiceContext serviceContext = null;
        if (this.contextHttpServletRequest != null) {
            serviceContext = ServiceContextFactory.getInstance((HttpServletRequest)this.contextHttpServletRequest);
        } else {
            serviceContext = new ServiceContext();
            serviceContext.setCompanyId(this.contextCompany.getCompanyId());
            serviceContext.setRequest(this.contextHttpServletRequest);
            serviceContext.setUserId(this.contextUser.getUserId());
        }
        ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
        return serviceContext;
    }

    private ServiceContext _getServiceContext(Group group) throws Exception {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(this.contextCompany.getCompanyId());
        serviceContext.setRequest(this.contextHttpServletRequest);
        serviceContext.setScopeGroupId(group.getGroupId());
        serviceContext.setUserId(this.contextUser.getUserId());
        this._initThemeDisplay();
        return serviceContext;
    }

    private int _getType(Site.MembershipType membershipType) {
        if (membershipType == null) {
            return 2;
        }
        if (membershipType.equals((Object)Site.MembershipType.OPEN)) {
            return 1;
        }
        if (membershipType.equals((Object)Site.MembershipType.PRIVATE)) {
            return 3;
        }
        return 2;
    }

    private String _getTypeSettings(Site site, UnicodeProperties oldUnicodeProperties) {
        UnicodeProperties unicodeProperties = new UnicodeProperties();
        AnalyticsConfiguration analyticsConfiguration = site.getAnalyticsConfiguration();
        if (analyticsConfiguration != null) {
            GoogleAnalyticsConfiguration googleAnalyticsConfiguration = analyticsConfiguration.getGoogleAnalyticsConfiguration();
            if (googleAnalyticsConfiguration != null) {
                unicodeProperties.put("googleAnalytics4CustomConfiguration", googleAnalyticsConfiguration.getGoogleAnalytics4CustomConfig());
                unicodeProperties.put("googleAnalytics4Id", googleAnalyticsConfiguration.getGoogleAnalytics4Id());
                unicodeProperties.put("googleAnalyticsCreateCustomConfiguration", googleAnalyticsConfiguration.getGoogleAnalyticsCreateCustomConfig());
                unicodeProperties.put("googleAnalyticsCustomConfiguration", googleAnalyticsConfiguration.getGoogleAnalyticsCustomConfig());
                unicodeProperties.put("googleAnalyticsId", googleAnalyticsConfiguration.getGoogleAnalyticsId());
            }
            unicodeProperties.put("analytics_matomo", analyticsConfiguration.getMatomoAnalyticsScript());
        }
        unicodeProperties.put("assetAutoTaggingEnabled", String.valueOf(site.getAssetAutoTaggingEnabled()));
        int contentSharingWithChildrenEnabled = -1;
        if (site.getContentSharingWithChildrenEnabled() != null) {
            contentSharingWithChildrenEnabled = site.getContentSharingWithChildrenEnabled() != false ? 3 : 0;
        }
        unicodeProperties.put("contentSharingWithChildrenEnabled", String.valueOf(contentSharingWithChildrenEnabled));
        unicodeProperties.put("languageId", site.getDefaultLanguageId());
        unicodeProperties.put("directoryIndexingEnabled", String.valueOf(site.getDirectoryIndexingEnabled()));
        if (site.getInheritLocales() == null) {
            unicodeProperties.put("inheritLocales", String.valueOf(!unicodeProperties.containsKey((Object)"locales")));
        } else {
            unicodeProperties.put("inheritLocales", String.valueOf(site.getInheritLocales()));
        }
        unicodeProperties.put("locales", StringUtil.merge((Object[])site.getLocales(), (String)","));
        unicodeProperties.put("MAP_PROVIDER_KEY", site.getMapProviderKeyAsString());
        unicodeProperties.put("mentionsEnabled", String.valueOf(site.getMentionsEnabled()));
        RatingsTypes ratingsTypes = site.getRatingsTypes();
        if (ratingsTypes != null) {
            if (ratingsTypes.getBlogPosting() != null) {
                unicodeProperties.put("com.liferay.blogs.model.BlogsEntry_RatingsType", ratingsTypes.getBlogPostingAsString());
            }
            if (ratingsTypes.getBookmarksEntry() != null) {
                unicodeProperties.put("com.liferay.bookmarks.model.BookmarksEntry_RatingsType", ratingsTypes.getBookmarksEntryAsString());
            }
            if (ratingsTypes.getComment() != null) {
                unicodeProperties.put("com.liferay.message.boards.model.MBDiscussion_RatingsType", ratingsTypes.getCommentAsString());
            }
            if (ratingsTypes.getDocument() != null) {
                unicodeProperties.put("com.liferay.document.library.kernel.model.DLFileEntry_RatingsType", ratingsTypes.getDocumentAsString());
            }
            if (ratingsTypes.getKnowledgeBaseArticle() != null) {
                unicodeProperties.put("com.liferay.knowledge.base.model.KBArticle_RatingsType", ratingsTypes.getKnowledgeBaseArticleAsString());
            }
            if (ratingsTypes.getMessageBoardMessage() != null) {
                unicodeProperties.put("com.liferay.message.boards.model.MBMessage_RatingsType", ratingsTypes.getMessageBoardMessageAsString());
            }
            if (ratingsTypes.getSitePage() != null) {
                unicodeProperties.put("com.liferay.portal.kernel.model.Layout_RatingsType", ratingsTypes.getSitePageAsString());
            }
            if (ratingsTypes.getStructuredContent() != null) {
                unicodeProperties.put("com.liferay.journal.model.JournalArticle_RatingsType", ratingsTypes.getStructuredContentAsString());
            }
            if (ratingsTypes.getWikiPage() != null) {
                unicodeProperties.put("com.liferay.wiki.model.WikiPage_RatingsType", ratingsTypes.getWikiPageAsString());
            }
        }
        unicodeProperties.put("sharingEnabled", String.valueOf(site.getSharingEnabled()));
        unicodeProperties.put("trashEnabled", String.valueOf(site.getTrashEnabled()));
        unicodeProperties.put("trashEntriesMaxAge", String.valueOf(site.getTrashEntriesMaxAge()));
        if (oldUnicodeProperties == null) {
            return unicodeProperties.toString();
        }
        for (String excludedTypeSetting : _EXCLUDED_TYPE_SETTINGS) {
            if (!oldUnicodeProperties.containsKey((Object)excludedTypeSetting)) continue;
            unicodeProperties.put(excludedTypeSetting, (String)oldUnicodeProperties.get((Object)excludedTypeSetting));
        }
        return unicodeProperties.toString();
    }

    private void _initThemeDisplay() throws Exception {
        if (this.contextHttpServletRequest == null) {
            return;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this.contextHttpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (themeDisplay != null) {
            return;
        }
        ServicePreAction servicePreAction = new ServicePreAction();
        servicePreAction.servicePre(this.contextHttpServletRequest, this.contextHttpServletResponse, false);
        ThemeServicePreAction themeServicePreAction = new ThemeServicePreAction();
        themeServicePreAction.run(this.contextHttpServletRequest, this.contextHttpServletResponse);
        themeDisplay = (ThemeDisplay)this.contextHttpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        themeDisplay.setResponse((HttpServletResponse)new DummyHttpServletResponse());
    }

    private boolean _isActive(Boolean active) {
        if (active == null) {
            return true;
        }
        return active;
    }

    private boolean _isManualMembership(Boolean manualMembership) {
        if (manualMembership == null) {
            return true;
        }
        return manualMembership;
    }

    private Site _toSite(final Group group) {
        return new Site(){
            {
                this.setActive(() -> ((Group)group).getActive());
                this.setAnalyticsConfiguration(() -> new AnalyticsConfiguration(){
                    {
                        this.setGoogleAnalyticsConfiguration(() -> SiteResourceImpl.this._getGoogleAnalyticsConfiguration(group));
                        this.setMatomoAnalyticsScript(() -> group.getTypeSettingsProperty("analytics_matomo"));
                    }
                });
                this.setAssetAutoTaggingEnabled(() -> Boolean.parseBoolean(group.getTypeSettingsProperty("assetAutoTaggingEnabled")));
                this.setContentSharingWithChildrenEnabled(() -> ((Group)group).isContentSharingWithChildrenEnabled());
                this.setDefaultLanguageId(() -> ((Group)group).getDefaultLanguageId());
                this.setDescription(() -> group.getDescription(LocaleUtil.getDefault()));
                this.setDescription_i18n(() -> LocalizedMapUtil.getI18nMap((Map)group.getDescriptionMap()));
                this.setDescriptiveName(() -> group.getDescriptiveName(LocaleUtil.getDefault()));
                this.setDescriptiveName_i18n(() -> LocalizedMapUtil.getI18nMap((Map)group.getDescriptiveNameMap()));
                this.setDirectoryIndexingEnabled(() -> Boolean.parseBoolean(group.getTypeSettingsProperty("directoryIndexingEnabled")));
                this.setExternalReferenceCode(() -> ((Group)group).getExternalReferenceCode());
                this.setFriendlyUrlPath(() -> ((Group)group).getFriendlyURL());
                this.setId(() -> ((Group)group).getGroupId());
                this.setInheritLocales(() -> Boolean.parseBoolean(group.getTypeSettingsProperty("inheritLocales")));
                this.setKey(() -> ((Group)group).getGroupKey());
                this.setLocales(() -> LocaleUtil.toW3cLanguageIds((String[])StringUtil.split((String)group.getTypeSettingsProperty("locales"))));
                this.setManualMembership(() -> ((Group)group).getManualMembership());
                this.setMapProviderKey(() -> Site.MapProviderKey.create((String)group.getTypeSettingsProperty("MAP_PROVIDER_KEY")));
                this.setMembershipRestriction(() -> ((Group)group).getMembershipRestriction());
                this.setMembershipType(() -> Site.MembershipType.create((String)GroupConstants.getTypeLabel((int)group.getType())));
                this.setMentionsEnabled(() -> Boolean.parseBoolean(group.getTypeSettingsProperty("mentionsEnabled")));
                this.setName(() -> group.getName(LocaleUtil.getDefault()));
                this.setName_i18n(() -> LocalizedMapUtil.getI18nMap((Map)group.getNameMap()));
                this.setParentSiteExternalReferenceCode(() -> {
                    Group parentGroup = SiteResourceImpl.this._groupLocalService.fetchGroup(group.getParentGroupId());
                    if (parentGroup != null) {
                        return parentGroup.getExternalReferenceCode();
                    }
                    return "";
                });
                this.setRatingsTypes(() -> SiteResourceImpl.this._getRatingsTypes(group));
                this.setSharingEnabled(() -> Boolean.parseBoolean(group.getTypeSettingsProperty("sharingEnabled")));
                this.setTrashEnabled(() -> Boolean.parseBoolean(group.getTypeSettingsProperty("trashEnabled")));
                this.setTrashEntriesMaxAge(() -> GetterUtil.getInteger((String)group.getTypeSettingsProperty("trashEntriesMaxAge")));
            }
        };
    }

    private Group _updateGroup(Group group, Site site) throws Exception {
        try {
            Group group2;
            block11: {
                AutoCloseable autoCloseable = this._layoutServiceContextHelper.getServiceContextAutoCloseable(this.contextCompany, this.contextUser);
                try {
                    Group updatedGroup = this._groupLocalService.updateGroup(group.getGroupId(), this._getParentGroupId(group, site.getParentSiteExternalReferenceCode()), this._getNameMap(site), this._getDescriptionMap(site), this._getType(site.getMembershipType()), this._getTypeSettings(site, group.getTypeSettingsProperties()), this._isManualMembership(site.getManualMembership()), this._getMembershipRestriction(site.getMembershipRestriction()), this._getFriendlyUrlPath(site), false, this._isActive(site.getActive()), this._getServiceContext());
                    LiveUsers.joinGroup((long)this.contextCompany.getCompanyId(), (long)updatedGroup.getGroupId(), (long)this.contextUser.getUserId());
                    group2 = updatedGroup;
                    if (autoCloseable == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (autoCloseable != null) {
                            try {
                                autoCloseable.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        PermissionCacheUtil.clearCache((long[])new long[]{this.contextUser.getUserId()});
                        throw exception;
                    }
                }
                autoCloseable.close();
            }
            return group2;
        }
        finally {
            ServiceContextThreadLocal.popServiceContext();
        }
    }
}

