/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.dto.v1_0.util;

import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class LocalizedValueUtil {
    public static JSONObject toJSONObject(Map<String, String> localizedValues) {
        return LocalizedValueUtil.toJSONObject(localizedValues, value -> value);
    }

    public static <T, R, E extends Throwable> JSONObject toJSONObject(Map<String, T> localizedValues, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        if (localizedValues == null) {
            return null;
        }
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        Set availableLocales = LanguageUtil.getAvailableLocales();
        for (Map.Entry<String, T> entry : localizedValues.entrySet()) {
            Locale locale = LocaleUtil.fromLanguageId((String)entry.getKey(), (boolean)true, (boolean)false);
            if (locale == null || !availableLocales.contains(locale)) continue;
            jsonObject.put(LocaleUtil.toLanguageId((Locale)locale), unsafeFunction.apply(entry.getValue()));
        }
        return jsonObject;
    }

    public static Map<String, String> toLocalizedValues(JSONObject jsonObject) {
        return LocalizedValueUtil.toLocalizedValues(jsonObject, key -> jsonObject.getString(key));
    }

    public static <R, E extends Throwable> Map<String, R> toLocalizedValues(final JSONObject jsonObject, final UnsafeFunction<String, R, E> unsafeFunction) throws E {
        if (jsonObject == null) {
            return null;
        }
        return new HashMap<String, R>(){
            {
                Set availableLocales = LanguageUtil.getAvailableLocales();
                for (String key : jsonObject.keySet()) {
                    Locale locale = LocaleUtil.fromLanguageId((String)key, (boolean)true, (boolean)false);
                    if (locale == null || !availableLocales.contains(locale)) continue;
                    this.put(LocaleUtil.toBCP47LanguageId((String)key), unsafeFunction.apply((Object)key));
                }
            }
        };
    }
}

