/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.dto.v1_0.util;

import com.liferay.headless.admin.site.dto.v1_0.FragmentViewport;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.FragmentViewportStyleUtil;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.ViewportIdUtil;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class FragmentViewportUtil {
    public static FragmentViewport[] toFragmentViewports(final JSONObject jsonObject) {
        if (JSONUtil.isEmpty((JSONObject)jsonObject)) {
            return null;
        }
        ArrayList<FragmentViewport> fragmentViewports = new ArrayList<FragmentViewport>(){
            {
                FragmentViewport fragmentViewport = FragmentViewportUtil._toFragmentViewport(FragmentViewport.Id.DESKTOP, jsonObject);
                if (fragmentViewport != null) {
                    this.add(fragmentViewport);
                }
                if ((fragmentViewport = FragmentViewportUtil._toFragmentViewport(FragmentViewport.Id.LANDSCAPE_MOBILE, jsonObject)) != null) {
                    this.add(fragmentViewport);
                }
                if ((fragmentViewport = FragmentViewportUtil._toFragmentViewport(FragmentViewport.Id.PORTRAIT_MOBILE, jsonObject)) != null) {
                    this.add(fragmentViewport);
                }
                if ((fragmentViewport = FragmentViewportUtil._toFragmentViewport(FragmentViewport.Id.TABLET, jsonObject)) != null) {
                    this.add(fragmentViewport);
                }
            }
        };
        if (ListUtil.isEmpty((List)fragmentViewports)) {
            return null;
        }
        return fragmentViewports.toArray(new FragmentViewport[0]);
    }

    public static JSONObject toFragmentViewportsJSONObject(FragmentViewport[] fragmentViewports) throws JSONException {
        if (ArrayUtil.isEmpty((Object[])fragmentViewports)) {
            return null;
        }
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        for (FragmentViewport fragmentViewport : fragmentViewports) {
            String customCSS = fragmentViewport.getCustomCSS();
            if (Validator.isNull((Object)fragmentViewport.getId()) || Validator.isNull((String)customCSS) && fragmentViewport.getFragmentViewportStyle() == null) continue;
            JSONObject viewportJSONObject = JSONUtil.put((String)"customCSS", (Object)customCSS).put("styles", FragmentViewportStyleUtil.toJSONObject(fragmentViewport.getFragmentViewportStyle()));
            if (Objects.equals(fragmentViewport.getId(), FragmentViewport.Id.DESKTOP)) {
                jsonObject = JSONUtil.merge((JSONObject)jsonObject, (JSONObject)viewportJSONObject);
                continue;
            }
            jsonObject.put(ViewportIdUtil.toInternalValue(fragmentViewport.getId().getValue()), viewportJSONObject);
        }
        return jsonObject;
    }

    private static JSONObject _getViewportJSONObject(FragmentViewport.Id fragmentViewportId, JSONObject jsonObject) {
        if (Objects.equals(fragmentViewportId, FragmentViewport.Id.DESKTOP)) {
            return jsonObject;
        }
        String viewportId = ViewportIdUtil.toInternalValue(fragmentViewportId.getValue());
        if (!jsonObject.has(viewportId)) {
            return null;
        }
        return jsonObject.getJSONObject(viewportId);
    }

    private static FragmentViewport _toFragmentViewport(final FragmentViewport.Id fragmentViewportId, JSONObject jsonObject) {
        final JSONObject viewportJSONObject = FragmentViewportUtil._getViewportJSONObject(fragmentViewportId, jsonObject);
        if (JSONUtil.isEmpty((JSONObject)viewportJSONObject) || Validator.isNull((String)viewportJSONObject.getString("customCSS", null)) && JSONUtil.isEmpty((JSONObject)viewportJSONObject.getJSONObject("styles"))) {
            return null;
        }
        return new FragmentViewport(){
            {
                this.setCustomCSS(() -> viewportJSONObject.getString("customCSS", null));
                this.setFragmentViewportStyle(() -> FragmentViewportStyleUtil.toFragmentViewportStyle(viewportJSONObject.getJSONObject("styles")));
                this.setId(() -> fragmentViewportId);
            }
        };
    }
}

