/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.dto.v1_0.converter;

import com.liferay.fragment.contributor.util.FragmentCollectionContributorRegistryUtil;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.service.FragmentEntryLocalService;
import com.liferay.headless.admin.site.dto.v1_0.DefaultFragmentReference;
import com.liferay.headless.admin.site.dto.v1_0.DropZonePageElementDefinition;
import com.liferay.headless.admin.site.dto.v1_0.FragmentItemExternalReference;
import com.liferay.headless.admin.site.dto.v1_0.FragmentReference;
import com.liferay.headless.admin.site.dto.v1_0.PageElementDefinition;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.ItemScopeUtil;
import com.liferay.layout.util.structure.DropZoneLayoutStructureItem;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.scope.Scope;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.layout.util.structure.DropZoneLayoutStructureItem"}, service={DTOConverter.class})
public class DropZonePageElementDefinitionDTOConverter
implements DTOConverter<DropZoneLayoutStructureItem, DropZonePageElementDefinition> {
    @Reference
    private FragmentEntryLocalService _fragmentEntryLocalService;

    public String getContentType() {
        return DropZonePageElementDefinition.class.getSimpleName();
    }

    public DropZonePageElementDefinition toDTO(DTOConverterContext dtoConverterContext, DropZoneLayoutStructureItem dropZoneLayoutStructureItem) throws Exception {
        Long companyId = (Long)dtoConverterContext.getAttribute("companyId");
        Long scopeGroupId = (Long)dtoConverterContext.getAttribute("scopeGroupId");
        if (companyId == null || scopeGroupId == null) {
            throw new UnsupportedOperationException();
        }
        DropZonePageElementDefinition dropZonePageElementDefinition = new DropZonePageElementDefinition();
        dropZonePageElementDefinition.setAddNewFragmentEntries(() -> ((DropZoneLayoutStructureItem)dropZoneLayoutStructureItem).isAllowNewFragmentEntries());
        dropZonePageElementDefinition.setAllowedFragmentReferences(() -> this._getFragmentReferences((long)companyId, dropZoneLayoutStructureItem, (long)scopeGroupId));
        dropZonePageElementDefinition.setType(PageElementDefinition.Type.DROP_ZONE);
        return dropZonePageElementDefinition;
    }

    private FragmentReference[] _getFragmentReferences(List<String> fragmentEntryKeys, long scopeGroupId) throws Exception {
        ArrayList<Object> fragmentReferences = new ArrayList<Object>();
        for (String fragmentEntryKey : fragmentEntryKeys) {
            FragmentEntry fragmentEntry = FragmentCollectionContributorRegistryUtil.getFragmentEntry((String)fragmentEntryKey);
            if (fragmentEntry != null) {
                fragmentReferences.add(this._toDefaultFragmentReference(fragmentEntryKey));
                continue;
            }
            fragmentEntry = this._fragmentEntryLocalService.fetchFragmentEntry(scopeGroupId, fragmentEntryKey);
            if (fragmentEntry == null) continue;
            fragmentReferences.add(this._toFragmentItemExternalReference(fragmentEntry.getExternalReferenceCode(), ItemScopeUtil.getItemScope(fragmentEntry.getGroupId(), scopeGroupId)));
        }
        return fragmentReferences.toArray(new FragmentReference[0]);
    }

    private FragmentReference[] _getFragmentReferences(long companyId, DropZoneLayoutStructureItem dropZoneLayoutStructureItem, long scopeGroupId) throws Exception {
        if (dropZoneLayoutStructureItem.getFragmentEntryKeys() != null) {
            return this._getFragmentReferences(dropZoneLayoutStructureItem.getFragmentEntryKeys(), scopeGroupId);
        }
        if (dropZoneLayoutStructureItem.getFragmentEntriesJSONArray() != null) {
            return this._getFragmentReferences(companyId, dropZoneLayoutStructureItem.getFragmentEntriesJSONArray(), scopeGroupId);
        }
        return null;
    }

    private FragmentReference[] _getFragmentReferences(long companyId, JSONArray fragmentEntriesJSONArray, long scopeGroupId) {
        ArrayList<Object> fragmentReferences = new ArrayList<Object>();
        for (int i = 0; i < fragmentEntriesJSONArray.length(); ++i) {
            JSONObject jsonObject = fragmentEntriesJSONArray.getJSONObject(i);
            if (jsonObject.has("fragmentEntryERC")) {
                fragmentReferences.add(this._toFragmentItemExternalReference(jsonObject.getString("fragmentEntryERC"), ItemScopeUtil.getItemScope(companyId, jsonObject.getString("fragmentEntryScopeERC"), scopeGroupId)));
                continue;
            }
            if (!jsonObject.has("fragmentEntryRendererKey")) continue;
            fragmentReferences.add(this._toDefaultFragmentReference(jsonObject.getString("fragmentEntryRendererKey")));
        }
        return fragmentReferences.toArray(new FragmentReference[0]);
    }

    private DefaultFragmentReference _toDefaultFragmentReference(String defaultFragmentKey) {
        DefaultFragmentReference defaultFragmentReference = new DefaultFragmentReference();
        defaultFragmentReference.setDefaultFragmentKey(() -> defaultFragmentKey);
        defaultFragmentReference.setFragmentReferenceType(() -> FragmentReference.FragmentReferenceType.DEFAULT_FRAGMENT_REFERENCE);
        return defaultFragmentReference;
    }

    private FragmentItemExternalReference _toFragmentItemExternalReference(String externalReferenceCode, Scope scope) {
        FragmentItemExternalReference fragmentItemExternalReference = new FragmentItemExternalReference();
        fragmentItemExternalReference.setExternalReferenceCode(() -> externalReferenceCode);
        fragmentItemExternalReference.setFragmentReferenceType(() -> FragmentReference.FragmentReferenceType.FRAGMENT_ITEM_EXTERNAL_REFERENCE);
        fragmentItemExternalReference.setScope(() -> scope);
        return fragmentItemExternalReference;
    }
}

