/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.util;

import com.liferay.headless.admin.site.dto.v1_0.ItemExternalReference;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.scope.Scope;

public class LogUtil {
    private static final Log _log = LogFactoryUtil.getLog(LogUtil.class);

    public static void logOptionalReference(Class<?> modelClass, String modelExternalReferenceCode, long scopeId) {
        if (_log.isWarnEnabled()) {
            StringBundler sb = new StringBundler(6);
            sb.append("Optional reference generated for missing ");
            sb.append(modelClass.getSimpleName());
            sb.append(" with external reference code ");
            sb.append(modelExternalReferenceCode);
            sb.append(" and scope ID ");
            sb.append(scopeId);
            _log.warn((Object)sb.toString());
        }
    }

    public static void logOptionalReference(ItemExternalReference itemExternalReference, long scopeId) {
        LogUtil.logOptionalReference(itemExternalReference.getClassName(), itemExternalReference.getExternalReferenceCode(), itemExternalReference.getScope(), scopeId);
    }

    public static void logOptionalReference(String className, String externalReferenceCode, Scope scope, long scopeId) {
        if (_log.isWarnEnabled()) {
            StringBundler sb = new StringBundler(7);
            sb.append("Optional reference generated for missing entity with ");
            sb.append("class name ");
            sb.append(className);
            sb.append(", external reference code ");
            sb.append(externalReferenceCode);
            if (scope != null && Validator.isNotNull((String)scope.getExternalReferenceCode())) {
                sb.append(", and scope external reference code ");
                sb.append(scope.getExternalReferenceCode());
            } else {
                sb.append(", and null scope with current scope ID ");
                sb.append(scopeId);
            }
            _log.warn((Object)sb.toString());
        }
    }
}

