/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.resource.v1_0.layout.structure.item.importer;

import com.liferay.headless.admin.site.dto.v1_0.GridPageElementDefinition;
import com.liferay.headless.admin.site.dto.v1_0.GridViewport;
import com.liferay.headless.admin.site.dto.v1_0.GridViewportDefinition;
import com.liferay.headless.admin.site.dto.v1_0.PageElement;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.ViewportIdUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.layout.structure.item.importer.LayoutStructureItemImporter;
import com.liferay.headless.admin.site.internal.resource.v1_0.layout.structure.item.importer.context.LayoutStructureItemImporterContext;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.LayoutStructureUtil;
import com.liferay.layout.converter.VerticalAlignmentConverter;
import com.liferay.layout.responsive.ViewportSize;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.layout.util.structure.RowStyledLayoutStructureItem;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Objects;

public class RowLayoutStructureItemImporter
implements LayoutStructureItemImporter {
    @Override
    public LayoutStructureItem addLayoutStructureItem(LayoutStructure layoutStructure, LayoutStructureItemImporterContext layoutStructureItemImporterContext, PageElement pageElement) throws Exception {
        RowStyledLayoutStructureItem rowStyledLayoutStructureItem = (RowStyledLayoutStructureItem)layoutStructure.addLayoutStructureItem(pageElement.getExternalReferenceCode(), "row", LayoutStructureUtil.getParentExternalReferenceCode(pageElement, layoutStructure), pageElement.getPosition().intValue());
        GridPageElementDefinition gridPageElementDefinition = (GridPageElementDefinition)pageElement.getPageElementDefinition();
        if (gridPageElementDefinition == null) {
            return rowStyledLayoutStructureItem;
        }
        rowStyledLayoutStructureItem.setCssClasses(this._getCssClasses(gridPageElementDefinition.getCssClasses()));
        rowStyledLayoutStructureItem.setCustomCSS(gridPageElementDefinition.getCustomCSS());
        rowStyledLayoutStructureItem.setGutters(GetterUtil.getBoolean((Object)gridPageElementDefinition.getGutters(), (boolean)Boolean.TRUE));
        rowStyledLayoutStructureItem.setIndexed(GetterUtil.getBoolean((Object)gridPageElementDefinition.getIndexed(), (boolean)Boolean.TRUE));
        rowStyledLayoutStructureItem.setModulesPerRow(GetterUtil.getInteger((Object)gridPageElementDefinition.getModulesPerRow(), (int)1));
        rowStyledLayoutStructureItem.setName(gridPageElementDefinition.getName());
        rowStyledLayoutStructureItem.setNumberOfColumns(GetterUtil.getInteger((Object)gridPageElementDefinition.getNumberOfModules(), (int)1));
        Object[] gridViewports = gridPageElementDefinition.getGridViewports();
        if (ArrayUtil.isEmpty((Object[])gridViewports)) {
            rowStyledLayoutStructureItem.updateItemConfig(JSONUtil.put((String)ViewportSize.MOBILE_LANDSCAPE.getViewportSizeId(), (Object)JSONUtil.put((String)"modulesPerRow", (Object)1)));
        } else {
            this._updateItemConfig(JSONUtil.put((String)"modulesPerRow", (Object)1), GridViewport.Id.LANDSCAPE_MOBILE, (GridViewport[])gridViewports, rowStyledLayoutStructureItem);
            this._updateItemConfig(JSONFactoryUtil.createJSONObject(), GridViewport.Id.PORTRAIT_MOBILE, (GridViewport[])gridViewports, rowStyledLayoutStructureItem);
            this._updateItemConfig(JSONFactoryUtil.createJSONObject(), GridViewport.Id.TABLET, (GridViewport[])gridViewports, rowStyledLayoutStructureItem);
        }
        rowStyledLayoutStructureItem.setVerticalAlignment(VerticalAlignmentConverter.convertToInternalValue((String)GetterUtil.getString((String)gridPageElementDefinition.getVerticalAlignmentAsString(), (String)"top")));
        return rowStyledLayoutStructureItem;
    }

    private LinkedHashSet<String> _getCssClasses(String[] cssClasses) {
        if (cssClasses == null) {
            return null;
        }
        return new LinkedHashSet<String>(Arrays.asList(cssClasses));
    }

    private GridViewport _getGridViewport(GridViewport.Id gridViewportId, GridViewport[] gridViewports) {
        for (GridViewport gridViewport : gridViewports) {
            if (!Objects.equals(gridViewportId, gridViewport.getId())) continue;
            return gridViewport;
        }
        return null;
    }

    private JSONObject _toViewportJSONObject(GridViewport gridViewport) {
        if (gridViewport == null) {
            return JSONFactoryUtil.createJSONObject();
        }
        GridViewportDefinition gridViewportDefinition = gridViewport.getGridViewportDefinition();
        if (Validator.isNull((String)gridViewport.getCustomCSS()) && (gridViewportDefinition == null || gridViewportDefinition.getModulesPerRow() == null && gridViewportDefinition.getVerticalAlignment() == null)) {
            return JSONFactoryUtil.createJSONObject();
        }
        return JSONUtil.put((String)"customCSS", () -> ((GridViewport)gridViewport).getCustomCSS()).put("modulesPerRow", () -> {
            if (gridViewportDefinition == null) {
                return null;
            }
            return gridViewportDefinition.getModulesPerRow();
        }).put("verticalAlignment", () -> {
            if (gridViewportDefinition == null) {
                return null;
            }
            GridViewportDefinition.VerticalAlignment verticalAlignment = gridViewportDefinition.getVerticalAlignment();
            if (verticalAlignment == null) {
                return null;
            }
            return VerticalAlignmentConverter.convertToInternalValue((String)verticalAlignment.getValue());
        });
    }

    private void _updateItemConfig(JSONObject defaultViewportJSONObject, GridViewport.Id gridViewportId, GridViewport[] gridViewports, RowStyledLayoutStructureItem rowStyledLayoutStructureItem) {
        GridViewport gridViewport = this._getGridViewport(gridViewportId, gridViewports);
        String viewportId = ViewportIdUtil.toInternalValue(gridViewportId.getValue());
        if (gridViewport != null) {
            rowStyledLayoutStructureItem.updateItemConfig(JSONUtil.put((String)viewportId, (Object)this._toViewportJSONObject(gridViewport)));
        } else {
            rowStyledLayoutStructureItem.updateItemConfig(JSONUtil.put((String)viewportId, (Object)defaultViewportJSONObject));
        }
    }
}

