/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.dto.v1_0.util;

import com.liferay.headless.admin.site.dto.v1_0.FragmentLink;
import com.liferay.headless.admin.site.dto.v1_0.FragmentLinkInlineValue;
import com.liferay.headless.admin.site.dto.v1_0.FragmentLinkMappedValue;
import com.liferay.headless.admin.site.dto.v1_0.FragmentLinkValue;
import com.liferay.headless.admin.site.dto.v1_0.FragmentMappedValueItemReference;
import com.liferay.headless.admin.site.dto.v1_0.Mapping;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.FragmentMappingUtil;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.LocalizedValueUtil;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.TargetUtil;
import com.liferay.info.item.InfoItemServiceRegistry;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

public class FragmentLinkUtil {
    public static FragmentLink toFragmentLink(final long companyId, final InfoItemServiceRegistry infoItemServiceRegistry, final JSONObject jsonObject, final long scopeGroupId) {
        if (jsonObject == null) {
            return null;
        }
        final boolean mappedValue = FragmentMappingUtil.isMappedValue(jsonObject);
        if (jsonObject.isNull("href") && !mappedValue) {
            return null;
        }
        return new FragmentLink(){
            {
                this.setTarget(() -> {
                    String target = jsonObject.getString("target");
                    if (Validator.isNull((String)target)) {
                        return null;
                    }
                    if (StringUtil.equalsIgnoreCase((String)target, (String)"_parent") || StringUtil.equalsIgnoreCase((String)target, (String)"_top")) {
                        target = "_self";
                    }
                    return FragmentLink.Target.create((String)TargetUtil.toExternalValue(target));
                });
                this.setValue(() -> FragmentLinkUtil._toFragmentLinkValue(companyId, infoItemServiceRegistry, jsonObject, mappedValue, scopeGroupId));
            }
        };
    }

    public static JSONObject toJSONObject(long companyId, FragmentLink fragmentLink, InfoItemServiceRegistry infoItemServiceRegistry, long scopeGroupId) throws PortalException {
        if (fragmentLink == null || fragmentLink.getValue() == null) {
            return null;
        }
        FragmentLinkValue fragmentLinkValue = fragmentLink.getValue();
        if (fragmentLinkValue == null) {
            return null;
        }
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        if (fragmentLinkValue instanceof FragmentLinkInlineValue) {
            FragmentLinkInlineValue fragmentLinkInlineValue = (FragmentLinkInlineValue)fragmentLinkValue;
            jsonObject.put("href", LocalizedValueUtil.toJSONObject(fragmentLinkInlineValue.getValue_i18n()));
        } else {
            FragmentLinkMappedValue fragmentLinkMappedValue = (FragmentLinkMappedValue)fragmentLinkValue;
            jsonObject = FragmentMappingUtil.getFragmentMappedValueJSONObject(companyId, infoItemServiceRegistry, fragmentLinkMappedValue.getMapping(), scopeGroupId);
            if (jsonObject == null) {
                return null;
            }
        }
        FragmentLink.Target target = fragmentLink.getTarget();
        if (target != null) {
            jsonObject.put("target", TargetUtil.toInternalValue(target.getValue()));
        }
        return jsonObject;
    }

    private static FragmentLinkMappedValue _toFragmentLinkMappedValue(long companyId, InfoItemServiceRegistry infoItemServiceRegistry, final JSONObject jsonObject, long scopeGroupId) throws Exception {
        final FragmentMappedValueItemReference fragmentMappedValueItemReference = FragmentMappingUtil.getFragmentMappedValueItemReference(companyId, infoItemServiceRegistry, jsonObject, scopeGroupId);
        if (fragmentMappedValueItemReference == null) {
            return null;
        }
        FragmentLinkMappedValue fragmentLinkMappedValue = new FragmentLinkMappedValue();
        fragmentLinkMappedValue.setMapping(() -> new Mapping(){
            {
                this.setFieldKey(() -> FragmentMappingUtil.getFieldKey(jsonObject));
                this.setItemReference(() -> fragmentMappedValueItemReference);
            }
        });
        fragmentLinkMappedValue.setType(() -> FragmentLinkValue.Type.FRAGMENT_MAPPED_VALUE);
        return fragmentLinkMappedValue;
    }

    private static FragmentLinkValue _toFragmentLinkValue(long companyId, InfoItemServiceRegistry infoItemServiceRegistry, JSONObject jsonObject, boolean mappedValue, long scopeGroupId) throws Exception {
        if (mappedValue) {
            return FragmentLinkUtil._toFragmentLinkMappedValue(companyId, infoItemServiceRegistry, jsonObject, scopeGroupId);
        }
        FragmentLinkInlineValue fragmentLinkInlineValue = new FragmentLinkInlineValue();
        fragmentLinkInlineValue.setValue_i18n(() -> LocalizedValueUtil.toLocalizedValues(jsonObject.getJSONObject("href")));
        fragmentLinkInlineValue.setType(() -> FragmentLinkValue.Type.FRAGMENT_INLINE_VALUE);
        return fragmentLinkInlineValue;
    }
}

