/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.resource.v1_0;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.headless.admin.site.dto.v1_0.NavigationMenu;
import com.liferay.headless.admin.site.dto.v1_0.NavigationMenuItem;
import com.liferay.headless.admin.site.internal.odata.entity.v1_0.NavigationMenuEntityModel;
import com.liferay.headless.admin.site.internal.resource.v1_0.BaseNavigationMenuResourceImpl;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.GroupUtil;
import com.liferay.headless.admin.site.resource.v1_0.NavigationMenuResource;
import com.liferay.headless.admin.user.dto.v1_0.Creator;
import com.liferay.headless.common.spi.service.context.ServiceContextBuilder;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.PermissionService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.custom.field.CustomField;
import com.liferay.portal.vulcan.custom.field.CustomFieldsUtil;
import com.liferay.portal.vulcan.fields.NestedFieldsSupplier;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.permission.Permission;
import com.liferay.portal.vulcan.permission.PermissionUtil;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import com.liferay.portal.vulcan.util.SearchUtil;
import com.liferay.site.navigation.model.SiteNavigationMenu;
import com.liferay.site.navigation.model.SiteNavigationMenuItem;
import com.liferay.site.navigation.service.SiteNavigationMenuItemService;
import com.liferay.site.navigation.service.SiteNavigationMenuLocalService;
import com.liferay.site.navigation.service.SiteNavigationMenuService;
import com.liferay.site.navigation.util.comparator.SiteNavigationMenuItemOrderComparator;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/navigation-menu.properties"}, scope=ServiceScope.PROTOTYPE, service={NavigationMenuResource.class})
public class NavigationMenuResourceImpl
extends BaseNavigationMenuResourceImpl {
    private static final EntityModel _entityModel = new NavigationMenuEntityModel();
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private PermissionService _permissionService;
    @Reference
    private ResourceActionLocalService _resourceActionLocalService;
    @Reference
    private SiteNavigationMenuItemService _siteNavigationMenuItemService;
    @Reference
    private SiteNavigationMenuLocalService _siteNavigationMenuLocalService;
    @Reference
    private SiteNavigationMenuService _siteNavigationMenuService;
    @Reference
    private UserLocalService _userLocalService;

    @Override
    public void deleteSiteNavigationMenu(String siteExternalReferenceCode, String navigationMenuExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-66179")) {
            throw new UnsupportedOperationException();
        }
        this._siteNavigationMenuService.deleteSiteNavigationMenu(navigationMenuExternalReferenceCode, GroupUtil.getGroupId(true, this.contextCompany.getCompanyId(), siteExternalReferenceCode));
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return _entityModel;
    }

    @Override
    protected NavigationMenu doGetSiteNavigationMenu(String siteExternalReferenceCode, String navigationMenuExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-66179")) {
            throw new UnsupportedOperationException();
        }
        return this._toNavigationMenu(this._siteNavigationMenuService.getSiteNavigationMenuByExternalReferenceCode(navigationMenuExternalReferenceCode, GroupUtil.getGroupId(true, this.contextCompany.getCompanyId(), siteExternalReferenceCode)));
    }

    @Override
    protected Page<NavigationMenu> doGetSiteNavigationMenusPage(String siteExternalReferenceCode, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-66179")) {
            throw new UnsupportedOperationException();
        }
        long groupId = GroupUtil.getGroupId(true, this.contextCompany.getCompanyId(), siteExternalReferenceCode);
        return SearchUtil.search((Map)HashMapBuilder.put((Object)"create", this.addAction("ADD_SITE_NAVIGATION_MENU", "postSiteNavigationMenu", "com.liferay.site.navigation", groupId)).put((Object)"createBatch", this.addAction("ADD_SITE_NAVIGATION_MENU", "postSiteNavigationMenuBatch", "com.liferay.site.navigation", groupId)).build(), booleanQuery -> {}, (Filter)filter, (String)SiteNavigationMenu.class.getName(), (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
            searchContext.setGroupIds(new long[]{groupId});
        }, (Sort[])sorts, document -> this._toNavigationMenu(this._siteNavigationMenuService.fetchSiteNavigationMenu(GetterUtil.getLong((String)document.get("entryClassPK")))));
    }

    @Override
    protected NavigationMenu doPostSiteNavigationMenu(String siteExternalReferenceCode, NavigationMenu navigationMenu) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-66179")) {
            throw new UnsupportedOperationException();
        }
        return this._addNavigationMenu(navigationMenu.getExternalReferenceCode(), GroupUtil.getGroupId(true, this.contextCompany.getCompanyId(), siteExternalReferenceCode), navigationMenu);
    }

    @Override
    protected NavigationMenu doPutSiteNavigationMenu(String siteExternalReferenceCode, String navigationMenuExternalReferenceCode, NavigationMenu navigationMenu) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-66179")) {
            throw new UnsupportedOperationException();
        }
        long groupId = GroupUtil.getGroupId(true, this.contextCompany.getCompanyId(), siteExternalReferenceCode);
        SiteNavigationMenu siteNavigationMenu = this._siteNavigationMenuLocalService.fetchSiteNavigationMenuByExternalReferenceCode(navigationMenuExternalReferenceCode, groupId);
        if (siteNavigationMenu != null) {
            return this._updateNavigationMenu(navigationMenu, siteNavigationMenu);
        }
        return this._addNavigationMenu(navigationMenuExternalReferenceCode, groupId, navigationMenu);
    }

    @Override
    protected Long getPermissionCheckerResourceId(String groupExternalReferenceCode, String externalReferenceCode) throws Exception {
        SiteNavigationMenu siteNavigationMenu = this._siteNavigationMenuService.getSiteNavigationMenuByExternalReferenceCode(externalReferenceCode, this.getPermissionCheckerGroupId(groupExternalReferenceCode).longValue());
        return siteNavigationMenu.getPrimaryKey();
    }

    @Override
    protected String getPermissionCheckerResourceName(String groupExternalReferenceCode, String externalReferenceCode) {
        return SiteNavigationMenu.class.getName();
    }

    private NavigationMenu _addNavigationMenu(String externalReferenceCode, long groupId, NavigationMenu navigationMenu) throws Exception {
        SiteNavigationMenu siteNavigationMenu = this._siteNavigationMenuService.addSiteNavigationMenu(externalReferenceCode, groupId, navigationMenu.getName(), this._getNavigationMenuType(navigationMenu), this._isAuto(navigationMenu.getAuto()), ServiceContextBuilder.create((long)groupId, (HttpServletRequest)this.contextHttpServletRequest, null).build());
        this._createNavigationMenuItems(navigationMenu.getNavigationMenuItems(), 0L, groupId, siteNavigationMenu.getSiteNavigationMenuId());
        return this._toNavigationMenu(siteNavigationMenu);
    }

    private void _createNavigationMenuItem(NavigationMenuItem navigationMenuItem, long parentNavigationMenuId, long groupId, long siteNavigationMenuId) throws Exception {
        UnicodeProperties unicodeProperties = UnicodePropertiesBuilder.putAll((Map)navigationMenuItem.getTypeSettings()).build();
        SiteNavigationMenuItem siteNavigationMenuItem = this._siteNavigationMenuItemService.addSiteNavigationMenuItem(null, groupId, siteNavigationMenuId, parentNavigationMenuId, navigationMenuItem.getType(), unicodeProperties.toString(), ServiceContextBuilder.create((long)groupId, (HttpServletRequest)this.contextHttpServletRequest, null).expandoBridgeAttributes(CustomFieldsUtil.toMap((String)SiteNavigationMenuItem.class.getName(), (long)this.contextCompany.getCompanyId(), (CustomField[])navigationMenuItem.getCustomFields(), (Locale)this.contextAcceptLanguage.getPreferredLocale())).build());
        this._createNavigationMenuItems(navigationMenuItem.getNavigationMenuItems(), siteNavigationMenuItem.getSiteNavigationMenuItemId(), groupId, siteNavigationMenuId);
    }

    private void _createNavigationMenuItems(NavigationMenuItem[] navigationMenuItems, long parentNavigationMenuId, long groupId, long siteNavigationMenuId) throws Exception {
        if (navigationMenuItems == null) {
            return;
        }
        for (NavigationMenuItem navigationMenuItem : navigationMenuItems) {
            this._createNavigationMenuItem(navigationMenuItem, parentNavigationMenuId, groupId, siteNavigationMenuId);
        }
    }

    private void _deleteNavigationMenuItems(List<SiteNavigationMenuItem> siteNavigationMenuItems) throws Exception {
        for (SiteNavigationMenuItem siteNavigationMenuItem : siteNavigationMenuItems) {
            this._siteNavigationMenuItemService.deleteSiteNavigationMenuItem(siteNavigationMenuItem.getSiteNavigationMenuItemId(), true);
        }
    }

    private Layout _getLayout(SiteNavigationMenuItem siteNavigationMenuItem) {
        UnicodeProperties unicodeProperties = this._getUnicodeProperties(siteNavigationMenuItem);
        String layoutUuid = (String)unicodeProperties.get((Object)"layoutUuid");
        boolean privateLayout = GetterUtil.getBoolean((String)((String)unicodeProperties.get((Object)"privateLayout")));
        return this._layoutLocalService.fetchLayoutByUuidAndGroupId(layoutUuid, siteNavigationMenuItem.getGroupId(), privateLayout);
    }

    private Locale _getLocaleFromProperty(Map.Entry<String, String> property) {
        return LocaleUtil.fromLanguageId((String)StringUtil.removeSubstring((String)property.getKey(), (String)"name_"));
    }

    private Map<Locale, String> _getLocalizedNamesFromProperties(UnicodeProperties unicodeProperties) {
        if (unicodeProperties == null) {
            return new HashMap<Locale, String>();
        }
        HashMap<Locale, String> properties = new HashMap<Locale, String>();
        for (Map.Entry entry : unicodeProperties.entrySet()) {
            if (!this._isNameProperty(entry)) continue;
            properties.put(this._getLocaleFromProperty(entry), (String)entry.getValue());
        }
        return properties;
    }

    private String _getName(Layout layout, String type, UnicodeProperties unicodeProperties, boolean useCustomName) throws JSONException {
        String defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault());
        String preferredLanguageId = this.contextAcceptLanguage.getPreferredLanguageId();
        if (StringUtil.equals((String)type, (String)"page")) {
            if (!useCustomName && layout == null) {
                return null;
            }
            if (!useCustomName && layout != null) {
                return layout.getName(this.contextAcceptLanguage.getPreferredLocale());
            }
            if (!useCustomName) {
                return null;
            }
            return unicodeProperties.getProperty("name_" + preferredLanguageId, unicodeProperties.getProperty("name_" + defaultLanguageId));
        }
        if (useCustomName) {
            JSONObject customNameJSONObject = this._jsonFactory.createJSONObject(unicodeProperties.getProperty("localizedNames"));
            return customNameJSONObject.getString(preferredLanguageId, customNameJSONObject.getString(defaultLanguageId));
        }
        if (StringUtil.equals((String)type, (String)"navigationMenu") || StringUtil.equals((String)type, (String)"url")) {
            return unicodeProperties.getProperty("name_" + preferredLanguageId, unicodeProperties.getProperty("name_" + defaultLanguageId));
        }
        return unicodeProperties.getProperty("title");
    }

    private int _getNavigationMenuType(NavigationMenu navigationMenu) {
        int type = 0;
        NavigationMenu.NavigationType navigationType = navigationMenu.getNavigationType();
        if (navigationType != null) {
            type = navigationType.ordinal() + 1;
        }
        return type;
    }

    private Map<Long, List<SiteNavigationMenuItem>> _getSiteNavigationMenuItemsMap(List<SiteNavigationMenuItem> siteNavigationMenuItems) {
        HashMap<Long, List<SiteNavigationMenuItem>> siteNavigationMenuItemsMap = new HashMap<Long, List<SiteNavigationMenuItem>>();
        for (SiteNavigationMenuItem siteNavigationMenuItem : siteNavigationMenuItems) {
            long parentSiteNavigationMenuItemId = siteNavigationMenuItem.getParentSiteNavigationMenuItemId();
            if (siteNavigationMenuItemsMap.containsKey(parentSiteNavigationMenuItemId)) continue;
            for (SiteNavigationMenuItem childSiteNavigationMenuItem : siteNavigationMenuItems) {
                if (parentSiteNavigationMenuItemId != childSiteNavigationMenuItem.getParentSiteNavigationMenuItemId()) continue;
                List parentSiteNavigationMenuItems = siteNavigationMenuItemsMap.getOrDefault(parentSiteNavigationMenuItemId, new ArrayList());
                parentSiteNavigationMenuItems.add(childSiteNavigationMenuItem);
                siteNavigationMenuItemsMap.put(parentSiteNavigationMenuItemId, parentSiteNavigationMenuItems);
            }
        }
        return siteNavigationMenuItemsMap;
    }

    private UnicodeProperties _getUnicodeProperties(SiteNavigationMenuItem siteNavigationMenuItem) {
        if (siteNavigationMenuItem == null) {
            return null;
        }
        return UnicodePropertiesBuilder.fastLoad((String)siteNavigationMenuItem.getTypeSettings()).build();
    }

    private boolean _isAuto(Boolean auto) {
        if (auto == null) {
            return true;
        }
        return auto;
    }

    private boolean _isNameProperty(Map.Entry<String, String> entry) {
        String key = entry.getKey();
        return key.startsWith("name_");
    }

    private NavigationMenu _toNavigationMenu(final SiteNavigationMenu siteNavigationMenu) {
        return new NavigationMenu(){
            {
                this.setActions(() -> HashMapBuilder.put((Object)"delete", NavigationMenuResourceImpl.this.addAction("DELETE", (GroupedModel)siteNavigationMenu, "deleteSiteNavigationMenu")).put((Object)"replace", NavigationMenuResourceImpl.this.addAction("UPDATE", (GroupedModel)siteNavigationMenu, "putSiteNavigationMenu")).build());
                this.setAuto(() -> ((SiteNavigationMenu)siteNavigationMenu).getAuto());
                this.setCreator(() -> {
                    final User user = NavigationMenuResourceImpl.this._userLocalService.fetchUser(siteNavigationMenu.getUserId());
                    if (user == null) {
                        return null;
                    }
                    return new Creator(){
                        {
                            this.setExternalReferenceCode(() -> ((User)user).getExternalReferenceCode());
                        }
                    };
                });
                this.setDateCreated(() -> ((SiteNavigationMenu)siteNavigationMenu).getCreateDate());
                this.setDateModified(() -> ((SiteNavigationMenu)siteNavigationMenu).getModifiedDate());
                this.setExternalReferenceCode(() -> ((SiteNavigationMenu)siteNavigationMenu).getExternalReferenceCode());
                this.setId(() -> ((SiteNavigationMenu)siteNavigationMenu).getSiteNavigationMenuId());
                this.setName(() -> ((SiteNavigationMenu)siteNavigationMenu).getName());
                this.setNavigationMenuItems(() -> {
                    Map<Long, List<SiteNavigationMenuItem>> siteNavigationMenuItemsMap = NavigationMenuResourceImpl.this._getSiteNavigationMenuItemsMap(NavigationMenuResourceImpl.this._siteNavigationMenuItemService.getSiteNavigationMenuItems(siteNavigationMenu.getSiteNavigationMenuId(), (OrderByComparator)SiteNavigationMenuItemOrderComparator.getInstance((boolean)true)));
                    return NavigationMenuResourceImpl.this.transformToArray(siteNavigationMenuItemsMap.getOrDefault(0L, new ArrayList()), siteNavigationMenuItem -> NavigationMenuResourceImpl.this._toNavigationMenuItem((SiteNavigationMenuItem)siteNavigationMenuItem, siteNavigationMenuItemsMap), NavigationMenuItem.class);
                });
                this.setNavigationType(() -> {
                    if (siteNavigationMenu.getType() == 0) {
                        return null;
                    }
                    return NavigationMenu.NavigationType.values()[siteNavigationMenu.getType() - 1];
                });
                this.setPermissions(() -> NavigationMenuResourceImpl.this._toPermissions(siteNavigationMenu));
                this.setSiteExternalReferenceCode(() -> {
                    Group group = NavigationMenuResourceImpl.this._groupLocalService.fetchGroup(siteNavigationMenu.getGroupId());
                    if (group != null) {
                        return group.getExternalReferenceCode();
                    }
                    return "";
                });
            }
        };
    }

    private NavigationMenuItem _toNavigationMenuItem(final SiteNavigationMenuItem siteNavigationMenuItem, final Map<Long, List<SiteNavigationMenuItem>> siteNavigationMenuItemsMap) {
        final Layout layout = this._getLayout(siteNavigationMenuItem);
        final UnicodeProperties unicodeProperties = this._getUnicodeProperties(siteNavigationMenuItem);
        final String navigationMenuItemType = this._toType(siteNavigationMenuItem.getType());
        return new NavigationMenuItem(){
            {
                this.setAvailableLanguages(() -> {
                    Map<Locale, String> localizedMap = NavigationMenuResourceImpl.this._getLocalizedNamesFromProperties(unicodeProperties);
                    Set<Locale> locales = localizedMap.keySet();
                    return LocaleUtil.toW3cLanguageIds((Locale[])locales.toArray(new Locale[localizedMap.size()]));
                });
                this.setCreator(() -> {
                    final User user = NavigationMenuResourceImpl.this._userLocalService.fetchUser(siteNavigationMenuItem.getUserId());
                    if (user == null) {
                        return null;
                    }
                    return new Creator(){
                        {
                            this.setExternalReferenceCode(() -> ((User)user).getExternalReferenceCode());
                        }
                    };
                });
                this.setCustomFields(() -> CustomFieldsUtil.toCustomFields((boolean)NavigationMenuResourceImpl.this.contextAcceptLanguage.isAcceptAllLanguages(), (String)SiteNavigationMenuItem.class.getName(), (long)siteNavigationMenuItem.getSiteNavigationMenuItemId(), (long)siteNavigationMenuItem.getCompanyId(), (Locale)NavigationMenuResourceImpl.this.contextAcceptLanguage.getPreferredLocale()));
                this.setDateCreated(() -> ((SiteNavigationMenuItem)siteNavigationMenuItem).getCreateDate());
                this.setDateModified(() -> ((SiteNavigationMenuItem)siteNavigationMenuItem).getModifiedDate());
                this.setExternalReferenceCode(() -> ((SiteNavigationMenuItem)siteNavigationMenuItem).getExternalReferenceCode());
                this.setId(() -> ((SiteNavigationMenuItem)siteNavigationMenuItem).getSiteNavigationMenuItemId());
                this.setName(() -> NavigationMenuResourceImpl.this._getName(layout, navigationMenuItemType, unicodeProperties, this.getUseCustomName()));
                this.setName_i18n(() -> {
                    if (!NavigationMenuResourceImpl.this.contextAcceptLanguage.isAcceptAllLanguages()) {
                        return null;
                    }
                    Map localizedNames = NavigationMenuResourceImpl.this._getLocalizedNamesFromProperties(unicodeProperties);
                    if ((!this.useCustomName.booleanValue() || localizedNames.isEmpty()) && layout != null) {
                        localizedNames = layout.getNameMap();
                    }
                    return LocalizedMapUtil.getI18nMap(localizedNames);
                });
                this.setNavigationMenuItems(() -> NavigationMenuResourceImpl.this.transformToArray(siteNavigationMenuItemsMap.getOrDefault(siteNavigationMenuItem.getSiteNavigationMenuItemId(), new ArrayList()), item -> NavigationMenuResourceImpl.this._toNavigationMenuItem((SiteNavigationMenuItem)item, siteNavigationMenuItemsMap), NavigationMenuItem.class));
                this.setType(() -> ((SiteNavigationMenuItem)siteNavigationMenuItem).getType());
                this.setTypeSettings(() -> unicodeProperties);
                this.setUseCustomName(() -> Boolean.valueOf(unicodeProperties.getProperty("useCustomName")));
            }
        };
    }

    private Permission[] _toPermissions(SiteNavigationMenu siteNavigationMenu) throws Exception {
        return (Permission[])NestedFieldsSupplier.supply((String)"permissions", nestedFieldNames -> {
            this._permissionService.checkPermission(siteNavigationMenu.getGroupId(), siteNavigationMenu.getModelClassName(), siteNavigationMenu.getSiteNavigationMenuId());
            Collection permissions = PermissionUtil.getPermissions((long)siteNavigationMenu.getCompanyId(), (List)this._resourceActionLocalService.getResourceActions(siteNavigationMenu.getModelClassName()), (long)siteNavigationMenu.getSiteNavigationMenuId(), (String)siteNavigationMenu.getModelClassName(), null);
            return permissions.toArray(new Permission[0]);
        });
    }

    private String _toType(String type) {
        if (type.equals("layout")) {
            return "page";
        }
        if (type.equals("node")) {
            return "navigationMenu";
        }
        if (type.equals(FileEntry.class.getName())) {
            return DLFileEntry.class.getName();
        }
        return type;
    }

    private NavigationMenu _updateNavigationMenu(NavigationMenu navigationMenu, SiteNavigationMenu siteNavigationMenu) throws Exception {
        this._updateNavigationMenuItems(navigationMenu.getNavigationMenuItems(), 0L, siteNavigationMenu.getGroupId(), siteNavigationMenu.getSiteNavigationMenuId());
        ServiceContext serviceContext = ServiceContextBuilder.create((long)siteNavigationMenu.getGroupId(), (HttpServletRequest)this.contextHttpServletRequest, null).build();
        this._siteNavigationMenuService.updateSiteNavigationMenu(siteNavigationMenu.getSiteNavigationMenuId(), this._getNavigationMenuType(navigationMenu), this._isAuto(navigationMenu.getAuto()), serviceContext);
        return this._toNavigationMenu(this._siteNavigationMenuService.updateSiteNavigationMenu(siteNavigationMenu.getSiteNavigationMenuId(), navigationMenu.getName(), serviceContext));
    }

    private void _updateNavigationMenuItems(NavigationMenuItem[] navigationMenuItems, long parentSiteNavigationMenuItemId, long groupId, long siteNavigationMenuId) throws Exception {
        ArrayList<SiteNavigationMenuItem> siteNavigationMenuItems = new ArrayList<SiteNavigationMenuItem>(this._siteNavigationMenuItemService.getSiteNavigationMenuItems(siteNavigationMenuId, parentSiteNavigationMenuItemId));
        if (navigationMenuItems == null) {
            this._deleteNavigationMenuItems(siteNavigationMenuItems);
            return;
        }
        for (NavigationMenuItem navigationMenuItem : navigationMenuItems) {
            String navigationMenuItemExternalReferenceCode = navigationMenuItem.getExternalReferenceCode();
            SiteNavigationMenuItem siteNavigationMenuItem = null;
            for (SiteNavigationMenuItem curSiteNavigationMenuItem : siteNavigationMenuItems) {
                if (!Objects.equals(navigationMenuItemExternalReferenceCode, curSiteNavigationMenuItem.getExternalReferenceCode())) continue;
                siteNavigationMenuItem = curSiteNavigationMenuItem;
                break;
            }
            if (siteNavigationMenuItem != null) {
                SiteNavigationMenuItem updatedSiteNavigationMenuItem = this._siteNavigationMenuItemService.updateSiteNavigationMenuItem(siteNavigationMenuItem.getSiteNavigationMenuItemId(), String.valueOf(navigationMenuItem.getTypeSettings()), ServiceContextBuilder.create((long)groupId, (HttpServletRequest)this.contextHttpServletRequest, null).expandoBridgeAttributes(CustomFieldsUtil.toMap((String)SiteNavigationMenuItem.class.getName(), (long)this.contextCompany.getCompanyId(), (CustomField[])navigationMenuItem.getCustomFields(), (Locale)this.contextAcceptLanguage.getPreferredLocale())).build());
                this._updateNavigationMenuItems(navigationMenuItem.getNavigationMenuItems(), updatedSiteNavigationMenuItem.getSiteNavigationMenuItemId(), groupId, siteNavigationMenuId);
                siteNavigationMenuItems.remove(siteNavigationMenuItem);
                continue;
            }
            this._createNavigationMenuItem(navigationMenuItem, parentSiteNavigationMenuItemId, groupId, siteNavigationMenuId);
        }
        this._deleteNavigationMenuItems(siteNavigationMenuItems);
    }
}

