/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.dto.v1_0.util;

import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LocalizedValueUtil {
    public static List<String> getAvailableLanguageIds() {
        return TransformUtil.transform((Collection)LanguageUtil.getAvailableLocales(), LanguageUtil::getLanguageId);
    }

    public static JSONObject toJSONObject(Map<String, String> localizedValues) {
        return LocalizedValueUtil.toJSONObject(localizedValues, value -> value);
    }

    public static <T, R, E extends Throwable> JSONObject toJSONObject(Map<String, T> localizedValues, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        List<String> availableLanguageIds = LocalizedValueUtil.getAvailableLanguageIds();
        for (Map.Entry<String, T> entry : localizedValues.entrySet()) {
            if (!availableLanguageIds.contains(entry.getKey())) continue;
            jsonObject.put(entry.getKey(), unsafeFunction.apply(entry.getValue()));
        }
        return jsonObject;
    }

    public static Map<String, String> toLocalizedValues(JSONObject jsonObject) {
        return LocalizedValueUtil.toLocalizedValues(jsonObject, key -> jsonObject.getString(key));
    }

    public static <R, E extends Throwable> Map<String, R> toLocalizedValues(final JSONObject jsonObject, final UnsafeFunction<String, R, E> unsafeFunction) throws E {
        return new HashMap<String, R>(){
            {
                List<String> availableLanguageIds = LocalizedValueUtil.getAvailableLanguageIds();
                for (String key : jsonObject.keySet()) {
                    if (!availableLanguageIds.contains(key)) continue;
                    this.put(key, unsafeFunction.apply((Object)key));
                }
            }
        };
    }
}

