/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.dto.v1_0.util;

import com.liferay.headless.admin.site.dto.v1_0.Layout;
import com.liferay.layout.converter.AlignConverter;
import com.liferay.layout.converter.ContentDisplayConverter;
import com.liferay.layout.converter.FlexWrapConverter;
import com.liferay.layout.converter.JustifyConverter;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Objects;

public class LayoutUtil {
    public static Layout toLayout(final JSONObject jsonObject) {
        if (JSONUtil.isEmpty((JSONObject)jsonObject) || jsonObject.getString("align", null) == null && jsonObject.getString("flexWrap", null) == null && jsonObject.getString("justify", null) == null && jsonObject.getString("widthType", null) == null) {
            return null;
        }
        return new Layout(){
            {
                this.setAlign(() -> {
                    String align = jsonObject.getString("align", null);
                    if (Validator.isNull((String)align)) {
                        return null;
                    }
                    return Layout.Align.create((String)AlignConverter.convertToExternalValue((String)align));
                });
                this.setContentDisplay(() -> {
                    String contentDisplay = jsonObject.getString("contentDisplay", null);
                    if (Validator.isNull((String)contentDisplay)) {
                        return null;
                    }
                    return Layout.ContentDisplay.create((String)ContentDisplayConverter.convertToExternalValue((String)GetterUtil.getString((String)contentDisplay)));
                });
                this.setFlexWrap(() -> {
                    String flexWrap = jsonObject.getString("flexWrap", null);
                    if (Validator.isNull((String)flexWrap)) {
                        return null;
                    }
                    return Layout.FlexWrap.create((String)FlexWrapConverter.convertToExternalValue((String)flexWrap));
                });
                this.setJustify(() -> {
                    String justify = jsonObject.getString("justify", null);
                    if (Validator.isNull((String)justify)) {
                        return null;
                    }
                    return Layout.Justify.create((String)JustifyConverter.convertToExternalValue((String)justify));
                });
                this.setWidthType(() -> {
                    String widthType = jsonObject.getString("widthType", null);
                    if (Validator.isNull((String)widthType) || Objects.equals(widthType, "fluid")) {
                        return null;
                    }
                    return Layout.WidthType.create((String)StringUtil.upperCaseFirstLetter((String)widthType));
                });
            }
        };
    }
}

