/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.dto.v1_0.util;

import com.liferay.headless.admin.site.dto.v1_0.FragmentViewport;
import com.liferay.layout.responsive.ViewportSize;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;

public class FragmentViewportUtil {
    public static FragmentViewport[] toFragmentViewports(JSONObject jsonObject) {
        FragmentViewport tabletFragmentViewport;
        FragmentViewport portraitMobileFragmentViewport;
        if (JSONUtil.isEmpty((JSONObject)jsonObject)) {
            return null;
        }
        ArrayList<FragmentViewport> fragmentViewports = new ArrayList<FragmentViewport>();
        FragmentViewport mobileLandscapeFragmentViewport = FragmentViewportUtil._toFragmentViewport(jsonObject, ViewportSize.MOBILE_LANDSCAPE);
        if (mobileLandscapeFragmentViewport != null) {
            fragmentViewports.add(mobileLandscapeFragmentViewport);
        }
        if ((portraitMobileFragmentViewport = FragmentViewportUtil._toFragmentViewport(jsonObject, ViewportSize.PORTRAIT_MOBILE)) != null) {
            fragmentViewports.add(portraitMobileFragmentViewport);
        }
        if ((tabletFragmentViewport = FragmentViewportUtil._toFragmentViewport(jsonObject, ViewportSize.TABLET)) != null) {
            fragmentViewports.add(tabletFragmentViewport);
        }
        if (ListUtil.isEmpty(fragmentViewports)) {
            return null;
        }
        return fragmentViewports.toArray(new FragmentViewport[0]);
    }

    public static JSONObject toFragmentViewportsJSONObject(FragmentViewport[] fragmentViewports) {
        if (ArrayUtil.isEmpty((Object[])fragmentViewports)) {
            return null;
        }
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        for (FragmentViewport fragmentViewport : fragmentViewports) {
            String customCSS = fragmentViewport.getCustomCSS();
            if (Validator.isNull((String)customCSS)) continue;
            jsonObject.put(fragmentViewport.getId(), JSONUtil.put((String)"customCSS", (Object)customCSS));
        }
        return jsonObject;
    }

    private static FragmentViewport _toFragmentViewport(JSONObject jsonObject, final ViewportSize viewportSize) {
        final JSONObject viewportJSONObject = jsonObject.getJSONObject(viewportSize.getViewportSizeId());
        if (JSONUtil.isEmpty((JSONObject)viewportJSONObject) || Validator.isNull((String)viewportJSONObject.getString("customCSS", null)) && JSONUtil.isEmpty((JSONObject)viewportJSONObject.getJSONObject("styles"))) {
            return null;
        }
        return new FragmentViewport(){
            {
                this.setCustomCSS(() -> viewportJSONObject.getString("customCSS", null));
                this.setId(() -> ((ViewportSize)viewportSize).getViewportSizeId());
            }
        };
    }
}

