/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.dto.v1_0.converter;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetVocabularyLocalService;
import com.liferay.fragment.util.configuration.FragmentConfigurationField;
import com.liferay.headless.admin.site.dto.v1_0.CategoryFragmentConfigurationFieldValue;
import com.liferay.headless.admin.site.dto.v1_0.CheckboxFragmentConfigurationFieldValue;
import com.liferay.headless.admin.site.dto.v1_0.CollectionFragmentConfigurationFieldValue;
import com.liferay.headless.admin.site.dto.v1_0.FragmentConfigurationFieldValue;
import com.liferay.headless.admin.site.dto.v1_0.ItemExternalReference;
import com.liferay.headless.admin.site.dto.v1_0.LengthFragmentConfigurationFieldValue;
import com.liferay.headless.admin.site.dto.v1_0.SelectFragmentConfigurationFieldValue;
import com.liferay.headless.admin.site.dto.v1_0.TextFragmentConfigurationFieldValue;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.CollectionUtil;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.FragmentConfigurationFieldValueTypeUtil;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.ItemScopeUtil;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.LocalizedValueUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.scope.Scope;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.fragment.util.configuration.FragmentConfigurationField"}, service={DTOConverter.class})
public class FragmentConfigurationFieldValueDTOConverter
implements DTOConverter<FragmentConfigurationField, FragmentConfigurationFieldValue> {
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private AssetVocabularyLocalService _assetVocabularyLocalService;

    public String getContentType() {
        return FragmentConfigurationFieldValue.class.getSimpleName();
    }

    public FragmentConfigurationFieldValue toDTO(DTOConverterContext dtoConverterContext, FragmentConfigurationField fragmentConfigurationField) throws Exception {
        if (dtoConverterContext == null) {
            return null;
        }
        Object fragmentFragmentConfigurationFieldValue = dtoConverterContext.getAttribute("fragmentFragmentConfigurationFieldValue");
        if (fragmentFragmentConfigurationFieldValue == null) {
            return null;
        }
        FragmentConfigurationFieldValue.Type type = FragmentConfigurationFieldValueTypeUtil.toExternalType(fragmentConfigurationField.getType());
        if (Objects.equals(type, FragmentConfigurationFieldValue.Type.CATEGORY)) {
            return this._getCategoryFragmentConfigurationFieldValue(dtoConverterContext, fragmentConfigurationField, (JSONObject)fragmentFragmentConfigurationFieldValue);
        }
        if (Objects.equals(type, FragmentConfigurationFieldValue.Type.CHECKBOX)) {
            return this._getCheckboxFragmentConfigurationFieldValue(fragmentConfigurationField, fragmentFragmentConfigurationFieldValue);
        }
        if (Objects.equals(type, FragmentConfigurationFieldValue.Type.COLLECTION)) {
            return this._getCollectionFragmentConfigurationFieldValue(dtoConverterContext, fragmentConfigurationField, (JSONObject)fragmentFragmentConfigurationFieldValue);
        }
        if (Objects.equals(type, FragmentConfigurationFieldValue.Type.LENGTH)) {
            return this._getLengthFragmentConfigurationFieldValue(fragmentConfigurationField, fragmentFragmentConfigurationFieldValue);
        }
        if (Objects.equals(type, FragmentConfigurationFieldValue.Type.SELECT)) {
            return this._getSelectFragmentConfigurationFieldValue(fragmentConfigurationField, fragmentFragmentConfigurationFieldValue);
        }
        if (Objects.equals(type, FragmentConfigurationFieldValue.Type.TEXT)) {
            return this._getTextFragmentConfigurationFieldValue(fragmentConfigurationField, fragmentFragmentConfigurationFieldValue);
        }
        return null;
    }

    private FragmentConfigurationFieldValue _getCategoryFragmentConfigurationFieldValue(DTOConverterContext dtoConverterContext, FragmentConfigurationField fragmentConfigurationField, JSONObject jsonObject) {
        Long companyId = (Long)dtoConverterContext.getAttribute("companyId");
        Long scopeGroupId = (Long)dtoConverterContext.getAttribute("scopeGroupId");
        if (companyId == null || scopeGroupId == null) {
            throw new UnsupportedOperationException();
        }
        CategoryFragmentConfigurationFieldValue categoryFragmentConfigurationFieldValue = new CategoryFragmentConfigurationFieldValue();
        if (fragmentConfigurationField.isLocalizable()) {
            categoryFragmentConfigurationFieldValue.setValue_i18n(() -> LocalizedValueUtil.toLocalizedValues(jsonObject, key -> this._getCategoryTreeNodeItemExternalReference(companyId, jsonObject.getJSONObject(key), scopeGroupId)));
        } else {
            categoryFragmentConfigurationFieldValue.setValue(() -> this._getCategoryTreeNodeItemExternalReference(companyId, jsonObject, scopeGroupId));
        }
        return categoryFragmentConfigurationFieldValue;
    }

    private ItemExternalReference _getCategoryTreeNodeItemExternalReference(long companyId, JSONObject jsonObject, long scopeGroupId) throws Exception {
        if (JSONUtil.isEmpty((JSONObject)jsonObject)) {
            return null;
        }
        long categoryTreeNodeId = jsonObject.getLong("categoryTreeNodeId");
        String categoryTreeNodeType = jsonObject.getString("categoryTreeNodeType");
        String externalReferenceCode = jsonObject.getString("externalReferenceCode");
        if (categoryTreeNodeId == 0L && Validator.isNull((String)externalReferenceCode) || !Objects.equals(categoryTreeNodeType, "Category") && !Objects.equals(categoryTreeNodeType, "Vocabulary")) {
            return null;
        }
        if (categoryTreeNodeId == 0L) {
            String className = AssetCategory.class.getName();
            if (Objects.equals(categoryTreeNodeType, "Vocabulary")) {
                className = AssetVocabulary.class.getName();
            }
            return this._getItemExternalReference(className, externalReferenceCode, ItemScopeUtil.getItemScope(companyId, jsonObject.getString("scopeExternalReferenceCode"), scopeGroupId));
        }
        if (Objects.equals(categoryTreeNodeType, "Category")) {
            AssetCategory assetCategory = this._assetCategoryLocalService.fetchAssetCategory(categoryTreeNodeId);
            if (assetCategory == null) {
                return this._getItemExternalReference(AssetCategory.class.getName(), externalReferenceCode, ItemScopeUtil.getItemScope(companyId, jsonObject.getString("scopeExternalReferenceCode"), scopeGroupId));
            }
            return this._getItemExternalReference(AssetCategory.class.getName(), assetCategory.getExternalReferenceCode(), ItemScopeUtil.getItemScope(assetCategory.getGroupId(), scopeGroupId));
        }
        AssetVocabulary assetVocabulary = this._assetVocabularyLocalService.fetchAssetVocabulary(categoryTreeNodeId);
        if (assetVocabulary == null) {
            return this._getItemExternalReference(AssetVocabulary.class.getName(), externalReferenceCode, ItemScopeUtil.getItemScope(companyId, jsonObject.getString("scopeExternalReferenceCode"), scopeGroupId));
        }
        return this._getItemExternalReference(AssetVocabulary.class.getName(), assetVocabulary.getExternalReferenceCode(), ItemScopeUtil.getItemScope(assetVocabulary.getGroupId(), scopeGroupId));
    }

    private FragmentConfigurationFieldValue _getCheckboxFragmentConfigurationFieldValue(FragmentConfigurationField fragmentConfigurationField, Object fragmentFragmentConfigurationFieldValue) {
        CheckboxFragmentConfigurationFieldValue checkboxFragmentConfigurationFieldValue = new CheckboxFragmentConfigurationFieldValue();
        if (fragmentConfigurationField.isLocalizable()) {
            JSONObject jsonObject = (JSONObject)fragmentFragmentConfigurationFieldValue;
            checkboxFragmentConfigurationFieldValue.setValue_i18n(() -> LocalizedValueUtil.toLocalizedValues(jsonObject, key -> jsonObject.getBoolean(key)));
        } else {
            checkboxFragmentConfigurationFieldValue.setValue(() -> GetterUtil.getBoolean((Object)fragmentFragmentConfigurationFieldValue));
        }
        return checkboxFragmentConfigurationFieldValue;
    }

    private FragmentConfigurationFieldValue _getCollectionFragmentConfigurationFieldValue(DTOConverterContext dtoConverterContext, FragmentConfigurationField fragmentConfigurationField, JSONObject jsonObject) {
        Long companyId = (Long)dtoConverterContext.getAttribute("companyId");
        Long scopeGroupId = (Long)dtoConverterContext.getAttribute("scopeGroupId");
        if (companyId == null || scopeGroupId == null) {
            throw new UnsupportedOperationException();
        }
        CollectionFragmentConfigurationFieldValue collectionFragmentConfigurationFieldValue = new CollectionFragmentConfigurationFieldValue(){
            {
                this.setType(FragmentConfigurationFieldValue.Type.COLLECTION);
            }
        };
        if (fragmentConfigurationField.isLocalizable()) {
            collectionFragmentConfigurationFieldValue.setValue_i18n(() -> LocalizedValueUtil.toLocalizedValues(jsonObject, key -> CollectionUtil.getCollectionReference(companyId, jsonObject.getJSONObject(key), scopeGroupId)));
        } else {
            collectionFragmentConfigurationFieldValue.setValue(() -> CollectionUtil.getCollectionReference(companyId, jsonObject, scopeGroupId));
        }
        return collectionFragmentConfigurationFieldValue;
    }

    private ItemExternalReference _getItemExternalReference(String className, String externalReferenceCode, Scope scope) {
        ItemExternalReference itemExternalReference = new ItemExternalReference();
        itemExternalReference.setClassName(() -> className);
        itemExternalReference.setExternalReferenceCode(() -> externalReferenceCode);
        itemExternalReference.setScope(() -> scope);
        return itemExternalReference;
    }

    private FragmentConfigurationFieldValue _getLengthFragmentConfigurationFieldValue(FragmentConfigurationField fragmentConfigurationField, Object fragmentFragmentConfigurationFieldValue) {
        LengthFragmentConfigurationFieldValue lengthFragmentConfigurationFieldValue = new LengthFragmentConfigurationFieldValue(){
            {
                this.setType(FragmentConfigurationFieldValue.Type.LENGTH);
            }
        };
        if (fragmentConfigurationField.isLocalizable()) {
            JSONObject jsonObject = (JSONObject)fragmentFragmentConfigurationFieldValue;
            lengthFragmentConfigurationFieldValue.setValue_i18n(() -> LocalizedValueUtil.toLocalizedValues(jsonObject));
        } else {
            lengthFragmentConfigurationFieldValue.setValue(() -> GetterUtil.getString((Object)fragmentFragmentConfigurationFieldValue));
        }
        return lengthFragmentConfigurationFieldValue;
    }

    private FragmentConfigurationFieldValue _getSelectFragmentConfigurationFieldValue(FragmentConfigurationField fragmentConfigurationField, Object fragmentFragmentConfigurationFieldValue) {
        SelectFragmentConfigurationFieldValue selectFragmentConfigurationFieldValue = new SelectFragmentConfigurationFieldValue(){
            {
                this.setType(FragmentConfigurationFieldValue.Type.SELECT);
            }
        };
        if (fragmentConfigurationField.isLocalizable()) {
            JSONObject jsonObject = (JSONObject)fragmentFragmentConfigurationFieldValue;
            selectFragmentConfigurationFieldValue.setValue_i18n(() -> LocalizedValueUtil.toLocalizedValues(jsonObject));
        } else {
            selectFragmentConfigurationFieldValue.setValue(() -> GetterUtil.getString((Object)fragmentFragmentConfigurationFieldValue));
        }
        return selectFragmentConfigurationFieldValue;
    }

    private FragmentConfigurationFieldValue _getTextFragmentConfigurationFieldValue(FragmentConfigurationField fragmentConfigurationField, Object fragmentFragmentConfigurationFieldValue) {
        TextFragmentConfigurationFieldValue textFragmentConfigurationFieldValue = new TextFragmentConfigurationFieldValue(){
            {
                this.setType(FragmentConfigurationFieldValue.Type.TEXT);
            }
        };
        if (fragmentConfigurationField.isLocalizable()) {
            JSONObject jsonObject = (JSONObject)fragmentFragmentConfigurationFieldValue;
            textFragmentConfigurationFieldValue.setValue_i18n(() -> LocalizedValueUtil.toLocalizedValues(jsonObject));
        } else {
            textFragmentConfigurationFieldValue.setValue(() -> GetterUtil.getString((Object)fragmentFragmentConfigurationFieldValue));
        }
        return textFragmentConfigurationFieldValue;
    }
}

